/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javascript;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesAddedFunctions;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesDummy;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesHelp;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesMeta;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesScript;
import org.apache.hop.pipeline.transforms.rowgenerator.GeneratorField;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.JavaScriptStyledTextComp;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class ScriptValuesDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ScriptValuesMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_TITLE = "ScriptValuesDialogMod.TestFailed.DialogTitle";
    public static final String CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_MESSAGE = "ScriptValuesDialogMod.TestFailed.DialogMessage";
    public static final String CONST_SKIP_PIPELINE = "SKIP_PIPELINE";
    public static final String CONST_ERROR_PIPELINE = "ERROR_PIPELINE";
    public static final String CONST_ABORT_PIPELINE = "ABORT_PIPELINE";
    public static final String CONST_CONTINUE_PIPELINE = "CONTINUE_PIPELINE";
    public static final String CONST_FUNCTION = "Function";
    public static final String CONST_JS_FUNCTION = "jsFunction";
    private ModifyListener lsMod;
    private TableView wFields;
    private Label wlPosition;
    private Tree wTree;
    private TreeItem wTreeScriptsItem;
    private TreeItem wTreeClassesitem;
    private Image imageActiveScript = null;
    private Image imageInactiveScript = null;
    private Image imageActiveStartScript = null;
    private Image imageActiveEndScript = null;
    private CTabFolder folder;
    private Menu cMenu;
    private Menu tMenu;
    private TreeItem[] lastItem;
    private TreeEditor editor;
    private static final int DELETE_ITEM = 0;
    private static final int ADD_ITEM = 1;
    private static final int RENAME_ITEM = 2;
    private static final int SET_ACTIVE_ITEM = 3;
    private static final int ADD_COPY = 2;
    private static final int ADD_BLANK = 1;
    private static final int ADD_DEFAULT = 0;
    private String strActiveScript;
    private String strActiveStartScript;
    private String strActiveEndScript;
    private static final String[] jsFunctionList = ScriptValuesAddedFunctions.jsFunctionList;
    private final ScriptValuesMeta input;
    private ScriptValuesHelp scVHelp;
    private TextVar wOptimizationLevel;
    private TreeItem iteminput;
    private TreeItem itemoutput;
    private static final GuiResource guiresource = GuiResource.getInstance();
    private IRowMeta rowPrevTransformFields;
    private RowGeneratorMeta genMeta;

    public ScriptValuesDialog(Shell parent, IVariables variables, ScriptValuesMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.genMeta = null;
        try {
            this.imageActiveScript = guiresource.getImage("ui/images/script-active.svg");
            this.imageInactiveScript = guiresource.getImage("ui/images/script-inactive.svg");
            this.imageActiveStartScript = guiresource.getImage("ui/images/script-start.svg");
            this.imageActiveEndScript = guiresource.getImage("ui/images/script-end.svg");
        }
        catch (Exception e) {
            this.imageActiveScript = guiresource.getImageEmpty();
            this.imageInactiveScript = guiresource.getImageEmpty();
            this.imageActiveStartScript = guiresource.getImageEmpty();
            this.imageActiveEndScript = guiresource.getImageEmpty();
        }
        try {
            this.scVHelp = new ScriptValuesHelp("org/apache/hop/pipeline/transforms/javascript/jsFunctionHelp.xml");
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Unexpected error", "There was an unexpected error reading the javascript functions help", e);
        }
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wVars = new Button((Composite)this.shell, 8);
        wVars.addListener(13, e -> this.test(true, true));
        wVars.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.GetVariables.Button", (String[])new String[0]));
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.TestScript.Button", (String[])new String[0]));
        wTest.addListener(13, e -> this.newTest());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wVars, wTest, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        SashForm wSash = new SashForm((Composite)this.shell, 512);
        Composite wTop = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wTop);
        FormLayout topLayout = new FormLayout();
        topLayout.marginWidth = PropsUi.getFormMargin();
        topLayout.marginHeight = PropsUi.getFormMargin();
        wTop.setLayout((Layout)topLayout);
        Label wlScriptFunctions = new Label(wTop, 0);
        wlScriptFunctions.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.JavascriptFunctions.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScriptFunctions);
        FormData fdlScriptFunctions = new FormData();
        fdlScriptFunctions.left = new FormAttachment(0, 0);
        fdlScriptFunctions.top = new FormAttachment(0, 0);
        wlScriptFunctions.setLayoutData((Object)fdlScriptFunctions);
        this.wTree = new Tree(wTop, 2816);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdlTree = new FormData();
        fdlTree.left = new FormAttachment(0, 0);
        fdlTree.top = new FormAttachment((Control)wlScriptFunctions, margin);
        fdlTree.right = new FormAttachment(20, 0);
        fdlTree.bottom = new FormAttachment(100, -margin);
        this.wTree.setLayoutData((Object)fdlTree);
        Label wlScript = new Label(wTop, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Javascript.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment((Control)this.wTree, margin);
        fdlScript.top = new FormAttachment(0, 0);
        wlScript.setLayoutData((Object)fdlScript);
        Label wlOptimizationLevel = new Label(wTop, 0);
        wlOptimizationLevel.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.OptimizationLevel.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOptimizationLevel);
        FormData fdlOptimizationLevel = new FormData();
        fdlOptimizationLevel.left = new FormAttachment((Control)this.wTree, margin * 2);
        fdlOptimizationLevel.bottom = new FormAttachment(100, -margin);
        wlOptimizationLevel.setLayoutData((Object)fdlOptimizationLevel);
        this.wOptimizationLevel = new TextVar(this.variables, wTop, 18436);
        this.wOptimizationLevel.setToolTipText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.OptimizationLevel.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOptimizationLevel);
        FormData fdOptimizationLevel = new FormData();
        fdOptimizationLevel.left = new FormAttachment((Control)wlOptimizationLevel, margin);
        fdOptimizationLevel.top = new FormAttachment((Control)wlOptimizationLevel, 0, 0x1000000);
        fdOptimizationLevel.right = new FormAttachment(100, margin);
        this.wOptimizationLevel.setLayoutData((Object)fdOptimizationLevel);
        this.wOptimizationLevel.addModifyListener(this.lsMod);
        this.wlPosition = new Label(wTop, 16384);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Position.Label", (Object[])new Object[]{1, 1}));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment((Control)this.wTree, 2 * margin);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment((Control)this.wOptimizationLevel, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.folder = new CTabFolder(wTop, 2064);
        PropsUi.setLook((Widget)this.folder, (int)4);
        this.folder.setUnselectedImageVisible(true);
        this.folder.setUnselectedCloseVisible(true);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment((Control)this.wTree, margin);
        fdScript.top = new FormAttachment((Control)wlScript, margin);
        fdScript.right = new FormAttachment(100, -5);
        fdScript.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.folder.setLayoutData((Object)fdScript);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment(100, 0);
        wTop.setLayoutData((Object)fdTop);
        Composite wBottom = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wBottom);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wSeparator = new Label(wBottom, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.right = new FormAttachment(100, 0);
        fdSeparator.top = new FormAttachment(0, -margin + 2);
        wSeparator.setLayoutData((Object)fdSeparator);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wSeparator, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getFieldname().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.Filename", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.RenameTo", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ColumnInfo.Replace", (String[])new String[0]), 2, YES_NO_COMBO)};
        this.wFields = new TableView(this.variables, wBottom, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.wTransformName, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wSash.setLayoutData((Object)fdSash);
        wSash.setWeights(new int[]{75, 25});
        this.wTree.addListener(8, this::treeDblClick);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem cItem = (CTabItem)event.item;
                event.doit = false;
                if (cItem != null && ScriptValuesDialog.this.folder.getItemCount() > 1) {
                    MessageBox messageBox = new MessageBox(ScriptValuesDialog.this.shell, 196);
                    messageBox.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.DeleteItem.Label", (String[])new String[0]));
                    messageBox.setMessage(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ConfirmDeleteItem.Label", (String[])new String[]{cItem.getText()}));
                    switch (messageBox.open()) {
                        case 64: {
                            ScriptValuesDialog.this.modifyScriptTree(cItem, 0);
                            event.doit = true;
                            break;
                        }
                    }
                }
            }
        });
        this.cMenu = new Menu((Decorations)this.shell, 8);
        this.buildingFolderMenu();
        this.tMenu = new Menu((Decorations)this.shell, 8);
        this.buildingTreeMenu();
        this.wTreeScriptsItem = new TreeItem(this.wTree, 0);
        this.wTreeScriptsItem.setImage(guiresource.getImageFolder());
        this.wTreeScriptsItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.TransformScript.Label", (String[])new String[0]));
        this.getData();
        this.buildSpecialFunctionsTree();
        this.iteminput = new TreeItem(this.wTree, 0);
        this.iteminput.setImage(guiresource.getImageInput());
        this.iteminput.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.InputFields.Label", (String[])new String[0]));
        this.itemoutput = new TreeItem(this.wTree, 0);
        this.itemoutput.setImage(guiresource.getImageOutput());
        this.itemoutput.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.OutputFields.Label", (String[])new String[0]));
        TreeItem itemWaitFieldsIn = new TreeItem(this.iteminput, 0);
        itemWaitFieldsIn.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsIn.setForeground(guiresource.getColorDirectory());
        this.iteminput.setExpanded(true);
        TreeItem itemWaitFieldsOut = new TreeItem(this.itemoutput, 0);
        itemWaitFieldsOut.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsOut.setForeground(guiresource.getColorDirectory());
        this.itemoutput.setExpanded(true);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    this.rowPrevTransformFields = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    if (this.rowPrevTransformFields != null) {
                        this.setInputOutputFields();
                    } else {
                        this.iteminput.removeAll();
                        this.itemoutput.removeAll();
                    }
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.buildAddClassesListTree();
        this.addRenameTowTreeScriptItems();
        this.input.setChanged(this.changed);
        DragSource ds = new DragSource((Control)this.wTree, 2);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                String strInsert;
                TreeItem item = ScriptValuesDialog.this.wTree.getSelection()[0];
                event.doit = item != null && item.getParentItem() != null ? (item.getParentItem().equals(ScriptValuesDialog.this.wTreeScriptsItem) ? false : (!item.getData().equals(ScriptValuesDialog.CONST_FUNCTION) ? (strInsert = (String)item.getData()).equals(ScriptValuesDialog.CONST_JS_FUNCTION) : false)) : false;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ScriptValuesDialog.this.wTree.getSelection()[0].getText();
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), this::cancel);
        return this.transformName;
    }

    private void setActiveCtab(String strName) {
        if (strName.isEmpty()) {
            this.folder.setSelection(0);
        } else {
            this.folder.setSelection(this.getCTabPosition(strName));
        }
    }

    private void addCtab(String cScriptName, String strScript, int iType) {
        StyledTextComp wScript;
        CTabItem item = new CTabItem(this.folder, 64);
        item.setFont(GuiResource.getInstance().getFontDefault());
        switch (iType) {
            case 0: {
                item.setText(cScriptName);
                break;
            }
            default: {
                item.setText(this.getNextName(cScriptName));
            }
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            wScript = new StyledTextComp(this.variables, (Composite)item.getParent(), 17154, false);
        } else {
            wScript = new JavaScriptStyledTextComp(this.variables, (Composite)item.getParent(), 17154, false);
            wScript.addLineStyleListener();
        }
        if (strScript != null && !strScript.isEmpty()) {
            wScript.setText(strScript);
        } else {
            wScript.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ScriptHere.Label", (String[])new String[0]) + Const.CR + Const.CR);
        }
        PropsUi.setLook((Widget)wScript, (int)1);
        Listener listener = arg_0 -> this.lambda$addCtab$7((TextComposite)wScript, arg_0);
        wScript.addListener(24, listener);
        wScript.addListener(1, listener);
        wScript.addListener(2, listener);
        wScript.addListener(15, listener);
        wScript.addListener(16, listener);
        wScript.addListener(8, listener);
        wScript.addListener(4, listener);
        wScript.addListener(3, listener);
        wScript.addModifyListener(this.lsMod);
        item.setImage(this.imageInactiveScript);
        item.setControl((Control)wScript);
        this.modifyScriptTree(item, 1);
    }

    private void modifyScriptTree(CTabItem ctabitem, int iModType) {
        switch (iModType) {
            case 0: {
                TreeItem dItem = this.getTreeItemByName(ctabitem.getText());
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case 1: {
                TreeItem item = new TreeItem(this.wTreeScriptsItem, 0);
                item.setImage(this.imageActiveScript);
                item.setText(ctabitem.getText());
                this.input.setChanged();
                break;
            }
            case 2: {
                this.input.setChanged();
                break;
            }
            case 3: {
                this.input.setChanged();
                break;
            }
        }
    }

    private TreeItem getTreeItemByName(String strTabName) {
        TreeItem[] tItems;
        for (TreeItem tItem : tItems = this.wTreeScriptsItem.getItems()) {
            if (!tItem.getText().equals(strTabName)) continue;
            return tItem;
        }
        return null;
    }

    private int getCTabPosition(String strTabName) {
        CTabItem[] cItems = this.folder.getItems();
        for (int i = 0; i < cItems.length; ++i) {
            if (!cItems[i].getText().equals(strTabName)) continue;
            return i;
        }
        return -1;
    }

    private CTabItem getCTabItemByName(String strTabName) {
        CTabItem[] cItems;
        for (CTabItem cItem : cItems = this.folder.getItems()) {
            if (!cItem.getText().equals(strTabName)) continue;
            return cItem;
        }
        return null;
    }

    private void modifyCTabItem(TreeItem tItem, int iModType, String strOption) {
        switch (iModType) {
            case 0: {
                CTabItem dItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case 2: {
                CTabItem rItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (rItem == null) break;
                rItem.setText(strOption);
                this.input.setChanged();
                if (rItem.getImage().equals((Object)this.imageActiveScript)) {
                    this.strActiveScript = strOption;
                    break;
                }
                if (rItem.getImage().equals((Object)this.imageActiveStartScript)) {
                    this.strActiveStartScript = strOption;
                    break;
                }
                if (!rItem.getImage().equals((Object)this.imageActiveEndScript)) break;
                this.strActiveEndScript = strOption;
                break;
            }
            case 3: {
                CTabItem aItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (aItem == null) break;
                this.input.setChanged();
                this.strActiveScript = tItem.getText();
                for (int i = 0; i < this.folder.getItemCount(); ++i) {
                    if (this.folder.getItem(i).equals(aItem)) {
                        aItem.setImage(this.imageActiveScript);
                        continue;
                    }
                    this.folder.getItem(i).setImage(this.imageInactiveScript);
                }
                break;
            }
        }
    }

    private TextComposite getStyledTextComp() {
        CTabItem item = this.folder.getSelection();
        if (item.getControl().isDisposed()) {
            return null;
        }
        return (TextComposite)item.getControl();
    }

    private TextComposite getStyledTextComp(CTabItem item) {
        return (TextComposite)item.getControl();
    }

    private String getNextName(String strActualName) {
        Object strRC = "";
        if (strActualName.isEmpty()) {
            strActualName = "Item";
        }
        int i = 0;
        strRC = strActualName + "_" + i;
        while (this.getCTabItemByName((String)strRC) != null) {
            strRC = strActualName + "_" + ++i;
        }
        return strRC;
    }

    public void setPosition(TextComposite wScript) {
        int lineNumber = wScript.getLineNumber();
        int columnNumber = wScript.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Position.Label", (Object[])new Object[]{lineNumber, columnNumber}));
    }

    public void getData() {
        if (!Utils.isEmpty((CharSequence)Const.trim((String)this.input.getOptimizationLevel()))) {
            this.wOptimizationLevel.setText(this.input.getOptimizationLevel().trim());
        } else {
            this.wOptimizationLevel.setText("9");
        }
        for (int i = 0; i < this.input.getFieldname().length; ++i) {
            if (Utils.isEmpty((CharSequence)this.input.getFieldname()[i])) continue;
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, this.input.getFieldname()[i]);
            if (this.input.getRename()[i] != null && !this.input.getFieldname()[i].equals(this.input.getRename()[i])) {
                item.setText(2, this.input.getRename()[i]);
            }
            item.setText(3, ValueMetaFactory.getValueMetaName((int)this.input.getType()[i]));
            if (this.input.getLength()[i] >= 0) {
                item.setText(4, "" + this.input.getLength()[i]);
            }
            if (this.input.getPrecision()[i] >= 0) {
                item.setText(5, "" + this.input.getPrecision()[i]);
            }
            item.setText(6, this.input.getReplace()[i] ? YES_NO_COMBO[1] : YES_NO_COMBO[0]);
        }
        ScriptValuesScript[] jsScripts = this.input.getJSScripts();
        if (jsScripts.length > 0) {
            for (ScriptValuesScript jsScript : jsScripts) {
                if (jsScript.isTransformScript()) {
                    this.strActiveScript = jsScript.getScriptName();
                } else if (jsScript.isStartScript()) {
                    this.strActiveStartScript = jsScript.getScriptName();
                } else if (jsScript.isEndScript()) {
                    this.strActiveEndScript = jsScript.getScriptName();
                }
                this.addCtab(jsScript.getScriptName(), jsScript.getScript(), 0);
            }
        } else {
            this.addCtab("", "", 0);
        }
        this.setActiveCtab(this.strActiveScript);
        this.refresh();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void refresh() {
        for (int i = 0; i < this.folder.getItemCount(); ++i) {
            CTabItem item = this.folder.getItem(i);
            if (item.getText().equals(this.strActiveScript)) {
                item.setImage(this.imageActiveScript);
                continue;
            }
            if (item.getText().equals(this.strActiveStartScript)) {
                item.setImage(this.imageActiveStartScript);
                continue;
            }
            if (item.getText().equals(this.strActiveEndScript)) {
                item.setImage(this.imageActiveEndScript);
                continue;
            }
            item.setImage(this.imageInactiveScript);
        }
    }

    private void refreshScripts() {
        CTabItem[] cTabs;
        for (CTabItem cTab : cTabs = this.folder.getItems()) {
            if (cTab.getImage().equals((Object)this.imageActiveStartScript)) {
                this.strActiveStartScript = cTab.getText();
                continue;
            }
            if (!cTab.getImage().equals((Object)this.imageActiveEndScript)) continue;
            this.strActiveEndScript = cTab.getText();
        }
    }

    private boolean cancel() {
        if (this.input.hasChanged()) {
            MessageBox box = new MessageBox(this.shell, 0x100100C0);
            box.setText(BaseMessages.getString(PKG, (String)"ScriptValuesModDialog.WarningDialogChanged.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"ScriptValuesModDialog.WarningDialogChanged.Message", (String[])new String[]{Const.CR}));
            int answer = box.open();
            if (answer == 128) {
                return false;
            }
        }
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
        return true;
    }

    private void getInfo(ScriptValuesMeta meta) {
        meta.setOptimizationLevel(this.wOptimizationLevel.getText());
        int nrFields = this.wFields.nrNonEmpty();
        meta.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            meta.getFieldname()[i] = item.getText(1);
            meta.getRename()[i] = item.getText(2);
            if (meta.getRename()[i] == null || meta.getRename()[i].isEmpty() || meta.getRename()[i].equalsIgnoreCase(meta.getFieldname()[i])) {
                meta.getRename()[i] = meta.getFieldname()[i];
            }
            meta.getType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(3));
            String slen = item.getText(4);
            String sprc = item.getText(5);
            meta.getLength()[i] = Const.toInt((String)slen, (int)-1);
            meta.getPrecision()[i] = Const.toInt((String)sprc, (int)-1);
            meta.getReplace()[i] = YES_NO_COMBO[1].equalsIgnoreCase(item.getText(6));
        }
        CTabItem[] cTabs = this.folder.getItems();
        if (cTabs.length > 0) {
            ScriptValuesScript[] jsScripts = new ScriptValuesScript[cTabs.length];
            for (int i = 0; i < cTabs.length; ++i) {
                ScriptValuesScript jsScript = new ScriptValuesScript(-1, cTabs[i].getText(), this.getStyledTextComp(cTabs[i]).getText());
                if (cTabs[i].getImage().equals((Object)this.imageActiveScript)) {
                    jsScript.setScriptType(0);
                } else if (cTabs[i].getImage().equals((Object)this.imageActiveStartScript)) {
                    jsScript.setScriptType(1);
                } else if (cTabs[i].getImage().equals((Object)this.imageActiveEndScript)) {
                    jsScript.setScriptType(2);
                }
                jsScripts[i] = jsScript;
            }
            meta.setJSScripts(jsScripts);
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        boolean bInputOK = false;
        if (this.getCTabItemByName(this.strActiveScript) == null) {
            MessageBox mb = new MessageBox(this.shell, 289);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.NoActiveScriptSet", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ERROR.Label", (String[])new String[0]));
            switch (mb.open()) {
                case 32: {
                    this.strActiveScript = this.folder.getItem(0).getText();
                    this.refresh();
                    bInputOK = true;
                    break;
                }
                case 256: {
                    bInputOK = false;
                    break;
                }
            }
        } else {
            bInputOK = true;
        }
        if (bInputOK) {
            this.getInfo(this.input);
            this.dispose();
        }
    }

    public boolean test() {
        return this.test(false, false);
    }

    private boolean newTest() {
        PluginRegistry registry = PluginRegistry.getInstance();
        String scriptTransformName = this.wTransformName.getText();
        try {
            IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).clone();
            if (rowMeta != null) {
                if (this.genMeta == null) {
                    this.genMeta = new RowGeneratorMeta();
                    this.genMeta.setRowLimit("10");
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(i);
                        if (valueMeta.isStorageBinaryString()) {
                            valueMeta.setStorageType(0);
                        }
                        String string = null;
                        String format = valueMeta.getFormatMask();
                        boolean setValueMetaFormat = false;
                        switch (valueMeta.getType()) {
                            case 3: {
                                if (format == null) {
                                    format = "yyyy/MM/dd HH:mm:ss";
                                    setValueMetaFormat = true;
                                }
                                string = valueMeta.getString((Object)new Date());
                                break;
                            }
                            case 2: {
                                string = "test value test value";
                                break;
                            }
                            case 5: {
                                if (format == null) {
                                    format = "#";
                                    setValueMetaFormat = true;
                                }
                                string = valueMeta.getString((Object)0L);
                                break;
                            }
                            case 1: {
                                if (format == null) {
                                    format = "#.#";
                                    setValueMetaFormat = true;
                                }
                                string = valueMeta.getString((Object)0.0);
                                break;
                            }
                            case 6: {
                                if (format == null) {
                                    format = "#.#";
                                    setValueMetaFormat = true;
                                }
                                string = valueMeta.getString((Object)BigDecimal.ZERO);
                                break;
                            }
                            case 4: {
                                string = valueMeta.getString((Object)Boolean.TRUE);
                                break;
                            }
                            case 8: {
                                string = valueMeta.getString((Object)new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74});
                                break;
                            }
                        }
                        if (setValueMetaFormat) {
                            valueMeta.setConversionMask(format);
                        }
                        GeneratorField field = new GeneratorField(valueMeta.getName(), valueMeta.getTypeDesc(), format, valueMeta.getLength(), valueMeta.getPrecision(), valueMeta.getCurrencySymbol(), valueMeta.getDecimalSymbol(), valueMeta.getGroupingSymbol(), string, false);
                        this.genMeta.getFields().add(field);
                    }
                }
                TransformMeta genTransform = new TransformMeta(registry.getPluginId(TransformPluginType.class, (Object)this.genMeta), "## TEST DATA ##", (ITransformMeta)this.genMeta);
                genTransform.setLocation(50, 50);
                ScriptValuesMeta scriptMeta = new ScriptValuesMeta();
                this.getInfo(scriptMeta);
                TransformMeta scriptTransform = new TransformMeta(registry.getPluginId(TransformPluginType.class, (Object)scriptMeta), Const.NVL((String)scriptTransformName, (String)"## SCRIPT ##"), (ITransformMeta)scriptMeta);
                scriptTransformName = scriptTransform.getName();
                scriptTransform.setLocation(150, 50);
                PipelineHopMeta hop = new PipelineHopMeta(genTransform, scriptTransform);
                PipelineMeta pipelineMeta = new PipelineMeta();
                pipelineMeta.setName(this.wTransformName.getText() + " - PREVIEW");
                pipelineMeta.addTransform(genTransform);
                pipelineMeta.addTransform(scriptTransform);
                pipelineMeta.addPipelineHop(hop);
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, pipelineMeta, new String[]{scriptTransformName}, new int[]{Const.toInt((String)this.genMeta.getRowLimit(), (int)10)});
                progressDialog.open();
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                IRowMeta previewRowsMeta = progressDialog.getPreviewRowsMeta(this.wTransformName.getText());
                List previewRows = progressDialog.getPreviewRows(this.wTransformName.getText());
                if (previewRowsMeta != null && !Utils.isEmpty((Collection)previewRows)) {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), previewRowsMeta, previewRows, loggingText);
                    prd.open();
                }
            }
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_MESSAGE, (String[])new String[0]), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test(boolean getvars, boolean popup) {
        boolean retval = true;
        TextComposite wScript = this.getStyledTextComp();
        String scr = wScript.getText();
        HopException testException = null;
        this.refreshScripts();
        Context jscx = ContextFactory.getGlobal().enterContext();
        jscx.setOptimizationLevel(-1);
        ScriptableObject jsscope = jscx.initStandardObjects(null, false);
        for (int i = 0; i < this.folder.getItemCount(); ++i) {
            TextComposite sItem = this.getStyledTextComp(this.folder.getItem(i));
            Scriptable jsR = Context.toObject((Object)sItem.getText(), (Scriptable)jsscope);
            jsscope.put(this.folder.getItem(i).getText(), (Scriptable)jsscope, (Object)jsR);
        }
        jsscope.put("_PipelineName_", (Scriptable)jsscope, (Object)this.transformName);
        try {
            IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (rowMeta != null) {
                ScriptValuesDummy dummyTransform = new ScriptValuesDummy(rowMeta, this.pipelineMeta.getTransformFields(this.variables, this.transformName));
                Scriptable jsvalue = Context.toObject((Object)dummyTransform, (Scriptable)jsscope);
                jsscope.put("_transform_", (Scriptable)jsscope, (Object)jsvalue);
                try {
                    if (this.input.getAddClasses() != null) {
                        for (int i = 0; i < this.input.getAddClasses().length; ++i) {
                            Object jsOut = Context.javaToJS((Object)this.input.getAddClasses()[i].getAddObject(), (Scriptable)jsscope);
                            ScriptableObject.putProperty((Scriptable)jsscope, (String)this.input.getAddClasses()[i].getJSName(), (Object)jsOut);
                        }
                    }
                }
                catch (Exception e) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.CouldNotAddToContext", (String[])new String[]{e.toString()}));
                    retval = false;
                }
                try {
                    Context.javaToJS(ScriptValuesAddedFunctions.class, (Scriptable)jsscope);
                    jsscope.defineFunctionProperties(jsFunctionList, ScriptValuesAddedFunctions.class, 2);
                }
                catch (Exception ex) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.CouldNotAddDefaultFunctions", (String[])new String[]{ex.toString()}));
                    retval = false;
                }
                try {
                    jsscope.put(CONST_SKIP_PIPELINE, (Scriptable)jsscope, (Object)1);
                    jsscope.put(CONST_ABORT_PIPELINE, (Scriptable)jsscope, (Object)-1);
                    jsscope.put(CONST_ERROR_PIPELINE, (Scriptable)jsscope, (Object)-2);
                    jsscope.put(CONST_CONTINUE_PIPELINE, (Scriptable)jsscope, (Object)0);
                }
                catch (Exception ex) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.CouldNotAddPipelineConstants", (String[])new String[]{ex.toString()}));
                    retval = false;
                }
                try {
                    Object[] row = new Object[rowMeta.size()];
                    Scriptable jsRowMeta = Context.toObject((Object)rowMeta, (Scriptable)jsscope);
                    jsscope.put("rowMeta", (Scriptable)jsscope, (Object)jsRowMeta);
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(i);
                        Object valueData = null;
                        if (valueMeta.isDate()) {
                            valueData = new Date();
                        }
                        if (valueMeta.isString()) {
                            valueData = "test value test value test value test value test value test value test value test value test value test value";
                        }
                        if (valueMeta.isInteger()) {
                            valueData = 0L;
                        }
                        if (valueMeta.isNumber()) {
                            valueData = 0.0;
                        }
                        if (valueMeta.isBigNumber()) {
                            valueData = BigDecimal.ZERO;
                        }
                        if (valueMeta.isBoolean()) {
                            valueData = Boolean.TRUE;
                        }
                        if (valueMeta.isBinary()) {
                            valueData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
                        }
                        if (valueMeta.isStorageBinaryString()) {
                            valueMeta.setStorageType(0);
                        }
                        row[i] = valueData;
                        Scriptable jsarg = Context.toObject((Object)valueData, (Scriptable)jsscope);
                        jsscope.put(valueMeta.getName(), (Scriptable)jsscope, (Object)jsarg);
                    }
                    Scriptable jsRow = Context.toObject((Object)row, (Scriptable)jsscope);
                    jsscope.put("row", (Scriptable)jsscope, (Object)jsRow);
                }
                catch (Exception ev) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.CouldNotAddInputFields", (String[])new String[]{ev.toString()}));
                    retval = false;
                }
                try {
                    if (this.strActiveStartScript != null && !this.folder.getSelection().getText().equals(this.strActiveStartScript) && !this.strActiveStartScript.isEmpty()) {
                        String strStartScript = this.getStyledTextComp(this.folder.getItem(this.getCTabPosition(this.strActiveStartScript))).getText();
                        jscx.evaluateString((Scriptable)jsscope, strStartScript, "pipeline_Start", 1, null);
                    }
                }
                catch (Exception e) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.CouldProcessStartScript", (String[])new String[]{e.toString()}));
                    retval = false;
                }
                try {
                    Script evalScript = jscx.compileString(scr, "script", 1, null);
                    evalScript.exec(jscx, (Scriptable)jsscope);
                    if (getvars) {
                        ScriptNode tree = ScriptValuesDialog.parseVariables(jscx, (Scriptable)jsscope, scr, "script", 1, null);
                        for (int i = 0; i < tree.getParamAndVarCount(); ++i) {
                            String varname = tree.getParamOrVarName(i);
                            if (varname.equalsIgnoreCase("row") || varname.equalsIgnoreCase("pipeline_Status")) continue;
                            int type = 2;
                            int length = -1;
                            int precision = -1;
                            Object result = jsscope.get(varname, (Scriptable)jsscope);
                            if (result != null) {
                                String classname = result.getClass().getName();
                                if (classname.equalsIgnoreCase("java.lang.Byte")) {
                                    type = 5;
                                    length = 3;
                                    precision = 0;
                                } else if (classname.equalsIgnoreCase("java.lang.Integer")) {
                                    type = 5;
                                    length = 9;
                                    precision = 0;
                                } else if (classname.equalsIgnoreCase("java.lang.Long")) {
                                    type = 5;
                                    length = 18;
                                    precision = 0;
                                } else if (classname.equalsIgnoreCase("java.lang.Double")) {
                                    type = 1;
                                    length = 16;
                                    precision = 2;
                                } else if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeDate") || classname.equalsIgnoreCase("java.util.Date")) {
                                    type = 3;
                                } else if (classname.equalsIgnoreCase("java.lang.Boolean")) {
                                    type = 4;
                                }
                            }
                            TableItem ti = new TableItem(this.wFields.table, 0);
                            ti.setText(1, varname);
                            ti.setText(2, "");
                            ti.setText(3, ValueMetaFactory.getValueMetaName((int)type));
                            ti.setText(4, (String)(length >= 0 ? "" + length : ""));
                            ti.setText(5, (String)(precision >= 0 ? "" + precision : ""));
                            ti.setText(6, rowMeta.indexOfValue(varname) >= 0 ? YES_NO_COMBO[1] : YES_NO_COMBO[0]);
                        }
                        this.wFields.removeEmptyRows();
                        this.wFields.setRowNums();
                        this.wFields.optWidth(true);
                    }
                }
                catch (EvaluatorException | JavaScriptException e) {
                    String position = "(" + e.lineNumber() + ":" + e.columnNumber() + ")";
                    String message = BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Exception.CouldNotExecuteScript", (String[])new String[]{position});
                    testException = new HopException(message, e);
                    retval = false;
                }
                catch (Exception e) {
                    testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Exception.CouldNotExecuteScript2", (String[])new String[0]), (Throwable)e);
                    retval = false;
                }
            } else {
                testException = new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Exception.CouldNotGetFields", (String[])new String[0]));
                retval = false;
            }
            if (popup) {
                if (retval) {
                    if (!getvars) {
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ScriptCompilationOK", (String[])new String[0]) + Const.CR);
                        mb.setText("OK");
                        mb.open();
                    }
                } else {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_MESSAGE, (String[])new String[0]), (Exception)((Object)testException));
                }
            }
        }
        catch (HopException ke) {
            retval = false;
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SCRIPT_VALUES_DIALOG_MOD_TEST_FAILED_DIALOG_MESSAGE, (String[])new String[0]), (Exception)((Object)ke));
        }
        finally {
            if (jscx != null) {
                Context.exit();
            }
        }
        return retval;
    }

    private void buildSpecialFunctionsTree() {
        TreeItem item = new TreeItem(this.wTree, 0);
        item.setImage(guiresource.getImageFolder());
        item.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.TansformConstant.Label", (String[])new String[0]));
        TreeItem itemT = new TreeItem(item, 0);
        itemT.setImage(GuiResource.getInstance().getImageLabel());
        itemT.setText(CONST_SKIP_PIPELINE);
        itemT.setData((Object)CONST_SKIP_PIPELINE);
        itemT = new TreeItem(item, 0);
        itemT.setImage(GuiResource.getInstance().getImageLabel());
        itemT.setText(CONST_ERROR_PIPELINE);
        itemT.setData((Object)CONST_ERROR_PIPELINE);
        itemT = new TreeItem(item, 0);
        itemT.setImage(GuiResource.getInstance().getImageLabel());
        itemT.setText(CONST_CONTINUE_PIPELINE);
        itemT.setData((Object)CONST_CONTINUE_PIPELINE);
        itemT = new TreeItem(item, 0);
        itemT.setImage(GuiResource.getInstance().getImageLabel());
        itemT.setText(CONST_ABORT_PIPELINE);
        itemT.setData((Object)CONST_ABORT_PIPELINE);
        item = new TreeItem(this.wTree, 0);
        item.setImage(guiresource.getImageFolder());
        item.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.TransformFunctions.Label", (String[])new String[0]));
        String strData = "";
        TreeItem itemStringFunctionsGroup = new TreeItem(item, 0);
        itemStringFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemStringFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.StringFunctions.Label", (String[])new String[0]));
        itemStringFunctionsGroup.setData((Object)CONST_FUNCTION);
        TreeItem itemNumericFunctionsGroup = new TreeItem(item, 0);
        itemNumericFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemNumericFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.NumericFunctions.Label", (String[])new String[0]));
        itemNumericFunctionsGroup.setData((Object)CONST_FUNCTION);
        TreeItem itemDateFunctionsGroup = new TreeItem(item, 0);
        itemDateFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemDateFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.DateFunctions.Label", (String[])new String[0]));
        itemDateFunctionsGroup.setData((Object)CONST_FUNCTION);
        TreeItem itemLogicFunctionsGroup = new TreeItem(item, 0);
        itemLogicFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemLogicFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.LogicFunctions.Label", (String[])new String[0]));
        itemLogicFunctionsGroup.setData((Object)CONST_FUNCTION);
        TreeItem itemSpecialFunctionsGroup = new TreeItem(item, 0);
        itemSpecialFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemSpecialFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.SpecialFunctions.Label", (String[])new String[0]));
        itemSpecialFunctionsGroup.setData((Object)CONST_FUNCTION);
        TreeItem itemFileFunctionsGroup = new TreeItem(item, 0);
        itemFileFunctionsGroup.setImage(GuiResource.getInstance().getImageFolder());
        itemFileFunctionsGroup.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.FileFunctions.Label", (String[])new String[0]));
        itemFileFunctionsGroup.setData((Object)CONST_FUNCTION);
        Hashtable<String, String> hatFunctions = this.scVHelp.getFunctionList();
        Vector<String> v = new Vector<String>(hatFunctions.keySet());
        Collections.sort(v);
        for (String strFunction : v) {
            String strFunctionType = hatFunctions.get(strFunction);
            int iFunctionType = Integer.parseInt(strFunctionType);
            TreeItem itemFunction = null;
            switch (iFunctionType) {
                case 0: {
                    itemFunction = new TreeItem(itemStringFunctionsGroup, 0);
                    break;
                }
                case 1: {
                    itemFunction = new TreeItem(itemNumericFunctionsGroup, 0);
                    break;
                }
                case 2: {
                    itemFunction = new TreeItem(itemDateFunctionsGroup, 0);
                    break;
                }
                case 3: {
                    itemFunction = new TreeItem(itemLogicFunctionsGroup, 0);
                    break;
                }
                case 4: {
                    itemFunction = new TreeItem(itemSpecialFunctionsGroup, 0);
                    break;
                }
                case 5: {
                    itemFunction = new TreeItem(itemFileFunctionsGroup, 0);
                    break;
                }
            }
            if (itemFunction == null) continue;
            itemFunction.setText(strFunction);
            itemFunction.setImage(GuiResource.getInstance().getImageFunction());
            strData = CONST_JS_FUNCTION;
            itemFunction.setData((Object)strData);
        }
    }

    public boolean TreeItemExist(TreeItem itemToCheck, String strItemName) {
        boolean bRC = false;
        if (itemToCheck.getItemCount() > 0) {
            TreeItem[] items;
            for (TreeItem item : items = itemToCheck.getItems()) {
                if (!item.getText().equals(strItemName)) continue;
                return true;
            }
        }
        return bRC;
    }

    private void setInputOutputFields() {
        this.shell.getDisplay().syncExec(() -> {
            this.iteminput.removeAll();
            this.itemoutput.removeAll();
            String strItemInToAdd = "";
            Object strItemToAddOut = "";
            if (this.rowPrevTransformFields != null) {
                for (int i = 0; i < this.rowPrevTransformFields.size(); ++i) {
                    IValueMeta valueMeta = this.rowPrevTransformFields.getValueMeta(i);
                    strItemToAddOut = valueMeta.getName() + ".setValue(var)";
                    strItemInToAdd = valueMeta.getName();
                    TreeItem itemFields = new TreeItem(this.iteminput, 0);
                    itemFields.setImage(GuiResource.getInstance().getImage(valueMeta));
                    itemFields.setText(strItemInToAdd);
                    itemFields.setData((Object)strItemInToAdd);
                }
                TreeItem itemFields = new TreeItem(this.itemoutput, 0);
                itemFields.setData((Object)"");
                itemFields.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.OutputFiels.CompatibilityOff", (String[])new String[0]));
            }
        });
    }

    private void treeDblClick(Event event) {
        TextComposite wScript = this.getStyledTextComp();
        Point point = new Point(event.x, event.y);
        TreeItem item = this.wTree.getItem(point);
        if (item != null && item.getParentItem() != null) {
            if (item.getParentItem().equals(this.wTreeScriptsItem)) {
                this.setActiveCtab(item.getText());
            } else if (!item.getData().equals(CONST_FUNCTION)) {
                String strInsert;
                int iStart = wScript.getCaretPosition();
                int selCount = wScript.getSelectionCount();
                if ((iStart -= selCount) < 0) {
                    iStart = 0;
                }
                if ((strInsert = (String)item.getData()).equals(CONST_JS_FUNCTION)) {
                    strInsert = item.getText();
                }
                wScript.insert(strInsert);
                wScript.setSelection(iStart, iStart + strInsert.length());
            }
        }
    }

    private void buildAddClassesListTree() {
        if (this.wTreeClassesitem != null) {
            this.wTreeClassesitem.dispose();
        }
        if (this.input.getAddClasses() != null) {
            for (int i = 0; i < this.input.getAddClasses().length; ++i) {
                try {
                    Method[] methods = this.input.getAddClasses()[i].getAddClass().getMethods();
                    String strClassType = this.input.getAddClasses()[i].getAddClass().toString();
                    this.wTreeClassesitem = new TreeItem(this.wTree, 0);
                    this.wTreeClassesitem.setText(this.input.getAddClasses()[i].getJSName());
                    for (Method method : methods) {
                        String strDeclaringClass = method.getDeclaringClass().toString();
                        if (!strClassType.equals(strDeclaringClass)) continue;
                        TreeItem item2 = new TreeItem(this.wTreeClassesitem, 0);
                        String strParams = this.buildAddClassFunctionName(method);
                        item2.setText(method.getName() + "(" + strParams + ")");
                        String strData = this.input.getAddClasses()[i].getJSName() + "." + method.getName() + "(" + strParams + ")";
                        item2.setData((Object)strData);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String buildAddClassFunctionName(Method metForParams) {
        Class<?>[] clsParamType;
        StringBuilder sbRC = new StringBuilder();
        String strRC = "";
        for (Class<?> aClass : clsParamType = metForParams.getParameterTypes()) {
            String strParam = aClass.getName();
            if (strParam.toLowerCase().contains("javascript")) continue;
            if (strParam.toLowerCase().contains("object")) {
                sbRC.append("var");
                sbRC.append(", ");
                continue;
            }
            if (strParam.equals("java.lang.String")) {
                sbRC.append("String");
                sbRC.append(", ");
                continue;
            }
            sbRC.append(strParam);
            sbRC.append(", ");
        }
        strRC = sbRC.toString();
        if (!strRC.isEmpty()) {
            strRC = strRC.substring(0, sbRC.length() - 2);
        }
        return strRC;
    }

    private void buildingFolderMenu() {
        MenuItem addNewItem = new MenuItem(this.cMenu, 8);
        addNewItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.AddNewTab", (String[])new String[0]));
        addNewItem.setImage(guiresource.getImageAdd());
        addNewItem.addListener(13, e -> this.addCtab("", "", 1));
        MenuItem copyItem = new MenuItem(this.cMenu, 8);
        copyItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.AddCopy", (String[])new String[0]));
        copyItem.setImage(guiresource.getImageDuplicate());
        copyItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            StyledTextComp st = (StyledTextComp)item.getControl();
            this.addCtab(item.getText(), st.getText(), 2);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setActiveScriptItem = new MenuItem(this.cMenu, 8);
        setActiveScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.SetTransformScript", (String[])new String[0]));
        setActiveScriptItem.setImage(this.imageActiveScript);
        setActiveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveScript);
                    this.strActiveScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        MenuItem setStartScriptItem = new MenuItem(this.cMenu, 8);
        setStartScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.SetStartScript", (String[])new String[0]));
        setStartScriptItem.setImage(this.imageActiveStartScript);
        setStartScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveStartScript);
                    this.strActiveStartScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveStartScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        MenuItem setEndScriptItem = new MenuItem(this.cMenu, 8);
        setEndScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.SetEndScript", (String[])new String[0]));
        setEndScriptItem.setImage(this.imageActiveEndScript);
        setEndScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveEndScript);
                    this.strActiveEndScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveEndScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setRemoveScriptItem = new MenuItem(this.cMenu, 8);
        setRemoveScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.RemoveScriptType", (String[])new String[0]));
        setRemoveScriptItem.setImage(this.imageInactiveScript);
        setRemoveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            this.input.setChanged(true);
            if (item.getImage().equals((Object)this.imageActiveScript)) {
                this.strActiveScript = "";
            } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                this.strActiveStartScript = "";
            } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                this.strActiveEndScript = "";
            }
            item.setImage(this.imageInactiveScript);
        });
        this.folder.setMenu(this.cMenu);
    }

    private void buildingTreeMenu() {
        MenuItem addDeleteItem = new MenuItem(this.tMenu, 8);
        addDeleteItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Delete.Label", (String[])new String[0]));
        addDeleteItem.setImage(guiresource.getImageDelete());
        addDeleteItem.addListener(13, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                MessageBox messageBox = new MessageBox(this.shell, 196);
                messageBox.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.DeleteItem.Label", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.ConfirmDeleteItem.Label", (String[])new String[]{tItem.getText()}));
                switch (messageBox.open()) {
                    case 64: {
                        this.modifyCTabItem(tItem, 0, "");
                        tItem.dispose();
                        this.input.setChanged();
                        break;
                    }
                }
            }
        });
        MenuItem renItem = new MenuItem(this.tMenu, 8);
        renItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Rename.Label", (String[])new String[0]));
        renItem.addListener(13, e -> this.renameFunction(this.wTree.getSelection()[0]));
        new MenuItem(this.tMenu, 2);
        MenuItem helpItem = new MenuItem(this.tMenu, 8);
        helpItem.setText(BaseMessages.getString(PKG, (String)"ScriptValuesDialogMod.Sample.Label", (String[])new String[0]));
        helpItem.addListener(13, e -> {
            String strFunctionName;
            String strFunctionNameWithArgs = strFunctionName = this.wTree.getSelection()[0].getText();
            String strHelpTabName = (strFunctionName = strFunctionName.substring(0, strFunctionName.indexOf(40))) + "_Sample";
            if (this.getCTabPosition(strHelpTabName) == -1) {
                this.addCtab(strHelpTabName, this.scVHelp.getSample(strFunctionName, strFunctionNameWithArgs), 0);
            }
            if (this.getCTabPosition(strHelpTabName) != -1) {
                this.setActiveCtab(strHelpTabName);
            }
        });
        this.wTree.addListener(3, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                TreeItem pItem = tItem.getParentItem();
                if (pItem != null && pItem.equals(this.wTreeScriptsItem)) {
                    this.tMenu.getItem(0).setEnabled(this.folder.getItemCount() > 1);
                    this.tMenu.getItem(1).setEnabled(true);
                    this.tMenu.getItem(3).setEnabled(false);
                } else if (tItem.equals(this.wTreeClassesitem)) {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(false);
                } else if (tItem.getData() != null && tItem.getData().equals(CONST_JS_FUNCTION)) {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(true);
                } else {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(false);
                }
            }
        });
        this.wTree.setMenu(this.tMenu);
    }

    private void addRenameTowTreeScriptItems() {
        this.lastItem = new TreeItem[1];
        this.editor = new TreeEditor(this.wTree);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.wTree.addListener(13, event -> {
            TreeItem item = (TreeItem)event.item;
            this.renameFunction(item);
        });
    }

    private void renameFunction(TreeItem item) {
        if (item != null && item.getParentItem() != null && item.getParentItem().equals(this.wTreeScriptsItem) && item == this.lastItem[0]) {
            Text text = new Text((Composite)this.wTree, 2048);
            text.addListener(16, event -> {
                if (!text.getText().isEmpty() && this.getCTabItemByName(text.getText()) == null) {
                    this.modifyCTabItem(item, 2, text.getText());
                    item.setText(text.getText());
                }
                text.dispose();
            });
            text.addListener(31, event -> {
                switch (event.detail) {
                    case 4: {
                        if (!text.getText().isEmpty() && this.getCTabItemByName(text.getText()) == null) {
                            this.modifyCTabItem(item, 2, text.getText());
                            item.setText(text.getText());
                        }
                        text.dispose();
                        break;
                    }
                    case 2: {
                        text.dispose();
                        event.doit = false;
                        break;
                    }
                }
            });
            this.editor.setEditor((Control)text, item);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
        }
        this.lastItem[0] = item;
    }

    public static ScriptNode parseVariables(Context cx, Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        CompilerEnvirons evn = new CompilerEnvirons();
        evn.setOptimizationLevel(-1);
        evn.setGeneratingSource(true);
        evn.setGenerateDebugInfo(true);
        ToolErrorReporter errorReporter = new ToolErrorReporter(false);
        Parser p = new Parser(evn, (ErrorReporter)errorReporter);
        AstRoot tree = p.parse(source, "", 0);
        new NodeTransformer().transform((ScriptNode)tree, evn);
        return tree;
    }

    private /* synthetic */ void lambda$addCtab$7(TextComposite wScript, Event e) {
        this.setPosition(wScript);
    }
}

