/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.skeleton;

import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.skeleton.SkeletonFisbone;
import org.gagravarr.skeleton.SkeletonFishead;
import org.gagravarr.skeleton.SkeletonKeyFramePacket;
import org.gagravarr.skeleton.SkeletonPacket;

public class SkeletonPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isSkeletonStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return SkeletonPacketFactory.isSkeletonSpecial(firstPacket);
    }

    protected static boolean isSkeletonSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 52) {
            return false;
        }
        if (IOUtils.byteRangeMatches(SkeletonPacket.MAGIC_FISHEAD_BYTES, d, 0)) {
            return true;
        }
        return IOUtils.byteRangeMatches(SkeletonPacket.MAGIC_FISBONE_BYTES, d, 0);
    }

    public static SkeletonPacket create(OggPacket packet) {
        if (SkeletonPacketFactory.isSkeletonSpecial(packet)) {
            byte type = packet.getData()[3];
            switch (type) {
                case 104: {
                    return new SkeletonFishead(packet);
                }
                case 98: {
                    return new SkeletonFisbone(packet);
                }
            }
        }
        return new SkeletonKeyFramePacket(packet);
    }
}

