/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MemoizingPerInstantiationSerializableSupplier<@UnknownKeyFor T>
implements SerializableSupplier<T> {
    private static final @UnknownKeyFor @NonNull @Initialized AtomicInteger idGenerator = new AtomicInteger();
    private final @UnknownKeyFor @NonNull @Initialized int id = idGenerator.incrementAndGet();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Object> staticCache = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@NonNull T> supplier;
    private volatile transient @MonotonicNonNull T value;

    public MemoizingPerInstantiationSerializableSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@NonNull T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        T result = this.value;
        if (result != null) {
            return result;
        }
        Object mapValue = staticCache.computeIfAbsent(this.id, ignored -> this.supplier.get());
        this.value = Preconditions.checkStateNotNull(mapValue);
        return this.value;
    }
}

