/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface KinesisPartitioner<@UnknownKeyFor T>
extends Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized BigInteger MIN_HASH_KEY = new BigInteger("0");
    public static final @UnknownKeyFor @NonNull @Initialized BigInteger MAX_HASH_KEY = new BigInteger(StringUtils.repeat((String)"FF", (int)16), 16);

    @Nonnull
    public @UnknownKeyFor @NonNull @Initialized String getPartitionKey(T var1);

    @Nullable
    default public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getExplicitHashKey(T record) {
        return null;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized KinesisPartitioner<T> explicitRandomPartitioner(final @UnknownKeyFor @NonNull @Initialized int shards) {
        BigInteger distance = MAX_HASH_KEY.divide(BigInteger.valueOf(shards));
        BigInteger hashKey = distance.divide(BigInteger.valueOf(2L));
        final String[] hashKeys = new String[shards];
        for (int i = 0; i < shards; ++i) {
            hashKeys[i] = hashKey.toString();
            hashKey = hashKey.add(distance);
        }
        return new ExplicitPartitioner<T>(){

            @Override
            @Nonnull
            public @UnknownKeyFor @NonNull @Initialized String getExplicitHashKey(T record) {
                return hashKeys[ThreadLocalRandom.current().nextInt(shards)];
            }
        };
    }

    public static interface ExplicitPartitioner<@UnknownKeyFor T>
    extends KinesisPartitioner<T> {
        @Override
        @Nonnull
        default public @UnknownKeyFor @NonNull @Initialized String getPartitionKey(T record) {
            return "a";
        }

        @Override
        @Nonnull
        public @UnknownKeyFor @NonNull @Initialized String getExplicitHashKey(T var1);
    }
}

