/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import java.net.URI;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.HttpClientConfiguration;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public interface AwsOptions
extends PipelineOptions {
    @Description(value="Region used by AWS service clients")
    @Default.InstanceFactory(value=AwsRegionFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Region getAwsRegion();

    public void setAwsRegion(@UnknownKeyFor @NonNull @Initialized Region var1);

    @Description(value="Endpoint used by AWS service clients")
    public @UnknownKeyFor @NonNull @Initialized URI getEndpoint();

    public void setEndpoint(@UnknownKeyFor @NonNull @Initialized URI var1);

    @Description(value="The credentials provider used to authenticate against AWS services. The provider class must be specified in the \"@type\" field, check the Javadocs for further examples. Example: {\"@type\": \"StaticCredentialsProvider\", \"accessKeyId\":\"<key>\", \"secretAccessKey\":\"<secret>\"}")
    @Default.InstanceFactory(value=AwsUserCredentialsFactory.class)
    public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider getAwsCredentialsProvider();

    public void setAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider var1);

    @Description(value="The proxy configuration used to configure AWS service clients. Example: --proxyConfiguration={\"endpoint\":\"http://hostname:port\", \"username\":\"username\", \"password\":\"password\"}")
    public @UnknownKeyFor @NonNull @Initialized ProxyConfiguration getProxyConfiguration();

    public void setProxyConfiguration(@UnknownKeyFor @NonNull @Initialized ProxyConfiguration var1);

    @Description(value="The HTTP client configuration used to configure AWS service clients. Example: --httpClientConfiguration={\"socketTimeout\":1000,\"maxConnections\":10}")
    public @UnknownKeyFor @NonNull @Initialized HttpClientConfiguration getHttpClientConfiguration();

    public void setHttpClientConfiguration(@UnknownKeyFor @NonNull @Initialized HttpClientConfiguration var1);

    @Description(value="Factory class to configure AWS client builders")
    @Default.Class(value=ClientBuilderFactory.DefaultClientBuilder.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ClientBuilderFactory> getClientBuilderFactory();

    public void setClientBuilderFactory(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ClientBuilderFactory> var1);

    public static class AwsUserCredentialsFactory
    implements DefaultValueFactory<AwsCredentialsProvider> {
        public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return DefaultCredentialsProvider.create();
        }
    }

    public static class AwsRegionFactory
    implements DefaultValueFactory<Region> {
        public @Nullable @UnknownKeyFor @Initialized Region create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (SdkClientException e) {
                return null;
            }
        }
    }
}

