/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.google.auto.value.AutoValue;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.expansion.service.AutoValue_ExpansionServiceConfig;
import org.apache.beam.sdk.expansion.service.Dependency;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.yaml.snakeyaml.Yaml;

@AutoValue
public abstract class ExpansionServiceConfig {
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAllowlist();

    public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Dependency>> getDependencies();

    public static @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig empty() {
        return ExpansionServiceConfig.create(new ArrayList<String>(), new HashMap<String, List<Dependency>>());
    }

    public static @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> allowlist, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Dependency>> dependencies) {
        if (allowlist == null) {
            allowlist = new ArrayList<String>();
        }
        return new AutoValue_ExpansionServiceConfig(allowlist, dependencies);
    }

    static @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig parseFromYamlStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(inputStream);
        if (config == null) {
            throw new IllegalArgumentException("Could not parse the provided YAML stream into a non-trivial ExpansionServiceConfig");
        }
        ArrayList<String> allowList = new ArrayList();
        HashMap<String, List<Dependency>> dependencies = new HashMap<String, List<Dependency>>();
        if (config.get("allowlist") != null) {
            allowList = (List)config.get("allowlist");
        }
        if (config.get("dependencies") != null) {
            Map dependenciesFromConfig = (Map)config.get("dependencies");
            dependenciesFromConfig.forEach((k, v) -> {
                if (v != null) {
                    List dependenciesForTransform = v.stream().map(val -> {
                        Map depProperties = (Map)val;
                        String path = (String)depProperties.get("path");
                        if (path == null) {
                            throw new IllegalArgumentException("Expected the path to be not null");
                        }
                        return Dependency.create(path);
                    }).collect(Collectors.toList());
                    dependencies.put((String)k, dependenciesForTransform);
                }
            });
        }
        return ExpansionServiceConfig.create(allowList, dependencies);
    }
}

