/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class FlinkKey
implements Value {
    private final @UnknownKeyFor @NonNull @Initialized CoderTypeSerializer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serializer = new CoderTypeSerializer(ByteArrayCoder.of(), false);
    private @UnknownKeyFor @NonNull @Initialized ByteBuffer underlying;

    public FlinkKey() {
    }

    private FlinkKey(@UnknownKeyFor @NonNull @Initialized ByteBuffer underlying) {
        this();
        this.underlying = underlying;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer getSerializedKey() {
        return this.underlying;
    }

    public static @UnknownKeyFor @NonNull @Initialized FlinkKey of(@UnknownKeyFor @NonNull @Initialized ByteBuffer bytes) {
        return new FlinkKey(bytes);
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized FlinkKey of(K key, @UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
        return new FlinkKey(FlinkKeyUtils.encodeKey(key, coder));
    }

    public void write(@UnknownKeyFor @NonNull @Initialized DataOutputView out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)this.underlying);
        this.serializer.serialize(this.underlying.array(), out);
    }

    public void read(@UnknownKeyFor @NonNull @Initialized DataInputView in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.underlying = ByteBuffer.wrap(this.serializer.deserialize(in));
    }

    public <K> K getKey(@UnknownKeyFor @NonNull @Initialized Coder<K> coder) {
        return FlinkKeyUtils.decodeKey(this.underlying, coder);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Hashing.murmur3_128().hashBytes(this.underlying.array()).asInt();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object obj) {
        return obj instanceof FlinkKey && ((FlinkKey)obj).underlying.equals(this.underlying);
    }
}

