/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.List;
import org.apache.hop.base.BaseHopMeta;
import org.apache.hop.base.IBaseMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transform.stream.StreamIcon;

public abstract class BasePainter<Hop extends BaseHopMeta<?>, Part extends IBaseMeta> {
    public final double theta = Math.toRadians(11.0);
    public static final int MINI_ICON_MARGIN = 5;
    public static final int MINI_ICON_TRIANGLE_BASE = 20;
    public static final int MINI_ICON_DISTANCE = 4;
    public static final int MINI_ICON_SKEW = 0;
    public static final int CONTENT_MENU_INDENT = 4;
    public static final int CORNER_RADIUS_5 = 10;
    public static final int CORNER_RADIUS_4 = 8;
    public static final int CORNER_RADIUS_3 = 6;
    public static final int CORNER_RADIUS_2 = 4;
    protected boolean drawingBorderAroundName;
    protected double zoomFactor;
    protected Point area;
    protected List<AreaOwner> areaOwners;
    protected DPoint offset;
    protected int iconSize;
    protected int miniIconSize;
    protected int gridSize;
    protected Rectangle selectionRectangle;
    protected int lineWidth;
    protected float magnification;
    protected Object subject;
    protected IVariables variables;
    protected IGc gc;
    private String noteFontName;
    private int noteFontHeight;
    protected Hop candidate;
    protected Point maximum;
    protected boolean showingNavigationView;
    protected float screenMagnification;
    protected Rectangle graphPort;
    protected Rectangle viewPort;
    protected String mouseOverName;

    public BasePainter(IGc gc, IVariables variables, Object subject, Point area, DPoint offset, Rectangle selectionRectangle, List<AreaOwner> areaOwners, int iconSize, int lineWidth, int gridSize, String noteFontName, int noteFontHeight, double zoomFactor, boolean drawingBorderAroundName, String mouseOverName) {
        this.gc = gc;
        this.variables = variables;
        this.subject = subject;
        this.area = area;
        this.offset = offset;
        this.selectionRectangle = selectionRectangle;
        this.areaOwners = areaOwners;
        areaOwners.clear();
        this.iconSize = iconSize;
        this.miniIconSize = iconSize / 2;
        this.lineWidth = lineWidth;
        this.gridSize = gridSize;
        this.magnification = 1.0f;
        this.zoomFactor = zoomFactor;
        this.drawingBorderAroundName = drawingBorderAroundName;
        gc.setAntialias(true);
        this.noteFontName = noteFontName;
        this.noteFontHeight = noteFontHeight;
        this.screenMagnification = 1.0f;
        this.mouseOverName = mouseOverName;
    }

    public static IGc.EImage getStreamIconImage(StreamIcon streamIcon, boolean enabled) {
        return switch (streamIcon) {
            case StreamIcon.TRUE -> {
                if (enabled) {
                    yield IGc.EImage.TRUE;
                }
                yield IGc.EImage.TRUE_DISABLED;
            }
            case StreamIcon.FALSE -> {
                if (enabled) {
                    yield IGc.EImage.FALSE;
                }
                yield IGc.EImage.FALSE_DISABLED;
            }
            case StreamIcon.ERROR -> {
                if (enabled) {
                    yield IGc.EImage.ERROR;
                }
                yield IGc.EImage.ERROR_DISABLED;
            }
            case StreamIcon.INFO -> {
                if (enabled) {
                    yield IGc.EImage.INFO;
                }
                yield IGc.EImage.INFO_DISABLED;
            }
            case StreamIcon.TARGET -> {
                if (enabled) {
                    yield IGc.EImage.TARGET;
                }
                yield IGc.EImage.TARGET_DISABLED;
            }
            case StreamIcon.INPUT -> IGc.EImage.INPUT;
            case StreamIcon.OUTPUT -> IGc.EImage.OUTPUT;
            default -> IGc.EImage.ARROW_DEFAULT;
        };
    }

    protected Point calculateMinimumSize(NotePadMeta note) {
        if (Utils.isEmpty((CharSequence)note.getNote())) {
            return new Point(20, 20);
        }
        int fontHeight = note.getFontSize() > 0 ? note.getFontSize() : this.noteFontHeight;
        this.gc.setFont(Const.NVL((String)note.getFontName(), (String)this.noteFontName), (int)((double)fontHeight / this.zoomFactor), note.isFontBold(), note.isFontItalic());
        Point size = this.gc.textExtent(note.getNote());
        size.x += 10;
        size.y += 10;
        return size;
    }

    protected void drawNote(NotePadMeta noteMeta) {
        if (noteMeta.isSelected()) {
            this.gc.setLineWidth(2);
        } else {
            this.gc.setLineWidth(1);
        }
        Point minimumSize = this.calculateMinimumSize(noteMeta);
        noteMeta.setMinimumWidth(minimumSize.x);
        noteMeta.setMinimumHeight(minimumSize.y);
        Point loc = noteMeta.getLocation();
        Point note = this.real2screen(loc.x, loc.y);
        int width = noteMeta.width;
        int height = noteMeta.height;
        if (minimumSize.x > width) {
            width = minimumSize.x;
        }
        if (minimumSize.y > height) {
            height = minimumSize.y;
        }
        Rectangle noteShape = new Rectangle(note.x, note.y, width, height);
        this.gc.setBackground(noteMeta.getBackGroundColorRed(), noteMeta.getBackGroundColorGreen(), noteMeta.getBackGroundColorBlue());
        this.gc.setForeground(noteMeta.getBorderColorRed(), noteMeta.getBorderColorGreen(), noteMeta.getBorderColorBlue());
        int radius = (int)Math.round(this.zoomFactor * 8.0);
        this.gc.fillRoundRectangle(noteShape.x, noteShape.y, noteShape.width, noteShape.height, radius, radius);
        this.gc.drawRoundRectangle(noteShape.x, noteShape.y, noteShape.width, noteShape.height, radius, radius);
        if (!Utils.isEmpty((CharSequence)noteMeta.getNote())) {
            this.gc.setForeground(noteMeta.getFontColorRed(), noteMeta.getFontColorGreen(), noteMeta.getFontColorBlue());
            this.gc.drawText(noteMeta.getNote(), note.x + 5, note.y + 5, true);
        }
        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.NOTE, noteShape.x, noteShape.y, noteShape.width, noteShape.height, this.offset, this.subject, noteMeta));
    }

    protected Point real2screen(int x, int y) {
        return new Point((int)((double)x + this.offset.x), (int)((double)y + this.offset.y));
    }

    protected Point magnifyPoint(Point p) {
        return new Point(Math.round((float)p.x * this.magnification), Math.round((float)p.y * this.magnification));
    }

    protected void drawRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.gc.setLineStyle(IGc.ELineStyle.DASHDOT);
        this.gc.setLineWidth(this.lineWidth);
        this.gc.setForeground(IGc.EColor.GRAY);
        Point s = this.real2screen(rect.x, rect.y);
        if (rect.width < 0) {
            s.x += rect.width;
        }
        if (rect.height < 0) {
            s.y += rect.height;
        }
        this.gc.drawRectangle(s.x, s.y, Math.abs(rect.width), Math.abs(rect.height));
        this.gc.setLineStyle(IGc.ELineStyle.SOLID);
    }

    protected void drawGrid() {
        Point bounds = this.gc.getDeviceBounds();
        for (int x = 0; x < bounds.x; x += this.gridSize) {
            for (int y = 0; y < bounds.y; y += this.gridSize) {
                this.gc.drawPoint((int)((double)x + this.offset.x % (double)this.gridSize), (int)((double)y + this.offset.y % (double)this.gridSize));
            }
        }
    }

    protected int round(double value) {
        return (int)Math.round(value);
    }

    protected int calcArrowLength() {
        return 19 + (this.lineWidth - 1) * 5;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Point getArea() {
        return this.area;
    }

    public void setArea(Point area) {
        this.area = area;
    }

    public List<AreaOwner> getAreaOwners() {
        return this.areaOwners;
    }

    public void setAreaOwners(List<AreaOwner> areaOwners) {
        this.areaOwners = areaOwners;
    }

    public DPoint getOffset() {
        return this.offset;
    }

    public void setOffset(DPoint offset) {
        this.offset = offset;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public Rectangle getSelectionRectangle() {
        return this.selectionRectangle;
    }

    public void setSelectionRectangle(Rectangle selectionRectangle) {
        this.selectionRectangle = selectionRectangle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }

    public IGc getGc() {
        return this.gc;
    }

    public void setGc(IGc gc) {
        this.gc = gc;
    }

    public String getNoteFontName() {
        return this.noteFontName;
    }

    public void setNoteFontName(String noteFontName) {
        this.noteFontName = noteFontName;
    }

    public int getNoteFontHeight() {
        return this.noteFontHeight;
    }

    public void setNoteFontHeight(int noteFontHeight) {
        this.noteFontHeight = noteFontHeight;
    }

    public double getTheta() {
        return this.theta;
    }

    public Hop getCandidate() {
        return this.candidate;
    }

    public void setCandidate(Hop candidate) {
        this.candidate = candidate;
    }

    protected int[] getLine(Part fs, Part ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconSize / 2;
        int y1 = from.y + this.iconSize / 2;
        int x2 = to.x + this.iconSize / 2;
        int y2 = to.y + this.iconSize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    protected void drawArrow(IGc.EImage arrow, int[] line, Hop hop, Object startObject, Object endObject) throws HopException {
        Point screenFrom = this.real2screen(line[0], line[1]);
        Point screenTo = this.real2screen(line[2], line[3]);
        this.drawArrow(arrow, screenFrom.x, screenFrom.y, screenTo.x, screenTo.y, this.theta, this.calcArrowLength(), -1.0, hop, startObject, endObject);
    }

    protected abstract void drawArrow(IGc.EImage var1, int var2, int var3, int var4, int var5, double var6, int var8, double var9, Hop var11, Object var12, Object var13) throws HopException;

    protected void drawNavigationView() {
        if (!this.showingNavigationView || this.maximum == null) {
            return;
        }
        int areaWidth = (int)((float)this.area.x / this.magnification);
        int areaHeight = (int)((float)this.area.y / this.magnification);
        double graphWidth = this.maximum.x;
        double graphHeight = this.maximum.y;
        if (graphWidth > 200.0 || graphHeight > 200.0) {
            double coefficient = 200.0 / Math.max(graphWidth, graphHeight);
            graphWidth *= coefficient;
            graphHeight *= coefficient;
        }
        double graphX = (double)this.area.x - graphWidth - 10.0;
        double graphY = (double)this.area.y - graphHeight - 10.0;
        int alpha = this.gc.getAlpha();
        this.gc.setAlpha(75);
        this.gc.setForeground(IGc.EColor.DARKGRAY);
        this.gc.setBackground(IGc.EColor.LIGHTBLUE);
        this.gc.drawRectangle((int)graphX, (int)graphY, (int)graphWidth, (int)graphHeight);
        this.gc.fillRectangle((int)graphX, (int)graphY, (int)graphWidth, (int)graphHeight);
        double viewWidth = graphWidth * (double)areaWidth / (double)Math.max(areaWidth, this.maximum.x);
        double viewHeight = graphHeight * (double)areaHeight / (double)Math.max(areaHeight, this.maximum.y);
        double offsetXFraction = -this.offset.x / (double)this.maximum.x;
        double offsetYFraction = -this.offset.y / (double)this.maximum.y;
        double viewX = graphX + graphWidth * offsetXFraction;
        double viewY = graphY + graphHeight * offsetYFraction;
        this.gc.setForeground(IGc.EColor.BLACK);
        this.gc.setBackground(IGc.EColor.BLUE);
        this.gc.drawRectangle((int)viewX, (int)viewY, (int)viewWidth, (int)viewHeight);
        this.gc.fillRectangle((int)viewX, (int)viewY, (int)viewWidth, (int)viewHeight);
        this.graphPort = new Rectangle((int)graphX, (int)graphY, (int)graphWidth, (int)graphHeight);
        this.viewPort = new Rectangle((int)viewX, (int)viewY, (int)viewWidth, (int)viewHeight);
        this.gc.setAlpha(alpha);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public boolean isDrawingBorderAroundName() {
        return this.drawingBorderAroundName;
    }

    public void setDrawingBorderAroundName(boolean drawingBorderAroundName) {
        this.drawingBorderAroundName = drawingBorderAroundName;
    }

    public int getMiniIconSize() {
        return this.miniIconSize;
    }

    public void setMiniIconSize(int miniIconSize) {
        this.miniIconSize = miniIconSize;
    }

    public boolean isShowingNavigationView() {
        return this.showingNavigationView;
    }

    public void setShowingNavigationView(boolean showingNavigationView) {
        this.showingNavigationView = showingNavigationView;
    }

    public Point getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Point maximum) {
        this.maximum = maximum;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public float getScreenMagnification() {
        return this.screenMagnification;
    }

    public void setScreenMagnification(float screenMagnification) {
        this.screenMagnification = screenMagnification;
    }

    public Rectangle getGraphPort() {
        return this.graphPort;
    }

    public void setGraphPort(Rectangle graphPort) {
        this.graphPort = graphPort;
    }

    public Rectangle getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(Rectangle viewPort) {
        this.viewPort = viewPort;
    }

    public String getMouseOverName() {
        return this.mouseOverName;
    }

    public void setMouseOverName(String mouseOverName) {
        this.mouseOverName = mouseOverName;
    }
}

