/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.truststore;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.truststore.HopTrustManager;
import org.apache.hop.core.truststore.TrustAlwaysManager;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;

public class CustomSocketFactory
extends SSLSocketFactory {
    private static final Class<?> classFromPackage = CustomSocketFactory.class;
    private static boolean configured;
    private static TrustManager[] trustManagers;
    private static final TrustManager[] ALWAYS_TRUST_MANAGER;
    private SSLSocketFactory factory;

    public CustomSocketFactory() {
    }

    protected CustomSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    public static synchronized CustomSocketFactory getDefault() {
        SSLContext ctx;
        if (!configured) {
            throw new IllegalStateException();
        }
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new CustomSocketFactory(ctx.getSocketFactory());
    }

    public static synchronized void configure(String path, String password) throws HopException {
        KeyStore keyStore;
        try {
            keyStore = !Utils.isEmpty((CharSequence)path) && path.endsWith(".p12") ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(classFromPackage, (String)"HopTrustManager.Exception.CouldNotCreateCertStore", (String[])new String[0]), (Throwable)e);
        }
        trustManagers = new HopTrustManager[]{new HopTrustManager(keyStore, path, password)};
        configured = true;
    }

    public static synchronized void configure() {
        trustManagers = ALWAYS_TRUST_MANAGER;
        configured = true;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.factory.createSocket(host, port, clientHost, clientPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.factory.createSocket(host, port, clientHost, clientPort);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException {
        return this.factory.createSocket(socket, host, port, autoclose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    static {
        trustManagers = null;
        ALWAYS_TRUST_MANAGER = new TrustManager[]{new TrustAlwaysManager()};
    }
}

