/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMultimap;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.IHopServerRequestHandler;

public abstract class BaseHopServerPlugin
extends BaseHttpServlet
implements IHopServerPlugin,
IHopServerRequestHandler {
    @Override
    @Deprecated(since="2.0")
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service(req, resp);
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isJettyMode() && !req.getContextPath().endsWith(this.getContextPath())) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.getService());
        }
        this.handleRequest(new HopServerRequestImpl(req, resp));
    }

    @Override
    public abstract void handleRequest(IHopServerRequestHandler.IHopServerRequest var1) throws IOException;

    @Override
    public abstract String getContextPath();

    @Override
    public String getService() {
        return this.getContextPath() + " (" + this.toString() + ")";
    }

    public String toString() {
        HopServerServlet hopServerServlet = this.getClass().getAnnotation(HopServerServlet.class);
        return hopServerServlet != null ? hopServerServlet.name() : super.toString();
    }

    private static FluentIterable<String> fromEnumeration(Enumeration enumeration) {
        ArrayList list = Collections.list(enumeration);
        return FluentIterable.from(list).filter(String.class);
    }

    private class HopServerRequestImpl
    implements IHopServerRequestHandler.IHopServerRequest {
        private final HttpServletRequest req;
        private final HttpServletResponse resp;

        public HopServerRequestImpl(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        @Override
        public String getMethod() {
            return this.req.getMethod();
        }

        @Override
        public Map<String, Collection<String>> getHeaders() {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String name : BaseHopServerPlugin.fromEnumeration(this.req.getHeaderNames())) {
                builder.putAll((Object)name, BaseHopServerPlugin.fromEnumeration(this.req.getHeaders(name)));
            }
            return builder.build().asMap();
        }

        @Override
        public String getHeader(String name) {
            return this.req.getHeader(name);
        }

        @Override
        public Map<String, Collection<String>> getParameters() {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String name : BaseHopServerPlugin.fromEnumeration(this.req.getParameterNames())) {
                builder.putAll((Object)name, (Object[])this.req.getParameterValues(name));
            }
            return builder.build().asMap();
        }

        @Override
        public String getParameter(String name) {
            return this.req.getParameter(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.req.getInputStream();
        }

        @Override
        public IHopServerRequestHandler.IHopServerResponse respond(int status) {
            if (status >= 400) {
                try {
                    this.resp.sendError(status);
                }
                catch (IOException e) {
                    this.resp.setStatus(status);
                }
            } else {
                this.resp.setStatus(status);
            }
            return new IHopServerRequestHandler.IHopServerResponse(){

                @Override
                public void with(String contentType, IHopServerRequestHandler.IWriterResponse response) throws IOException {
                    HopServerRequestImpl.this.resp.setContentType(contentType);
                    response.write(HopServerRequestImpl.this.resp.getWriter());
                }

                @Override
                public void with(String contentType, IHopServerRequestHandler.IOutputStreamResponse response) throws IOException {
                    HopServerRequestImpl.this.resp.setContentType(contentType);
                    response.write((OutputStream)HopServerRequestImpl.this.resp.getOutputStream());
                }

                @Override
                public void withMessage(String text) throws IOException {
                    HopServerRequestImpl.this.resp.setContentType("text/plain");
                    HopServerRequestImpl.this.resp.getWriter().println(text);
                }
            };
        }
    }
}

