/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.spreadsheet.KCellType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputField;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputMeta;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.pipeline.transforms.excelinput.WorkbookFactory;
import org.apache.hop.pipeline.transforms.fileinput.text.DirectoryDialogButtonListenerFactory;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterListDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.core.widget.VariableButtonListenerFactory;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExcelInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ExcelInputMeta.class;
    private static final String CONST_COMBO_NO = "System.Combo.No";
    private static final String CONST_COMBO_YES = "System.Combo.Yes";
    private static final String CONST_ERROR_TITLE = "System.Dialog.Error.Title";
    private static final String CONST_BUTTON_BROWSE = "System.Button.Browse";
    private static final String CONST_BUTTON_VARIABLE = "System.Button.Variable";
    private static final String CONST_LABEL_EXTENSION = "System.Label.Extension";
    private static final String CONST_BROWSE_FOR_DIR = "System.Tooltip.BrowseForDir";
    private static final String CONST_BROWSE_TO_DIR = "System.Tooltip.VariableToDir";
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private CTabFolder wTabFolder;
    private CTabItem wFileTab;
    private CTabItem wSheetTab;
    private CTabItem wFieldsTab;
    private Label wlStatusMessage;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Button wAccFilenames;
    private Label wlAccField;
    private CCombo wAccField;
    private Label wlAccTransform;
    private CCombo wAccTransform;
    private Button wbShowFiles;
    private TableView wSheetNameList;
    private Button wHeader;
    private Button wNoEmpty;
    private Button wStopOnEmpty;
    private Text wInclFilenameField;
    private Text wInclSheetNameField;
    private Text wInclRowNumField;
    private Text wInclSheetRowNumField;
    private Text wLimit;
    private CCombo wSpreadSheetType;
    private CCombo wEncoding;
    private Button wbGetFields;
    private TableView wFields;
    private Button wStrictTypes;
    private Button wErrorIgnored;
    private Label wlSkipErrorLines;
    private MetaSelectionLine<SchemaDefinition> wSchemaDefinition;
    private Button wIgnoreFields;
    private Button wSkipErrorLines;
    private Label wlWarningDestDir;
    private Button wbbWarningDestDir;
    private Button wbvWarningDestDir;
    private TextVar wWarningDestDir;
    private Label wlWarningExt;
    private Text wWarningExt;
    private Label wlErrorDestDir;
    private Button wbbErrorDestDir;
    private Button wbvErrorDestDir;
    private TextVar wErrorDestDir;
    private Label wlErrorExt;
    private Text wErrorExt;
    private Label wlLineNrDestDir;
    private Button wbbLineNrDestDir;
    private Button wbvLineNrDestDir;
    private TextVar wLineNrDestDir;
    private Label wlLineNrExt;
    private Text wLineNrExt;
    private final ExcelInputMeta input;
    private int middle;
    private int margin;
    private boolean gotEncodings = false;
    private Button wAddResult;
    private Text wShortFileFieldName;
    private Text wPathFieldName;
    private Text wIsHiddenName;
    private Text wLastModificationTimeName;
    private Text wUriName;
    private Text wRootUriName;
    private Text wExtensionFieldName;
    private Text wSizeFieldName;

    public ExcelInputDialog(Shell parent, IVariables variables, ExcelInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        IRowMeta previousFields;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewRows.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wlStatusMessage = new Label((Composite)this.shell, 131072);
        this.wlStatusMessage.setText("(This Space To Let)");
        this.wlStatusMessage.setForeground(this.shell.getDisplay().getSystemColor(3));
        PropsUi.setLook((Widget)this.wlStatusMessage);
        FormData fdlStatusMessage = new FormData();
        fdlStatusMessage.left = new FormAttachment(0, 0);
        fdlStatusMessage.top = new FormAttachment((Control)this.wlTransformName, this.margin);
        fdlStatusMessage.right = new FormAttachment(this.middle, -this.margin);
        this.wlStatusMessage.setLayoutData((Object)fdlStatusMessage);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = PropsUi.getFormMargin();
        fileLayout.marginHeight = PropsUi.getFormMargin();
        wFileComp.setLayout((Layout)fileLayout);
        Label wlSpreadSheetType = new Label(wFileComp, 131072);
        wlSpreadSheetType.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SpreadSheetType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpreadSheetType);
        FormData fdlSpreadSheetType = new FormData();
        fdlSpreadSheetType.left = new FormAttachment(0, 0);
        fdlSpreadSheetType.right = new FormAttachment(this.middle, -this.margin);
        fdlSpreadSheetType.top = new FormAttachment(0, 0);
        wlSpreadSheetType.setLayoutData((Object)fdlSpreadSheetType);
        this.wSpreadSheetType = new CCombo(wFileComp, 2056);
        this.wSpreadSheetType.setEditable(true);
        PropsUi.setLook((Widget)this.wSpreadSheetType);
        FormData fdSpreadSheetType = new FormData();
        fdSpreadSheetType.left = new FormAttachment(this.middle, 0);
        fdSpreadSheetType.right = new FormAttachment(100, 0);
        fdSpreadSheetType.top = new FormAttachment(0, 0);
        this.wSpreadSheetType.setLayoutData((Object)fdSpreadSheetType);
        for (SpreadSheetType type : SpreadSheetType.values()) {
            this.wSpreadSheetType.add(type.getDescription());
        }
        this.wlFilenameList = new Label(wFileComp, 16384);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        fdlFilenameList.right = new FormAttachment(100, 0);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(this.middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, -this.margin);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        Group gAccepting = new Group(wFileComp, 16);
        gAccepting.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptingGroup.Label", (String[])new String[0]));
        FormLayout acceptingLayout = new FormLayout();
        acceptingLayout.marginWidth = 3;
        acceptingLayout.marginHeight = 3;
        gAccepting.setLayout((Layout)acceptingLayout);
        PropsUi.setLook((Widget)gAccepting);
        Label wlAccFilenames = new Label((Composite)gAccepting, 131072);
        wlAccFilenames.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptFilenames.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAccFilenames);
        FormData fdlAccFilenames = new FormData();
        fdlAccFilenames.top = new FormAttachment(0, this.margin);
        fdlAccFilenames.left = new FormAttachment(0, 0);
        fdlAccFilenames.right = new FormAttachment(this.middle, -this.margin);
        wlAccFilenames.setLayoutData((Object)fdlAccFilenames);
        this.wAccFilenames = new Button((Composite)gAccepting, 32);
        this.wAccFilenames.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptFilenames.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccFilenames);
        FormData fdAccFilenames = new FormData();
        fdAccFilenames.top = new FormAttachment((Control)wlAccFilenames, 0, 0x1000000);
        fdAccFilenames.left = new FormAttachment(this.middle, 0);
        fdAccFilenames.right = new FormAttachment(100, 0);
        this.wAccFilenames.setLayoutData((Object)fdAccFilenames);
        this.wAccFilenames.addListener(13, e -> this.setFlags());
        this.wlAccTransform = new Label((Composite)gAccepting, 131072);
        this.wlAccTransform.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAccTransform);
        FormData fdlAccTransform = new FormData();
        fdlAccTransform.top = new FormAttachment((Control)this.wAccFilenames, this.margin);
        fdlAccTransform.left = new FormAttachment(0, 0);
        fdlAccTransform.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccTransform.setLayoutData((Object)fdlAccTransform);
        this.wAccTransform = new CCombo((Composite)gAccepting, 18436);
        this.wAccTransform.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptTransform.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccTransform);
        FormData fdAccTransform = new FormData();
        fdAccTransform.top = new FormAttachment((Control)this.wAccFilenames, this.margin);
        fdAccTransform.left = new FormAttachment(this.middle, 0);
        fdAccTransform.right = new FormAttachment(100, 0);
        this.wAccTransform.setLayoutData((Object)fdAccTransform);
        this.wlAccField = new Label((Composite)gAccepting, 131072);
        this.wlAccField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAccField);
        FormData fdlAccField = new FormData();
        fdlAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdlAccField.left = new FormAttachment(0, 0);
        fdlAccField.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccField.setLayoutData((Object)fdlAccField);
        this.wAccField = new CCombo((Composite)gAccepting, 18436);
        try {
            previousFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopTransformException e2) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDialog.UnableToGetInputFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDialog.UnableToGetInputFields.Message", (String[])new String[0]), (Exception)((Object)e2));
            previousFields = new RowMeta();
        }
        this.wAccField.setItems(previousFields.getFieldNames());
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccField);
        FormData fdAccField = new FormData();
        fdAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdAccField.left = new FormAttachment(this.middle, 0);
        fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)fdAccField);
        List prevTransforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName));
        for (TransformMeta prevTransform : prevTransforms) {
            this.wAccTransform.add(prevTransform.getName());
        }
        FormData fdAccepting = new FormData();
        fdAccepting.left = new FormAttachment(0, 0);
        fdAccepting.right = new FormAttachment(100, 0);
        fdAccepting.bottom = new FormAttachment((Control)this.wbShowFiles, -this.margin * 2);
        gAccepting.setLayoutData((Object)fdAccepting);
        ColumnInfo[] colinfo = new ColumnInfo[5];
        colinfo[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FileDir.Column", (String[])new String[0]), 6, false);
        colinfo[0].setUsingVariables(true);
        colinfo[0].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        colinfo[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Wildcard.Column", (String[])new String[0]), 1, false);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false);
        colinfo[2].setUsingVariables(true);
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67586, colinfo, this.input.getFiles().size(), null, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(0, 0);
        fdFilenameList.right = new FormAttachment(100, 0);
        fdFilenameList.top = new FormAttachment((Control)this.wlFilenameList, this.margin);
        fdFilenameList.bottom = new FormAttachment((Control)gAccepting, -this.margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        this.wFilenameList.addModifyListener(event -> this.checkAlerts());
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        this.wFileTab.setControl((Control)wFileComp);
        this.wSheetTab = new CTabItem(this.wTabFolder, 0);
        this.wSheetTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wSheetTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetsTab.TabTitle", (String[])new String[0]));
        Composite wSheetComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wSheetComp);
        FormLayout sheetLayout = new FormLayout();
        sheetLayout.marginWidth = PropsUi.getFormMargin();
        sheetLayout.marginHeight = PropsUi.getFormMargin();
        wSheetComp.setLayout((Layout)sheetLayout);
        Button wbGetSheets = new Button(wSheetComp, 0x1000008);
        PropsUi.setLook((Widget)wbGetSheets);
        wbGetSheets.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.GetSheets.Button", (String[])new String[0]));
        FormData fdbGetSheets = new FormData();
        fdbGetSheets.left = new FormAttachment(this.middle, 0);
        fdbGetSheets.bottom = new FormAttachment(100, -this.margin);
        wbGetSheets.setLayoutData((Object)fdbGetSheets);
        Label wlSheetnameList = new Label(wSheetComp, 131072);
        wlSheetnameList.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetNameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSheetnameList);
        FormData fdlSheetnameList = new FormData();
        fdlSheetnameList.left = new FormAttachment(0, 0);
        fdlSheetnameList.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        fdlSheetnameList.right = new FormAttachment(this.middle, -this.margin);
        wlSheetnameList.setLayoutData((Object)fdlSheetnameList);
        ColumnInfo[] shinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StartRow.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StartColumn.Column", (String[])new String[0]), 1, false)};
        this.wSheetNameList = new TableView(this.variables, wSheetComp, 67586, shinfo, this.input.getSheets().size(), null, this.props);
        PropsUi.setLook((Widget)this.wSheetNameList);
        fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment(100, 0);
        fdFilenameList.top = new FormAttachment(0, 0);
        fdFilenameList.bottom = new FormAttachment((Control)wbGetSheets, -this.margin);
        this.wSheetNameList.setLayoutData((Object)fdFilenameList);
        this.wSheetNameList.addModifyListener(event -> this.checkAlerts());
        FormData fdSheetComp = new FormData();
        fdSheetComp.left = new FormAttachment(0, 0);
        fdSheetComp.top = new FormAttachment(0, 0);
        fdSheetComp.right = new FormAttachment(100, 0);
        fdSheetComp.bottom = new FormAttachment(100, 0);
        wSheetComp.setLayoutData((Object)fdSheetComp);
        wSheetComp.layout();
        this.wSheetTab.setControl((Control)wSheetComp);
        CTabItem wContentTab = new CTabItem(this.wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = PropsUi.getFormMargin();
        contentLayout.marginHeight = PropsUi.getFormMargin();
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Label wlHeader = new Label(wContentComp, 131072);
        wlHeader.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Header.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHeader);
        FormData fdlHeader = new FormData();
        fdlHeader.left = new FormAttachment(0, 0);
        fdlHeader.top = new FormAttachment(0, 0);
        fdlHeader.right = new FormAttachment(this.middle, -this.margin);
        wlHeader.setLayoutData((Object)fdlHeader);
        this.wHeader = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wHeader);
        FormData fdHeader = new FormData();
        fdHeader.left = new FormAttachment(this.middle, 0);
        fdHeader.top = new FormAttachment((Control)wlHeader, 0, 0x1000000);
        fdHeader.right = new FormAttachment(100, 0);
        this.wHeader.setLayoutData((Object)fdHeader);
        this.wHeader.addListener(13, e -> this.setFlags());
        Label wlNoEmpty = new Label(wContentComp, 131072);
        wlNoEmpty.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoEmpty.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNoEmpty);
        FormData fdlNoEmpty = new FormData();
        fdlNoEmpty.left = new FormAttachment(0, 0);
        fdlNoEmpty.top = new FormAttachment((Control)this.wHeader, this.margin);
        fdlNoEmpty.right = new FormAttachment(this.middle, -this.margin);
        wlNoEmpty.setLayoutData((Object)fdlNoEmpty);
        this.wNoEmpty = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wNoEmpty);
        this.wNoEmpty.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoEmpty.Tooltip", (String[])new String[0]));
        FormData fdNoEmpty = new FormData();
        fdNoEmpty.left = new FormAttachment(this.middle, 0);
        fdNoEmpty.top = new FormAttachment((Control)wlNoEmpty, 0, 0x1000000);
        fdNoEmpty.right = new FormAttachment(100, 0);
        this.wNoEmpty.setLayoutData((Object)fdNoEmpty);
        this.wNoEmpty.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlStopOnEmpty = new Label(wContentComp, 131072);
        wlStopOnEmpty.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StopOnEmpty.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStopOnEmpty);
        FormData fdlStopOnEmpty = new FormData();
        fdlStopOnEmpty.left = new FormAttachment(0, 0);
        fdlStopOnEmpty.top = new FormAttachment((Control)this.wNoEmpty, this.margin);
        fdlStopOnEmpty.right = new FormAttachment(this.middle, -this.margin);
        wlStopOnEmpty.setLayoutData((Object)fdlStopOnEmpty);
        this.wStopOnEmpty = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wStopOnEmpty);
        this.wStopOnEmpty.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StopOnEmpty.Tooltip", (String[])new String[0]));
        FormData fdStopOnEmpty = new FormData();
        fdStopOnEmpty.left = new FormAttachment(this.middle, 0);
        fdStopOnEmpty.top = new FormAttachment((Control)wlStopOnEmpty, 0, 0x1000000);
        fdStopOnEmpty.right = new FormAttachment(100, 0);
        this.wStopOnEmpty.setLayoutData((Object)fdStopOnEmpty);
        this.wStopOnEmpty.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlLimit = new Label(wContentComp, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)this.wStopOnEmpty, this.margin);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wStopOnEmpty, this.margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdlEncoding.right = new FormAttachment(this.middle, -this.margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(this.middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.setEncodings();
            this.shell.setCursor(null);
            busy.dispose();
        });
        this.wEncoding.layout();
        Group wAddFileResult = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFileResult.Label", (String[])new String[0]));
        FormLayout addFileResultgroupLayout = new FormLayout();
        addFileResultgroupLayout.marginWidth = 10;
        addFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)addFileResultgroupLayout);
        Label wlAddResult = new Label((Composite)wAddFileResult, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdlAddResult.right = new FormAttachment(this.middle, -this.margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(this.middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, this.margin);
        fdAddFileResult.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdAddFileResult.right = new FormAttachment(100, -this.margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        this.addErrorTab();
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelInputDialog.this.fillFieldsLayoutFromSchema();
                ExcelInputDialog.this.input.setChanged();
            }
        };
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.wSchemaDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, SchemaDefinition.class, wFieldsComp, 0, BaseMessages.getString(PKG, (String)"ExcelInputDialog.SchemaDefinition.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.SchemaDefinition.Tooltip", (String[])new String[0]));
        PropsUi.setLook(this.wSchemaDefinition);
        FormData fdSchemaDefinition = new FormData();
        fdSchemaDefinition.left = new FormAttachment(0, 0);
        fdSchemaDefinition.top = new FormAttachment(0, this.margin);
        fdSchemaDefinition.right = new FormAttachment(100, 0);
        this.wSchemaDefinition.setLayoutData((Object)fdSchemaDefinition);
        try {
            this.wSchemaDefinition.fillItems();
        }
        catch (Exception e3) {
            this.log.logError("Error getting schema definition items", (Throwable)e3);
        }
        this.wSchemaDefinition.addSelectionListener((SelectionListener)lsSelection);
        Label wlIgnoreFields = new Label(wFieldsComp, 131072);
        PropsUi.setLook((Widget)wlIgnoreFields);
        wlIgnoreFields.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IgnoreTransformFields.Label", (String[])new String[0]));
        FormData fdlIgnoreFields = new FormData();
        fdlIgnoreFields.left = new FormAttachment(0, 0);
        fdlIgnoreFields.right = new FormAttachment(this.middle, -this.margin);
        fdlIgnoreFields.top = new FormAttachment(this.wSchemaDefinition, this.margin);
        wlIgnoreFields.setLayoutData((Object)fdlIgnoreFields);
        this.wIgnoreFields = new Button(wFieldsComp, 16416);
        PropsUi.setLook((Widget)this.wIgnoreFields);
        FormData fdIgnoreFields = new FormData();
        fdIgnoreFields.left = new FormAttachment(this.middle, 0);
        fdIgnoreFields.right = new FormAttachment(100, 0);
        fdIgnoreFields.top = new FormAttachment((Control)wlIgnoreFields, 0, 0x1000000);
        this.wIgnoreFields.setLayoutData((Object)fdIgnoreFields);
        this.wIgnoreFields.addListener(13, e -> {
            if (this.wIgnoreFields.getSelection()) {
                this.fillFieldsLayoutFromSchema(false);
            }
            this.setFlags();
        });
        this.wbGetFields = new Button(wFieldsComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbGetFields);
        this.wbGetFields.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.GetFields.Button", (String[])new String[0]));
        int FieldsRows = this.input.getFields().size();
        int fieldsWidth = 600;
        int fieldsHeight = 150;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.TrimType.Column", (String[])new String[0]), 2, IValueMeta.TrimType.getDescriptions()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Repeat.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_COMBO_NO, (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Format.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Currency.Column", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Decimal.Column", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Grouping.Column", (String[])new String[0]), 1)};
        colinf[5].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Repeat.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, colinf, FieldsRows, null, this.props);
        this.wFields.setSize(fieldsWidth, fieldsHeight);
        this.wFields.addModifyListener(event -> this.checkAlerts());
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wIgnoreFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wbGetFields, -this.margin * 2);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        this.setButtonPositions(new Button[]{this.wbGetFields}, this.margin, null);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        PropsUi.setLook((Widget)wFieldsComp);
        this.addAdditionalFieldsTab();
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wlStatusMessage, this.margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wbShowFiles.addListener(13, e -> this.showFiles());
        wbGetSheets.addListener(13, e -> this.getSheets());
        this.wbGetFields.addListener(13, e -> this.getFields());
        this.wTabFolder.setSelection(0);
        this.getData(this.input);
        this.wFields.optWidth(true);
        this.checkAlerts();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void fillFieldsLayoutFromSchema() {
        this.fillFieldsLayoutFromSchema(true);
    }

    private void fillFieldsLayoutFromSchema(boolean askConfirmation) {
        if (!this.wSchemaDefinition.isDisposed()) {
            String schemaName = this.wSchemaDefinition.getText();
            int answer = 64;
            if (askConfirmation) {
                MessageBox mb = new MessageBox(this.shell, 196);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Load.SchemaDefinition.Message", (String[])new String[]{schemaName}));
                mb.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Load.SchemaDefinition.Title", (String[])new String[0]));
                answer = mb.open();
            }
            if (answer == 64 && !Utils.isEmpty((CharSequence)schemaName)) {
                try {
                    String[] fieldNames;
                    IRowMeta r;
                    SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                    if (schemaDefinition != null && (r = schemaDefinition.getRowMeta()) != null && (fieldNames = r.getFieldNames()) != null) {
                        this.wFields.closeActiveEditors();
                        this.wFields.clearAll();
                        for (int i = 0; i < fieldNames.length; ++i) {
                            IValueMeta valueMeta = r.getValueMeta(i);
                            TableItem item = new TableItem(this.wFields.table, 0);
                            item.setText(1, valueMeta.getName());
                            item.setText(2, ValueMetaFactory.getValueMetaName((int)valueMeta.getType()));
                            item.setText(3, valueMeta.getLength() >= 0 ? Integer.toString(valueMeta.getLength()) : "");
                            item.setText(4, valueMeta.getPrecision() >= 0 ? Integer.toString(valueMeta.getPrecision()) : "");
                            item.setText(5, Const.NVL((String)ValueMetaBase.getTrimTypeDesc((int)valueMeta.getTrimType()), (String)""));
                            item.setText(7, Const.NVL((String)valueMeta.getConversionMask(), (String)""));
                            SchemaFieldDefinition schemaFieldDefinition = (SchemaFieldDefinition)schemaDefinition.getFieldDefinitions().get(i);
                            item.setText(8, Const.NVL((String)schemaFieldDefinition.getCurrencySymbol(), (String)""));
                            item.setText(9, Const.NVL((String)schemaFieldDefinition.getDecimalSymbol(), (String)""));
                            item.setText(10, Const.NVL((String)schemaFieldDefinition.getGroupingSymbol(), (String)""));
                        }
                    }
                }
                catch (HopPluginException | HopTransformException throwable) {
                    // empty catch block
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
                this.wFields.table.redraw();
                this.wFields.table.update();
            }
        }
    }

    public void setFlags() {
        this.wbGetFields.setEnabled(this.wHeader.getSelection());
        boolean accept = this.wAccFilenames.getSelection();
        this.wlAccField.setEnabled(accept);
        this.wAccField.setEnabled(accept);
        this.wlAccTransform.setEnabled(accept);
        this.wAccTransform.setEnabled(accept);
        this.wlFilenameList.setEnabled(!accept);
        this.wFilenameList.setEnabled(!accept);
        this.wbShowFiles.setEnabled(!accept);
        this.wlSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarningExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarningExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wFields.setEnabled(!this.wIgnoreFields.getSelection());
        this.wbGetFields.setEnabled(!this.wIgnoreFields.getSelection());
    }

    protected SelectionAdapter getFileSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    String[] stringArray;
                    String path = ExcelInputDialog.this.wFilenameList.getActiveTableItem().getText(ExcelInputDialog.this.wFilenameList.getActiveTableColumn());
                    FileObject fileObject = HopVfs.getFileObject((String)path);
                    SpreadSheetType type = SpreadSheetType.getSpreadSheetTypeByDescription(ExcelInputDialog.this.wSpreadSheetType.getText());
                    if (type == null) {
                        return;
                    }
                    switch (type) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case SAX_POI: {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = "*.xlsx;*.XLSX;*.xlsm;*.XLSM";
                            stringArray = stringArray2;
                            stringArray2[1] = "*";
                            break;
                        }
                        case ODS: {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = "*.ods;*.ODS;";
                            stringArray = stringArray3;
                            stringArray3[1] = "*";
                            break;
                        }
                        case POI: {
                            String[] stringArray4 = new String[2];
                            stringArray4[0] = "*.xls;*.XLS;*.xlsx;*.XLSX;*.xlsm;*.XLSM";
                            stringArray = stringArray4;
                            stringArray4[1] = "*";
                        }
                    }
                    String[] extensions = stringArray;
                    path = BaseDialog.presentFileDialog((Shell)ExcelInputDialog.this.shell, null, (IVariables)ExcelInputDialog.this.variables, (FileObject)fileObject, (String[])extensions, (String[])new String[]{BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilterNames.ExcelFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
                    if (path != null) {
                        ExcelInputDialog.this.wFilenameList.getActiveTableItem().setText(ExcelInputDialog.this.wFilenameList.getActiveTableColumn(), path);
                    }
                }
                catch (HopFileException e) {
                    ExcelInputDialog.this.log.logError("Error selecting file or directory", (Throwable)e);
                }
            }
        };
    }

    public void getData(ExcelInputMeta meta) {
        TableItem item;
        int i;
        for (i = 0; i < meta.getFiles().size(); ++i) {
            ExcelInputMeta.EIFile file = meta.getFiles().get(i);
            item = this.wFilenameList.table.getItem(i);
            item.setText(1, Const.NVL((String)file.getName(), (String)""));
            item.setText(2, Const.NVL((String)file.getMask(), (String)""));
            item.setText(3, Const.NVL((String)file.getExcludeMask(), (String)""));
            item.setText(4, Const.NVL((String)file.getRequired(), (String)""));
            item.setText(5, Const.NVL((String)file.getIncludeSubFolders(), (String)""));
        }
        this.wFilenameList.optimizeTableView();
        this.wAccFilenames.setSelection(meta.isAcceptingFilenames());
        this.wSchemaDefinition.setText(Const.NVL((String)meta.getSchemaDefinition(), (String)""));
        this.wIgnoreFields.setSelection(meta.isIgnoreFields());
        if (meta.isIgnoreFields()) {
            this.fillFieldsLayoutFromSchema(false);
            this.setFlags();
        }
        if (meta.getAcceptingField() != null && !meta.getAcceptingField().isEmpty()) {
            this.wAccField.select(this.wAccField.indexOf(meta.getAcceptingField()));
        }
        if (meta.getAcceptingTransformName() != null && !meta.getAcceptingTransformName().isEmpty()) {
            this.wAccTransform.select(this.wAccTransform.indexOf(meta.getAcceptingTransformName()));
        }
        this.wHeader.setSelection(meta.isStartsWithHeader());
        this.wNoEmpty.setSelection(meta.isIgnoreEmptyRows());
        this.wStopOnEmpty.setSelection(meta.isStopOnEmpty());
        this.wInclFilenameField.setText(Const.NVL((String)meta.getFileField(), (String)""));
        this.wInclSheetNameField.setText(Const.NVL((String)meta.getSheetField(), (String)""));
        this.wInclSheetRowNumField.setText(Const.NVL((String)meta.getSheetRowNumberField(), (String)""));
        this.wInclRowNumField.setText(Const.NVL((String)meta.getRowNumberField(), (String)""));
        this.wLimit.setText("" + meta.getRowLimit());
        this.wEncoding.setText(Const.NVL((String)meta.getEncoding(), (String)""));
        this.wSpreadSheetType.setText(meta.getSpreadSheetType().getDescription());
        this.wAddResult.setSelection(meta.isAddResultFile());
        if (this.isDebug()) {
            this.logDebug("getting fields info...");
        }
        if (!meta.isIgnoreFields()) {
            for (i = 0; i < meta.getFields().size(); ++i) {
                ExcelInputField f = meta.getFields().get(i);
                item = this.wFields.table.getItem(i);
                String field = f.getName();
                String type = f.getTypeDesc();
                String length = "" + f.getLength();
                String prec = "" + f.getPrecision();
                String trim = f.getTrimType().getDescription();
                String rep = f.isRepeat() ? BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)CONST_COMBO_NO, (String[])new String[0]);
                String format = f.getFormat();
                String currency = f.getCurrencySymbol();
                String decimal = f.getDecimalSymbol();
                String grouping = f.getGroupSymbol();
                item.setText(1, Const.NVL((String)field, (String)""));
                item.setText(2, Const.NVL((String)type, (String)""));
                item.setText(3, Const.NVL((String)length, (String)""));
                item.setText(4, Const.NVL((String)prec, (String)""));
                item.setText(5, Const.NVL((String)trim, (String)""));
                item.setText(6, Const.NVL((String)rep, (String)""));
                item.setText(7, Const.NVL((String)format, (String)""));
                item.setText(8, Const.NVL((String)currency, (String)""));
                item.setText(9, Const.NVL((String)decimal, (String)""));
                item.setText(10, Const.NVL((String)grouping, (String)""));
            }
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.logDebug("getting sheets info...");
        for (i = 0; i < meta.getSheets().size(); ++i) {
            ExcelInputMeta.EISheet sheet = meta.getSheets().get(i);
            item = this.wSheetNameList.table.getItem(i);
            String sheetname = sheet.getName();
            String startrow = "" + sheet.getStartRow();
            String startcol = "" + sheet.getStartColumn();
            item.setText(1, Const.NVL((String)sheetname, (String)""));
            item.setText(2, Const.NVL((String)startrow, (String)""));
            item.setText(3, Const.NVL((String)startcol, (String)""));
        }
        this.wSheetNameList.optimizeTableView();
        this.wErrorIgnored.setSelection(meta.isErrorIgnored());
        this.wStrictTypes.setSelection(meta.isStrictTypes());
        this.wSkipErrorLines.setSelection(meta.isErrorLineSkipped());
        this.wWarningDestDir.setText(Const.NVL((String)meta.getWarningFilesDestinationDirectory(), (String)""));
        this.wWarningExt.setText(Const.NVL((String)meta.getBadLineFilesExtension(), (String)""));
        this.wErrorDestDir.setText(Const.NVL((String)meta.getErrorFilesDestinationDirectory(), (String)""));
        this.wErrorExt.setText(Const.NVL((String)meta.getErrorFilesExtension(), (String)""));
        this.wLineNrDestDir.setText(Const.NVL((String)meta.getLineNumberFilesDestinationDirectory(), (String)""));
        this.wLineNrExt.setText(Const.NVL((String)meta.getLineNumberFilesExtension(), (String)""));
        this.wPathFieldName.setText(Const.NVL((String)meta.getPathFieldName(), (String)""));
        this.wShortFileFieldName.setText(Const.NVL((String)meta.getShortFileFieldName(), (String)""));
        this.wPathFieldName.setText(Const.NVL((String)meta.getPathFieldName(), (String)""));
        this.wIsHiddenName.setText(Const.NVL((String)meta.getHiddenFieldName(), (String)""));
        this.wLastModificationTimeName.setText(Const.NVL((String)meta.getLastModificationTimeFieldName(), (String)""));
        this.wUriName.setText(Const.NVL((String)meta.getUriNameFieldName(), (String)""));
        this.wRootUriName.setText(Const.NVL((String)meta.getRootUriNameFieldName(), (String)""));
        this.wExtensionFieldName.setText(Const.NVL((String)meta.getExtensionFieldName(), (String)""));
        this.wSizeFieldName.setText(Const.NVL((String)meta.getSizeFieldName(), (String)""));
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    private void getInfo(ExcelInputMeta meta) {
        TransformMeta currentTransformMeta = this.pipelineMeta.findTransform(this.transformName);
        this.transformName = this.wTransformName.getText();
        meta.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        meta.setEncoding(this.wEncoding.getText());
        meta.setSchemaDefinition(this.wSchemaDefinition.getText());
        meta.setIgnoreFields(this.wIgnoreFields.getSelection());
        meta.setSpreadSheetType(SpreadSheetType.values()[this.wSpreadSheetType.getSelectionIndex()]);
        meta.setFileField(this.wInclFilenameField.getText());
        meta.setSheetField(this.wInclSheetNameField.getText());
        meta.setSheetRowNumberField(this.wInclSheetRowNumField.getText());
        meta.setRowNumberField(this.wInclRowNumField.getText());
        meta.setAddResultFile(this.wAddResult.getSelection());
        meta.setStartsWithHeader(this.wHeader.getSelection());
        meta.setIgnoreEmptyRows(this.wNoEmpty.getSelection());
        meta.setStopOnEmpty(this.wStopOnEmpty.getSelection());
        meta.setAcceptingFilenames(this.wAccFilenames.getSelection());
        meta.setAcceptingField(this.wAccField.getText());
        meta.setAcceptingTransformName(this.wAccTransform.getText());
        meta.searchInfoAndTargetTransforms(this.pipelineMeta.findPreviousTransforms(currentTransformMeta));
        meta.getSheets().clear();
        for (TableItem item : this.wSheetNameList.getNonEmptyItems()) {
            ExcelInputMeta.EISheet sheet = new ExcelInputMeta.EISheet();
            sheet.setName(item.getText(1));
            sheet.setStartRow(Const.toInt((String)item.getText(2), (int)0));
            sheet.setStartColumn(Const.toInt((String)item.getText(3), (int)0));
            meta.getSheets().add(sheet);
        }
        meta.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            ExcelInputField field = new ExcelInputField();
            field.setName(item.getText(1));
            field.setType(item.getText(2));
            String slength = item.getText(3);
            String sprec = item.getText(4);
            field.setTrimType(IValueMeta.TrimType.lookupDescription((String)item.getText(5)));
            field.setRepeat(BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(6)));
            field.setLength(Const.toInt((String)slength, (int)-1));
            field.setPrecision(Const.toInt((String)sprec, (int)-1));
            field.setFormat(item.getText(7));
            field.setCurrencySymbol(item.getText(8));
            field.setDecimalSymbol(item.getText(9));
            field.setGroupSymbol(item.getText(10));
            meta.getFields().add(field);
        }
        meta.getFiles().clear();
        for (TableItem item : this.wFilenameList.getNonEmptyItems()) {
            ExcelInputMeta.EIFile file = new ExcelInputMeta.EIFile();
            file.setName(item.getText(1));
            file.setMask(item.getText(2));
            file.setExcludeMask(item.getText(3));
            file.setRequired(item.getText(4));
            file.setIncludeSubFolders(item.getText(5));
            meta.getFiles().add(file);
        }
        meta.setStrictTypes(this.wStrictTypes.getSelection());
        meta.setErrorIgnored(this.wErrorIgnored.getSelection());
        meta.setErrorLineSkipped(this.wSkipErrorLines.getSelection());
        meta.setWarningFilesDestinationDirectory(this.wWarningDestDir.getText());
        meta.setBadLineFilesExtension(this.wWarningExt.getText());
        meta.setErrorFilesDestinationDirectory(this.wErrorDestDir.getText());
        meta.setErrorFilesExtension(this.wErrorExt.getText());
        meta.setLineNumberFilesDestinationDirectory(this.wLineNrDestDir.getText());
        meta.setLineNumberFilesExtension(this.wLineNrExt.getText());
        meta.setShortFileFieldName(this.wShortFileFieldName.getText());
        meta.setPathFieldName(this.wPathFieldName.getText());
        meta.setHiddenFieldName(this.wIsHiddenName.getText());
        meta.setLastModificationTimeFieldName(this.wLastModificationTimeName.getText());
        meta.setUriNameFieldName(this.wUriName.getText());
        meta.setRootUriNameFieldName(this.wRootUriName.getText());
        meta.setExtensionFieldName(this.wExtensionFieldName.getText());
        meta.setSizeFieldName(this.wSizeFieldName.getText());
    }

    private void addErrorTab() {
        CTabItem wErrorTab = new CTabItem(this.wTabFolder, 0);
        wErrorTab.setFont(GuiResource.getInstance().getFontDefault());
        wErrorTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorTab.TabTitle", (String[])new String[0]));
        FormLayout errorLayout = new FormLayout();
        errorLayout.marginWidth = 3;
        errorLayout.marginHeight = 3;
        Composite wErrorComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wErrorComp);
        wErrorComp.setLayout((Layout)errorLayout);
        Label wlStrictTypes = new Label(wErrorComp, 131072);
        wlStrictTypes.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StrictTypes.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStrictTypes);
        FormData fdlStrictTypes = new FormData();
        fdlStrictTypes.left = new FormAttachment(0, 0);
        fdlStrictTypes.top = new FormAttachment(0, this.margin);
        fdlStrictTypes.right = new FormAttachment(this.middle, -this.margin);
        wlStrictTypes.setLayoutData((Object)fdlStrictTypes);
        this.wStrictTypes = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wStrictTypes);
        this.wStrictTypes.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StrictTypes.Tooltip", (String[])new String[0]));
        FormData fdStrictTypes = new FormData();
        fdStrictTypes.left = new FormAttachment(this.middle, 0);
        fdStrictTypes.top = new FormAttachment((Control)wlStrictTypes, 0, 0x1000000);
        this.wStrictTypes.setLayoutData((Object)fdStrictTypes);
        Button previous = this.wStrictTypes;
        this.wStrictTypes.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlErrorIgnored = new Label(wErrorComp, 131072);
        wlErrorIgnored.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorIgnored.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlErrorIgnored);
        FormData fdlErrorIgnored = new FormData();
        fdlErrorIgnored.left = new FormAttachment(0, 0);
        fdlErrorIgnored.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorIgnored.right = new FormAttachment(this.middle, -this.margin);
        wlErrorIgnored.setLayoutData((Object)fdlErrorIgnored);
        this.wErrorIgnored = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wErrorIgnored);
        this.wErrorIgnored.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorIgnored.Tooltip", (String[])new String[0]));
        FormData fdErrorIgnored = new FormData();
        fdErrorIgnored.left = new FormAttachment(this.middle, 0);
        fdErrorIgnored.top = new FormAttachment((Control)wlErrorIgnored, 0, 0x1000000);
        this.wErrorIgnored.setLayoutData((Object)fdErrorIgnored);
        previous = this.wErrorIgnored;
        this.wErrorIgnored.addListener(13, e -> this.setFlags());
        this.wlSkipErrorLines = new Label(wErrorComp, 131072);
        this.wlSkipErrorLines.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SkipErrorLines.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSkipErrorLines);
        FormData fdlSkipErrorLines = new FormData();
        fdlSkipErrorLines.left = new FormAttachment(0, 0);
        fdlSkipErrorLines.top = new FormAttachment((Control)previous, this.margin);
        fdlSkipErrorLines.right = new FormAttachment(this.middle, -this.margin);
        this.wlSkipErrorLines.setLayoutData((Object)fdlSkipErrorLines);
        this.wSkipErrorLines = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wSkipErrorLines);
        this.wSkipErrorLines.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SkipErrorLines.Tooltip", (String[])new String[0]));
        FormData fdSkipErrorLines = new FormData();
        fdSkipErrorLines.left = new FormAttachment(this.middle, 0);
        fdSkipErrorLines.top = new FormAttachment((Control)this.wlSkipErrorLines, 0, 0x1000000);
        this.wSkipErrorLines.setLayoutData((Object)fdSkipErrorLines);
        this.wSkipErrorLines.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        previous = this.wSkipErrorLines;
        this.wlWarningDestDir = new Label(wErrorComp, 131072);
        this.wlWarningDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.WarningDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWarningDestDir);
        FormData fdlWarningDestDir = new FormData();
        fdlWarningDestDir.left = new FormAttachment(0, 0);
        fdlWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarningDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlWarningDestDir.setLayoutData((Object)fdlWarningDestDir);
        this.wbbWarningDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbWarningDestDir);
        this.wbbWarningDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_BROWSE, (String[])new String[0]));
        this.wbbWarningDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_FOR_DIR, (String[])new String[0]));
        FormData fdbWarningDestDir = new FormData();
        fdbWarningDestDir.right = new FormAttachment(100, 0);
        fdbWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wbbWarningDestDir.setLayoutData((Object)fdbWarningDestDir);
        this.wbvWarningDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbvWarningDestDir);
        this.wbvWarningDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_VARIABLE, (String[])new String[0]));
        this.wbvWarningDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_TO_DIR, (String[])new String[0]));
        FormData fdbvWarningDestDir = new FormData();
        fdbvWarningDestDir.right = new FormAttachment((Control)this.wbbWarningDestDir, -this.margin);
        fdbvWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wbvWarningDestDir.setLayoutData((Object)fdbvWarningDestDir);
        this.wWarningExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wWarningExt);
        FormData fdWarningDestExt = new FormData();
        fdWarningDestExt.left = new FormAttachment((Control)this.wbvWarningDestDir, -150);
        fdWarningDestExt.right = new FormAttachment((Control)this.wbvWarningDestDir, -this.margin);
        fdWarningDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarningExt.setLayoutData((Object)fdWarningDestExt);
        this.wlWarningExt = new Label(wErrorComp, 131072);
        this.wlWarningExt.setText(BaseMessages.getString(PKG, (String)CONST_LABEL_EXTENSION, (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWarningExt);
        FormData fdlWarningDestExt = new FormData();
        fdlWarningDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarningDestExt.right = new FormAttachment((Control)this.wWarningExt, -this.margin);
        this.wlWarningExt.setLayoutData((Object)fdlWarningDestExt);
        this.wWarningDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wWarningDestDir);
        FormData fdWarningDestDir = new FormData();
        fdWarningDestDir.left = new FormAttachment(this.middle, 0);
        fdWarningDestDir.right = new FormAttachment((Control)this.wlWarningExt, -this.margin);
        fdWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarningDestDir.setLayoutData((Object)fdWarningDestDir);
        this.wbbWarningDestDir.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wWarningDestDir, (IVariables)this.variables));
        this.wbvWarningDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wWarningDestDir, (IVariables)this.variables));
        this.wWarningDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wWarningDestDir));
        previous = this.wWarningDestDir;
        this.wlErrorDestDir = new Label(wErrorComp, 131072);
        this.wlErrorDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorDestDir);
        FormData fdlErrorDestDir = new FormData();
        fdlErrorDestDir.left = new FormAttachment(0, 0);
        fdlErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorDestDir.setLayoutData((Object)fdlErrorDestDir);
        this.wbbErrorDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbErrorDestDir);
        this.wbbErrorDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_BROWSE, (String[])new String[0]));
        this.wbbErrorDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_FOR_DIR, (String[])new String[0]));
        FormData fdbErrorDestDir = new FormData();
        fdbErrorDestDir.right = new FormAttachment(100, 0);
        fdbErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbErrorDestDir.setLayoutData((Object)fdbErrorDestDir);
        this.wbvErrorDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbvErrorDestDir);
        this.wbvErrorDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_VARIABLE, (String[])new String[0]));
        this.wbvErrorDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_TO_DIR, (String[])new String[0]));
        FormData fdbvErrorDestDir = new FormData();
        fdbvErrorDestDir.right = new FormAttachment((Control)this.wbbErrorDestDir, -this.margin);
        fdbvErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbvErrorDestDir.setLayoutData((Object)fdbvErrorDestDir);
        this.wErrorExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorExt);
        FormData fdErrorDestExt = new FormData();
        fdErrorDestExt.left = new FormAttachment((Control)this.wbvErrorDestDir, -150);
        fdErrorDestExt.right = new FormAttachment((Control)this.wbvErrorDestDir, -this.margin);
        fdErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorExt.setLayoutData((Object)fdErrorDestExt);
        this.wlErrorExt = new Label(wErrorComp, 131072);
        this.wlErrorExt.setText(BaseMessages.getString(PKG, (String)CONST_LABEL_EXTENSION, (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorExt);
        FormData fdlErrorDestExt = new FormData();
        fdlErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestExt.right = new FormAttachment((Control)this.wErrorExt, -this.margin);
        this.wlErrorExt.setLayoutData((Object)fdlErrorDestExt);
        this.wErrorDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorDestDir);
        FormData fdErrorDestDir = new FormData();
        fdErrorDestDir.left = new FormAttachment(this.middle, 0);
        fdErrorDestDir.right = new FormAttachment((Control)this.wlErrorExt, -this.margin);
        fdErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorDestDir.setLayoutData((Object)fdErrorDestDir);
        this.wbbErrorDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter((Shell)this.shell, (TextVar)this.wErrorDestDir));
        this.wbvErrorDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wErrorDestDir, (IVariables)this.variables));
        this.wErrorDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wErrorDestDir));
        previous = this.wErrorDestDir;
        this.wlLineNrDestDir = new Label(wErrorComp, 131072);
        this.wlLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.LineNrDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLineNrDestDir);
        FormData fdlLineNrDestDir = new FormData();
        fdlLineNrDestDir.left = new FormAttachment(0, 0);
        fdlLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlLineNrDestDir.setLayoutData((Object)fdlLineNrDestDir);
        this.wbbLineNrDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbLineNrDestDir);
        this.wbbLineNrDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_BROWSE, (String[])new String[0]));
        this.wbbLineNrDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_FOR_DIR, (String[])new String[0]));
        FormData fdbLineNrDestDir = new FormData();
        fdbLineNrDestDir.right = new FormAttachment(100, 0);
        fdbLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbLineNrDestDir.setLayoutData((Object)fdbLineNrDestDir);
        this.wbvLineNrDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbvLineNrDestDir);
        this.wbvLineNrDestDir.setText(BaseMessages.getString(PKG, (String)CONST_BUTTON_VARIABLE, (String[])new String[0]));
        this.wbvLineNrDestDir.setToolTipText(BaseMessages.getString(PKG, (String)CONST_BROWSE_TO_DIR, (String[])new String[0]));
        FormData fdbvLineNrDestDir = new FormData();
        fdbvLineNrDestDir.right = new FormAttachment((Control)this.wbbLineNrDestDir, -this.margin);
        fdbvLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbvLineNrDestDir.setLayoutData((Object)fdbvLineNrDestDir);
        this.wLineNrExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wLineNrExt);
        FormData fdLineNrDestExt = new FormData();
        fdLineNrDestExt.left = new FormAttachment((Control)this.wbvLineNrDestDir, -150);
        fdLineNrDestExt.right = new FormAttachment((Control)this.wbvLineNrDestDir, -this.margin);
        fdLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrExt.setLayoutData((Object)fdLineNrDestExt);
        this.wlLineNrExt = new Label(wErrorComp, 131072);
        this.wlLineNrExt.setText(BaseMessages.getString(PKG, (String)CONST_LABEL_EXTENSION, (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLineNrExt);
        FormData fdlLineNrDestExt = new FormData();
        fdlLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestExt.right = new FormAttachment((Control)this.wLineNrExt, -this.margin);
        this.wlLineNrExt.setLayoutData((Object)fdlLineNrDestExt);
        this.wLineNrDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wLineNrDestDir);
        FormData fdLineNrDestDir = new FormData();
        fdLineNrDestDir.left = new FormAttachment(this.middle, 0);
        fdLineNrDestDir.right = new FormAttachment((Control)this.wlLineNrExt, -this.margin);
        fdLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrDestDir.setLayoutData((Object)fdLineNrDestDir);
        this.wbbLineNrDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter((Shell)this.shell, (TextVar)this.wLineNrDestDir));
        this.wbvLineNrDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wLineNrDestDir, (IVariables)this.variables));
        this.wLineNrDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wLineNrDestDir));
        wErrorComp.layout();
        wErrorTab.setControl((Control)wErrorComp);
    }

    private void preview() {
        ExcelInputMeta oneMeta = new ExcelInputMeta();
        this.getInfo(oneMeta);
        if (oneMeta.isAcceptingFilenames()) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Dialog.SpecifyASampleFile.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Dialog.SpecifyASampleFile.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            oneMeta.setRowLimit(previewSize);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    public void getSheets() {
        ArrayList<String> sheetNames = new ArrayList<String>();
        ExcelInputMeta info = new ExcelInputMeta();
        this.getInfo(info);
        FileInputList fileList = info.getFileList(this.variables);
        for (FileObject fileObject : fileList.getFiles()) {
            try {
                IKWorkbook workbook = WorkbookFactory.getWorkbook(info.getSpreadSheetType(), HopVfs.getFilename((FileObject)fileObject), info.getEncoding(), this.variables);
                int nrSheets = workbook.getNumberOfSheets();
                for (int j = 0; j < nrSheets; ++j) {
                    IKSheet sheet = workbook.getSheet(j);
                    String sheetname = sheet.getName();
                    if (Const.indexOfString((String)sheetname, sheetNames) >= 0) continue;
                    sheetNames.add(sheetname);
                }
                workbook.close();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorReadingFile.DialogMessage", (String[])new String[]{HopVfs.getFilename((FileObject)fileObject)}), e);
            }
        }
        String[] lst = sheetNames.toArray(new String[0]);
        EnterListDialog esd = new EnterListDialog(this.shell, 0, lst);
        String[] selection = esd.open();
        if (selection != null) {
            for (String s : selection) {
                this.wSheetNameList.add(new String[]{s, ""});
            }
            this.wSheetNameList.removeEmptyRows();
            this.wSheetNameList.setRowNums();
            this.wSheetNameList.optWidth(true);
            this.checkAlerts();
        }
    }

    public void getFields() {
        RowMeta fields = new RowMeta();
        ExcelInputMeta info = new ExcelInputMeta();
        this.getInfo(info);
        int clearFields = 64;
        if (this.wFields.nrNonEmpty() > 0) {
            MessageBox messageBox = new MessageBox(this.shell, 452);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ClearFieldList.DialogMessage", (String[])new String[0]));
            messageBox.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ClearFieldList.DialogTitle", (String[])new String[0]));
            clearFields = messageBox.open();
            if (clearFields == 256) {
                return;
            }
        }
        FileInputList fileList = info.getFileList(this.variables);
        for (FileObject file : fileList.getFiles()) {
            try {
                IKWorkbook workbook = WorkbookFactory.getWorkbook(info.getSpreadSheetType(), HopVfs.getFilename((FileObject)file), info.getEncoding(), this.variables);
                this.processingWorkbook((IRowMeta)fields, info, workbook);
                workbook.close();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorReadingFile2.DialogMessage", (String[])new String[]{HopVfs.getFilename((FileObject)file), e.toString()}), e);
            }
        }
        if (!fields.isEmpty()) {
            if (clearFields == 64) {
                this.wFields.clearAll(false);
            }
            for (int j = 0; j < fields.size(); ++j) {
                IValueMeta field = fields.getValueMeta(j);
                this.wFields.add(new String[]{field.getName(), field.getTypeDesc(), "", "", "none", "N"});
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        } else {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UnableToFindFields.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UnableToFindFields.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.checkAlerts();
    }

    private void processingWorkbook(IRowMeta fields, ExcelInputMeta meta, IKWorkbook workbook) throws HopPluginException {
        int nrSheets = workbook.getNumberOfSheets();
        for (int j = 0; j < nrSheets; ++j) {
            IKSheet sheet = workbook.getSheet(j);
            int sheetIndex = meta.readAllSheets() ? 0 : Const.indexOfString((String)sheet.getName(), (String[])meta.getSheetsNames());
            if (sheetIndex < 0) continue;
            ExcelInputMeta.EISheet sh = meta.getSheets().get(sheetIndex);
            int rowNr = sh.getStartRow();
            int startCol = sh.getStartColumn();
            boolean stop = false;
            int colnr = startCol;
            while (!stop) {
                try {
                    String fieldName = null;
                    IKCell cell = sheet.getCell(colnr, rowNr);
                    if (cell == null) {
                        stop = true;
                    } else {
                        IKCell below;
                        if (cell.getType() != KCellType.EMPTY) {
                            fieldName = cell.getContents();
                        }
                        int fieldType = (below = sheet.getCell(colnr, rowNr + 1)) != null ? (below.getType() == KCellType.BOOLEAN ? 4 : (below.getType() == KCellType.DATE ? 3 : (below.getType() == KCellType.LABEL ? 2 : (below.getType() == KCellType.NUMBER ? 1 : 2)))) : 2;
                        if (Utils.isEmpty((CharSequence)fieldName)) {
                            stop = true;
                        } else {
                            IValueMeta field = ValueMetaFactory.createValueMeta((String)fieldName, (int)fieldType);
                            fields.addValueMeta(field);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    stop = true;
                }
                ++colnr;
            }
        }
    }

    private void showFiles() {
        ExcelInputMeta eii = new ExcelInputMeta();
        this.getInfo(eii);
        String[] files = eii.getFilePaths(this.variables);
        if (files.length > 0) {
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, files, BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilesRead.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilesRead.DialogMessage", (String[])new String[0]));
            esd.setViewOnly();
            esd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)CONST_ERROR_TITLE, (String[])new String[0]));
            mb.open();
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    private void checkAlerts() {
        this.logDebug("checkAlerts");
        boolean fieldsOk = this.wFields.nrNonEmpty() != 0;
        boolean sheetsOk = this.wSheetNameList.nrNonEmpty() != 0;
        boolean filesOk = this.wFilenameList.nrNonEmpty() != 0 || this.wAccFilenames.getSelection() && !Utils.isEmpty((CharSequence)this.wAccField.getText());
        this.tagTab(!fieldsOk, this.wFieldsTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFields", (String[])new String[0]));
        this.tagTab(!sheetsOk, this.wSheetTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddSheets", (String[])new String[0]));
        this.tagTab(!filesOk, this.wFileTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFilenames", (String[])new String[0]));
        String msgText = "";
        if (!fieldsOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFields", (String[])new String[0]);
        } else if (!sheetsOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddSheets", (String[])new String[0]);
        } else if (!filesOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFilenames", (String[])new String[0]);
        }
        this.wlStatusMessage.setText(msgText);
        this.wPreview.setEnabled(fieldsOk && sheetsOk && filesOk);
    }

    private void tagTab(boolean highlight, CTabItem tabItem, String toolTip) {
        if (highlight) {
            tabItem.setImage(GuiResource.getInstance().getImageWarning());
            tabItem.setToolTipText(toolTip);
        } else {
            tabItem.setImage(null);
            tabItem.setToolTipText(null);
        }
    }

    private void addAdditionalFieldsTab() {
        CTabItem wAdditionalFieldsTab = new CTabItem(this.wTabFolder, 0);
        wAdditionalFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalFieldsTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AdditionalFieldsTab.TabTitle", (String[])new String[0]));
        Composite wAdditionalFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wAdditionalFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wAdditionalFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlInclFilenameField = new Label(wAdditionalFieldsComp, 131072);
        wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment(0, 0);
        fdlInclFilenameField.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdlInclFilenameField.right = new FormAttachment(this.middle, -this.margin);
        wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wInclFilenameField);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment(this.middle, 0);
        fdInclFilenameField.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        Label wlInclSheetnameField = new Label(wAdditionalFieldsComp, 131072);
        wlInclSheetnameField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclSheetnameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclSheetnameField);
        FormData fdlInclSheetnameField = new FormData();
        fdlInclSheetnameField.left = new FormAttachment(0, 0);
        fdlInclSheetnameField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdlInclSheetnameField.right = new FormAttachment(this.middle, -this.margin);
        wlInclSheetnameField.setLayoutData((Object)fdlInclSheetnameField);
        this.wInclSheetNameField = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wInclSheetNameField);
        FormData fdInclSheetnameField = new FormData();
        fdInclSheetnameField.left = new FormAttachment(this.middle, 0);
        fdInclSheetnameField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdInclSheetnameField.right = new FormAttachment(100, 0);
        this.wInclSheetNameField.setLayoutData((Object)fdInclSheetnameField);
        Label wlInclSheetRownumField = new Label(wAdditionalFieldsComp, 131072);
        wlInclSheetRownumField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclSheetRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclSheetRownumField);
        FormData fdlInclSheetRownumField = new FormData();
        fdlInclSheetRownumField.left = new FormAttachment(0, 0);
        fdlInclSheetRownumField.top = new FormAttachment((Control)this.wInclSheetNameField, this.margin);
        fdlInclSheetRownumField.right = new FormAttachment(this.middle, -this.margin);
        wlInclSheetRownumField.setLayoutData((Object)fdlInclSheetRownumField);
        this.wInclSheetRowNumField = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wInclSheetRowNumField);
        FormData fdInclSheetRownumField = new FormData();
        fdInclSheetRownumField.left = new FormAttachment(this.middle, 0);
        fdInclSheetRownumField.top = new FormAttachment((Control)this.wInclSheetNameField, this.margin);
        fdInclSheetRownumField.right = new FormAttachment(100, 0);
        this.wInclSheetRowNumField.setLayoutData((Object)fdInclSheetRownumField);
        Label wlInclRownumField = new Label(wAdditionalFieldsComp, 131072);
        wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment(0, 0);
        fdlInclRownumField.top = new FormAttachment((Control)this.wInclSheetRowNumField, this.margin);
        fdlInclRownumField.right = new FormAttachment(this.middle, -this.margin);
        wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRowNumField = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wInclRowNumField);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment(this.middle, 0);
        fdInclRownumField.top = new FormAttachment((Control)this.wInclSheetRowNumField, this.margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRowNumField.setLayoutData((Object)fdInclRownumField);
        Label wlShortFileFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlShortFileFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ShortFileFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShortFileFieldName);
        FormData fdlShortFileFieldName = new FormData();
        fdlShortFileFieldName.left = new FormAttachment(0, 0);
        fdlShortFileFieldName.top = new FormAttachment((Control)this.wInclRowNumField, this.margin);
        fdlShortFileFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlShortFileFieldName.setLayoutData((Object)fdlShortFileFieldName);
        this.wShortFileFieldName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wShortFileFieldName);
        FormData fdShortFileFieldName = new FormData();
        fdShortFileFieldName.left = new FormAttachment(this.middle, 0);
        fdShortFileFieldName.right = new FormAttachment(100, -this.margin);
        fdShortFileFieldName.top = new FormAttachment((Control)this.wInclRowNumField, this.margin);
        this.wShortFileFieldName.setLayoutData((Object)fdShortFileFieldName);
        Label wlExtensionFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlExtensionFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ExtensionFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtensionFieldName);
        FormData fdlExtensionFieldName = new FormData();
        fdlExtensionFieldName.left = new FormAttachment(0, 0);
        fdlExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        fdlExtensionFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlExtensionFieldName.setLayoutData((Object)fdlExtensionFieldName);
        this.wExtensionFieldName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wExtensionFieldName);
        FormData fdExtensionFieldName = new FormData();
        fdExtensionFieldName.left = new FormAttachment(this.middle, 0);
        fdExtensionFieldName.right = new FormAttachment(100, -this.margin);
        fdExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        this.wExtensionFieldName.setLayoutData((Object)fdExtensionFieldName);
        Label wlPathFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlPathFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.PathFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPathFieldName);
        FormData fdlPathFieldName = new FormData();
        fdlPathFieldName.left = new FormAttachment(0, 0);
        fdlPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        fdlPathFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlPathFieldName.setLayoutData((Object)fdlPathFieldName);
        this.wPathFieldName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wPathFieldName);
        FormData fdPathFieldName = new FormData();
        fdPathFieldName.left = new FormAttachment(this.middle, 0);
        fdPathFieldName.right = new FormAttachment(100, -this.margin);
        fdPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        this.wPathFieldName.setLayoutData((Object)fdPathFieldName);
        Label wlSizeFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlSizeFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SizeFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSizeFieldName);
        FormData fdlSizeFieldName = new FormData();
        fdlSizeFieldName.left = new FormAttachment(0, 0);
        fdlSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        fdlSizeFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlSizeFieldName.setLayoutData((Object)fdlSizeFieldName);
        this.wSizeFieldName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wSizeFieldName);
        FormData fdSizeFieldName = new FormData();
        fdSizeFieldName.left = new FormAttachment(this.middle, 0);
        fdSizeFieldName.right = new FormAttachment(100, -this.margin);
        fdSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        this.wSizeFieldName.setLayoutData((Object)fdSizeFieldName);
        Label wlIsHiddenName = new Label(wAdditionalFieldsComp, 131072);
        wlIsHiddenName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IsHiddenName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIsHiddenName);
        FormData fdlIsHiddenName = new FormData();
        fdlIsHiddenName.left = new FormAttachment(0, 0);
        fdlIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        fdlIsHiddenName.right = new FormAttachment(this.middle, -this.margin);
        wlIsHiddenName.setLayoutData((Object)fdlIsHiddenName);
        this.wIsHiddenName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wIsHiddenName);
        FormData fdIsHiddenName = new FormData();
        fdIsHiddenName.left = new FormAttachment(this.middle, 0);
        fdIsHiddenName.right = new FormAttachment(100, -this.margin);
        fdIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        this.wIsHiddenName.setLayoutData((Object)fdIsHiddenName);
        Label wlLastModificationTimeName = new Label(wAdditionalFieldsComp, 131072);
        wlLastModificationTimeName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.LastModificationTimeName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLastModificationTimeName);
        FormData fdlLastModificationTimeName = new FormData();
        fdlLastModificationTimeName.left = new FormAttachment(0, 0);
        fdlLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        fdlLastModificationTimeName.right = new FormAttachment(this.middle, -this.margin);
        wlLastModificationTimeName.setLayoutData((Object)fdlLastModificationTimeName);
        this.wLastModificationTimeName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wLastModificationTimeName);
        FormData fdLastModificationTimeName = new FormData();
        fdLastModificationTimeName.left = new FormAttachment(this.middle, 0);
        fdLastModificationTimeName.right = new FormAttachment(100, -this.margin);
        fdLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        this.wLastModificationTimeName.setLayoutData((Object)fdLastModificationTimeName);
        Label wlUriName = new Label(wAdditionalFieldsComp, 131072);
        wlUriName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUriName);
        FormData fdlUriName = new FormData();
        fdlUriName.left = new FormAttachment(0, 0);
        fdlUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        fdlUriName.right = new FormAttachment(this.middle, -this.margin);
        wlUriName.setLayoutData((Object)fdlUriName);
        this.wUriName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wUriName);
        FormData fdUriName = new FormData();
        fdUriName.left = new FormAttachment(this.middle, 0);
        fdUriName.right = new FormAttachment(100, -this.margin);
        fdUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        this.wUriName.setLayoutData((Object)fdUriName);
        Label wlRootUriName = new Label(wAdditionalFieldsComp, 131072);
        wlRootUriName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.RootUriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRootUriName);
        FormData fdlRootUriName = new FormData();
        fdlRootUriName.left = new FormAttachment(0, 0);
        fdlRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        fdlRootUriName.right = new FormAttachment(this.middle, -this.margin);
        wlRootUriName.setLayoutData((Object)fdlRootUriName);
        this.wRootUriName = new Text(wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wRootUriName);
        FormData fdRootUriName = new FormData();
        fdRootUriName.left = new FormAttachment(this.middle, 0);
        fdRootUriName.right = new FormAttachment(100, -this.margin);
        fdRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        this.wRootUriName.setLayoutData((Object)fdRootUriName);
        FormData fdAdditionalFieldsComp = new FormData();
        fdAdditionalFieldsComp.left = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdAdditionalFieldsComp.right = new FormAttachment(100, 0);
        fdAdditionalFieldsComp.bottom = new FormAttachment(100, 0);
        wAdditionalFieldsComp.setLayoutData((Object)fdAdditionalFieldsComp);
        wAdditionalFieldsComp.layout();
        wAdditionalFieldsTab.setControl((Control)wAdditionalFieldsComp);
    }
}

