/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.googlebigquery;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.i18n.BaseMessages;

@DatabaseMetaPlugin(type="GOOGLEBIGQUERY", typeDescription="Google BigQuery", image="bigquery.svg", documentationUrl="/database/databases/googlebigquery.html")
@GuiPlugin(id="GUI-GoogleBigQueryDatabaseMeta")
public class GoogleBigQueryDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final Class<?> PKG = GoogleBigQueryDatabaseMeta.class;

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getDriverClass() {
        return "com.simba.googlebigquery.jdbc42.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:bigquery://" + hostname + ":" + (StringUtil.isEmpty((String)port) ? "443" : port) + ";" + (String)(StringUtil.isEmpty((String)databaseName) ? "" : "ProjectId=" + databaseName) + ";";
    }

    public String getExtraOptionsHelpText() {
        return "https://cloud.google.com/bigquery/docs/reference/odbc-jdbc-drivers";
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 3: {
                retval = (String)retval + "DATE";
                break;
            }
            case 4: {
                retval = (String)retval + "BOOL";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (type == 5) {
                    retval = (String)retval + "INT64";
                    break;
                }
                if (type == 6) {
                    if (v.getLength() < 39) {
                        retval = (String)retval + "NUMERIC";
                        break;
                    }
                    retval = (String)retval + "BIGNUMERIC";
                    break;
                }
                retval = (String)retval + "FLOAT64";
                break;
            }
            case 2: {
                retval = (String)retval + "STRING";
                break;
            }
            case 8: {
                retval = (String)retval + "BYTES";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
            retval = (String)retval + " NOT NULL";
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return null;
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public boolean isSupportsAutoGeneratedKeys() {
        return false;
    }

    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public String getExtraOptionSeparator() {
        return ";";
    }

    public String getExtraOptionIndicator() {
        return "";
    }

    public String getStartQuote() {
        return "`";
    }

    public String getEndQuote() {
        return "`";
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsViews() {
        return true;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN", "BY", "CASE", "CAST"};
    }

    public boolean supportsStandardTableOutput() {
        return false;
    }

    public String getUnsupportedTableOutputMessage() {
        return BaseMessages.getString(PKG, (String)"GoogleBigQueryDatabaseMeta.UnsupportedTableOutputMessage", (String[])new String[0]);
    }

    public void addDefaultOptions() {
        this.setSupportsBooleanDataType(true);
    }
}

