/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.Trace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.DriverPropertyInfo;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JDProperties
implements Serializable,
Cloneable {
    static final String copyright = "Copyright (C) 1997-2018 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int ACCESS = 0;
    static final int BLOCK_SIZE = 1;
    static final int BLOCK_CRITERIA = 2;
    static final int DATE_FORMAT = 3;
    static final int DATE_SEPARATOR = 4;
    static final int DECIMAL_SEPARATOR = 5;
    static final int ERRORS = 6;
    static final int EXTENDED_DYNAMIC = 7;
    static final int LIBRARIES = 8;
    static final int NAMING = 9;
    static final int PACKAGE = 10;
    static final int PACKAGE_ADD = 11;
    static final int PACKAGE_CACHE = 12;
    static final int PACKAGE_CLEAR = 13;
    static final int PACKAGE_ERROR = 14;
    static final int PACKAGE_LIBRARY = 15;
    static final int PASSWORD = 16;
    static final int PREFETCH = 17;
    static final int PROMPT = 18;
    static final int REMARKS = 19;
    static final int SORT = 20;
    static final int SORT_LANGUAGE = 21;
    static final int SORT_TABLE = 22;
    static final int SORT_WEIGHT = 23;
    static final int TIME_FORMAT = 24;
    static final int TIME_SEPARATOR = 25;
    static final int TRACE = 26;
    static final int TRANSACTION_ISOLATION = 27;
    static final int TRANSLATE_BINARY = 28;
    static final int USER = 29;
    static final int PACKAGE_CRITERIA = 30;
    static final int LOB_THRESHOLD = 31;
    static final int SECURE = 32;
    static final int DATA_TRUNCATION = 33;
    static final int PROXY_SERVER = 34;
    static final int SECONDARY_URL = 35;
    static final int DATA_COMPRESSION = 36;
    static final int BIG_DECIMAL = 37;
    static final int THREAD_USED = 38;
    static final int CURSOR_HOLD = 39;
    static final int LAZY_CLOSE = 40;
    static final int DRIVER = 41;
    static final int BIDI_STRING_TYPE = 42;
    static final int KEY_RING_NAME = 43;
    static final int KEY_RING_PASSWORD = 44;
    static final int FULL_OPEN = 45;
    static final int TRACE_SERVER = 46;
    static final int DATABASE_NAME = 47;
    static final int EXTENDED_METADATA = 48;
    static final int CURSOR_SENSITIVITY = 49;
    static final int BEHAVIOR_OVERRIDE = 50;
    public static final int PACKAGE_CCSID = 51;
    static final int MINIMUM_DIVIDE_SCALE = 52;
    static final int MAXIMUM_PRECISION = 53;
    static final int MAXIMUM_SCALE = 54;
    static final int TRANSLATE_HEX = 55;
    static final int TRACE_TOOLBOX = 56;
    static final int QAQQINILIB = 57;
    static final int LOGIN_TIMEOUT = 58;
    static final int TRUE_AUTO_COMMIT = 59;
    static final int BIDI_IMPLICIT_REORDERING = 60;
    static final int BIDI_NUMERIC_ORDERING = 61;
    static final int HOLD_LOCATORS = 62;
    static final int HOLD_STATEMENTS = 63;
    static final int ROLLBACK_CURSOR_HOLD = 64;
    static final int VARIABLE_FIELD_COMPRESSION = 65;
    static final int QUERY_OPTIMIZE_GOAL = 66;
    static final int KEEP_ALIVE = 67;
    static final int RECEIVE_BUFFER_SIZE = 68;
    static final int SEND_BUFFER_SIZE = 69;
    static final int XA_LOOSELY_COUPLED_SUPPORT = 70;
    static final int TRANSLATE_BOOLEAN = 71;
    static final int METADATA_SOURCE = 72;
    static final int QUERY_STORAGE_LIMIT = 73;
    static final int DECFLOAT_ROUNDING_MODE = 74;
    static final int AUTOCOMMIT_EXCEPTION = 75;
    static final int AUTO_COMMIT = 76;
    static final int IGNORE_WARNINGS = 77;
    static final int SECURE_CURRENT_USER = 78;
    static final int CONCURRENT_ACCESS_RESOLUTION = 79;
    static final int JVM16_SYNCHRONIZE = 80;
    static final int SOCKET_TIMEOUT = 81;
    static final int USE_BLOCK_UPDATE = 82;
    static final int MAXIMUM_BLOCKED_INPUT_ROWS = 83;
    static final int QUERY_TIMEOUT_MECHANISM = 84;
    static final int DESCRIBE_OPTION = 85;
    static final int DECIMAL_DATA_ERRORS = 86;
    static final int TIMESTAMP_FORMAT = 87;
    static final int USE_DRDA_METADATA_VERSION = 88;
    static final int QUERY_REPLACE_TRUNCATED_PARAMETER = 89;
    static final int NUMERIC_RANGE_ERROR = 90;
    static final int CHARACTER_TRUNCATION = 91;
    static final int PORTNUMBER = 92;
    static final int ENABLE_CLIENT_AFFINITIES_LIST = 93;
    static final int CLIENT_REROUTE_ALTERNATE_SERVER_NAME = 94;
    static final int CLIENT_REROUTE_ALTERNATE_PORT_NUMBER = 95;
    static final int MAX_RETRIES_FOR_CLIENT_REROUTE = 96;
    static final int RETRY_INTERVAL_FOR_CLIENT_REROUTE = 97;
    static final int ENABLE_SEAMLESS_FAILOVER = 98;
    static final int AFFINITY_FAILBACK_INTERVAL = 99;
    static final int TCP_NO_DELAY = 100;
    static final int ADDITIONAL_AUTHENTICATION_FACTOR = 101;
    static final int STAY_ALIVE = 102;
    static final int TLS_TRUSTSTORE = 103;
    static final int TLS_TRUSTSTORE_PASSWORD = 104;
    private static final int NUMBER_OF_ATTRIBUTES_ = 105;
    static final String ACCESS_ = "access";
    static final String AFFINITY_FAILBACK_INTERVAL_ = "affinityFailbackInterval";
    static final String ADDITIONAL_AUTHENTICATION_FACTOR_ = "additionalAuthenticationFactor";
    static final String BEHAVIOR_OVERRIDE_ = "behavior override";
    static final String BIDI_STRING_TYPE_ = "bidi string type";
    static final String BIG_DECIMAL_ = "big decimal";
    static final String BLOCK_SIZE_ = "block size";
    static final String BLOCK_CRITERIA_ = "block criteria";
    static final String CHARACTER_TRUNCATION_ = "character truncation";
    static final String CLIENT_REROUTE_ALTERNATE_PORT_NUMBER_ = "clientRerouteAlternatePortNumber";
    static final String CLIENT_REROUTE_ALTERNATE_SERVER_NAME_ = "clientRerouteAlternateServerName";
    static final String CURSOR_HOLD_ = "cursor hold";
    static final String CURSORHOLD_ = "CURSORHOLD";
    static final String CURSOR_SENSITIVITY_ = "cursor sensitivity";
    static final String DATA_COMPRESSION_ = "data compression";
    static final String DATA_TRUNCATION_ = "data truncation";
    static final String DATABASE_NAME_ = "database name";
    static final String DATE_FORMAT_ = "date format";
    static final String DATE_SEPARATOR_ = "date separator";
    static final String DECIMAL_SEPARATOR_ = "decimal separator";
    static final String DRIVER_ = "driver";
    static final String ENABLE_CLIENT_AFFINITIES_LIST_ = "enableClientAffinitiesList";
    static final String ENABLE_SEAMLESS_FAILOVER_ = "enableSeamlessFailover";
    static final String ERRORS_ = "errors";
    static final String EXTENDED_DYNAMIC_ = "extended dynamic";
    static final String EXTENDED_METADATA_ = "extended metadata";
    static final String FULL_OPEN_ = "full open";
    static final String HOLD_LOCATORS_ = "hold input locators";
    static final String LAZY_CLOSE_ = "lazy close";
    static final String LIBRARIES_ = "libraries";
    static final String LOB_THRESHOLD_ = "lob threshold";
    static final String MAX_RETRIES_FOR_CLIENT_REROUTE_ = "maxRetriesForClientReroute";
    static final String MAXIMUM_PRECISION_ = "maximum precision";
    static final String MAXIMUM_SCALE_ = "maximum scale";
    static final String MINIMUM_DIVIDE_SCALE_ = "minimum divide scale";
    static final String NAMING_ = "naming";
    static final String NUMERIC_RANGE_ERROR_ = "numeric range error";
    static final String PACKAGE_ = "package";
    static final String PACKAGE_ADD_ = "package add";
    static final String PACKAGE_CACHE_ = "package cache";
    static final String PACKAGE_CCSID_ = "package ccsid";
    static final String PACKAGE_CLEAR_ = "package clear";
    static final String PACKAGE_CRITERIA_ = "package criteria";
    static final String PACKAGE_ERROR_ = "package error";
    static final String PACKAGE_LIBRARY_ = "package library";
    static final String PASSWORD_ = "password";
    static final String PORTNUMBER_ = "portNumber";
    static final String PREFETCH_ = "prefetch";
    static final String PROMPT_ = "prompt";
    static final String PROXY_SERVER_ = "proxy server";
    static final String QUERY_REPLACE_TRUNCATED_PARAMETER_ = "query replace truncated parameter";
    static final String QUERY_TIMEOUT_MECHANISM_ = "query timeout mechanism";
    static final String REMARKS_ = "remarks";
    static final String RETRY_INTERVAL_FOR_CLIENT_REROUTE_ = "retryIntervalForClientReroute";
    static final String SECONDARY_URL_ = "secondary URL";
    static final String SECURE_ = "secure";
    static final String SORT_ = "sort";
    static final String SORT_LANGUAGE_ = "sort language";
    static final String SORT_TABLE_ = "sort table";
    static final String SORT_WEIGHT_ = "sort weight";
    static final String STAY_ALIVE_ = "stay alive";
    static final String TCP_NO_DELAY_ = "tcp no delay";
    static final String THREAD_USED_ = "thread used";
    static final String TIME_FORMAT_ = "time format";
    static final String TIMESTAMP_FORMAT_ = "timestamp format";
    static final String TIME_SEPARATOR_ = "time separator";
    static final String TLS_TRUSTSTORE_ = "tls truststore";
    static final String TLS_TRUSTSTORE_PASSWORD_ = "tls truststore password";
    static final String TRACE_ = "trace";
    static final String TRACE_SERVER_ = "server trace";
    static final String TRACE_TOOLBOX_ = "toolbox trace";
    static final String TRANSACTION_ISOLATION_ = "transaction isolation";
    static final String TRANSLATE_BINARY_ = "translate binary";
    static final String TRANSLATE_HEX_ = "translate hex";
    static final String USER_ = "user";
    static final String USE_DRDA_METADATA_VERSION_ = "use drda metadata version";
    static final String QAQQINILIB_ = "qaqqinilib";
    static final String LOGIN_TIMEOUT_ = "login timeout";
    static final String TRUE_AUTO_COMMIT_ = "true autocommit";
    static final String BIDI_IMPLICIT_REORDERING_ = "bidi implicit reordering";
    static final String BIDI_NUMERIC_ORDERING_ = "bidi numeric ordering";
    static final String HOLD_STATEMENTS_ = "hold statements";
    static final String ROLLBACK_CURSOR_HOLD_ = "rollback cursor hold";
    static final String VARIABLE_FIELD_COMPRESSION_ = "variable field compression";
    static final String QUERY_OPTIMIZE_GOAL_ = "query optimize goal";
    static final String KEEP_ALIVE_ = "keep alive";
    static final String RECEIVE_BUFFER_SIZE_ = "receive buffer size";
    static final String SEND_BUFFER_SIZE_ = "send buffer size";
    static final String XA_LOOSELY_COUPLED_SUPPORT_ = "XA loosely coupled support";
    static final String TRANSLATE_BOOLEAN_ = "translate boolean";
    static final String METADATA_SOURCE_ = "metadata source";
    static final String QUERY_STORAGE_LIMIT_ = "query storage limit";
    static final String DECFLOAT_ROUNDING_MODE_ = "decfloat rounding mode";
    static final String AUTOCOMMIT_EXCEPTION_ = "autocommit exception";
    static final String AUTO_COMMIT_ = "auto commit";
    static final String IGNORE_WARNINGS_ = "ignore warnings";
    static final String SECURE_CURRENT_USER_ = "secure current user";
    static final String CONCURRENT_ACCESS_RESOLUTION_ = "concurrent access resolution";
    static final String JVM16_SYNCHRONIZE_ = "jvm16 synchronize";
    static final String SOCKET_TIMEOUT_ = "socket timeout";
    static final String USE_BLOCK_UPDATE_ = "use block update";
    static final String MAXIMUM_BLOCKED_INPUT_ROWS_ = "maximum blocked input rows";
    static final String DESCRIBE_OPTION_ = "describe option";
    static final String DECIMAL_DATA_ERRORS_ = "decimal data errors";
    static final String COMMA_ = ",";
    static final String EMPTY_ = "";
    private static final String EUR_ = "eur";
    private static final String FALSE_ = "false";
    private static final String ISO_ = "iso";
    private static final String JIS_ = "jis";
    private static final String NONE_ = "none";
    private static final String PERIOD_ = ".";
    private static final String SPACE_ = "b";
    private static final String SQL_ = "sql";
    private static final String SYSTEM_ = "system";
    private static final String TRUE_ = "true";
    private static final String USA_ = "usa";
    static final String ACCESS_ALL = "all";
    static final String ACCESS_READ_CALL = "read call";
    static final String ACCESS_READ_ONLY = "read only";
    static final String BLOCK_CRITERIA_NONE = "0";
    static final String BLOCK_CRITERIA_IF_FETCH = "1";
    static final String BLOCK_CRITERIA_UNLESS_UPDATE = "2";
    static final String BLOCK_SIZE_0 = "0";
    static final String BLOCK_SIZE_8 = "8";
    static final String BLOCK_SIZE_16 = "16";
    static final String BLOCK_SIZE_32 = "32";
    static final String BLOCK_SIZE_64 = "64";
    static final String BLOCK_SIZE_128 = "128";
    static final String BLOCK_SIZE_256 = "256";
    static final String BLOCK_SIZE_512 = "512";
    static final int BLOCK_SIZE_512_INT = 512;
    static final int BLOCK_SIZE_MAX_INT = 16000;
    static final String CURSOR_SENSITIVITY_ASENSITIVE = "asensitive";
    static final String CURSOR_SENSITIVITY_INSENSITIVE = "insensitive";
    static final String CURSOR_SENSITIVITY_SENSITIVE = "sensitive";
    static final String DATE_FORMAT_JULIAN = "julian";
    static final String DATE_FORMAT_MDY = "mdy";
    static final String DATE_FORMAT_DMY = "dmy";
    static final String DATE_FORMAT_YMD = "ymd";
    static final String DATE_FORMAT_USA = "usa";
    static final String DATE_FORMAT_ISO = "iso";
    static final String DATE_FORMAT_EUR = "eur";
    static final String DATE_FORMAT_JIS = "jis";
    static final String DATE_FORMAT_NOTSET = "";
    static final String DATE_SEPARATOR_SLASH = "/";
    static final String DATE_SEPARATOR_DASH = "-";
    static final String DATE_SEPARATOR_PERIOD = ".";
    static final String DATE_SEPARATOR_COMMA = ",";
    static final String DATE_SEPARATOR_SPACE = "b";
    static final String DATE_SEPARATOR_NOTSET = "";
    static final String DECIMAL_SEPARATOR_COMMA = ",";
    static final String DECIMAL_SEPARATOR_PERIOD = ".";
    static final String DECIMAL_SEPARATOR_NOTSET = "";
    static final String DRIVER_NATIVE = "native";
    static final String DRIVER_TOOLBOX = "toolbox";
    static final String ERRORS_BASIC = "basic";
    static final String ERRORS_FULL = "full";
    static final String NAMING_SQL = "sql";
    static final String NAMING_SYSTEM = "system";
    static final String PACKAGE_ERROR_EXCEPTION = "exception";
    static final String PACKAGE_ERROR_NONE = "none";
    static final String PACKAGE_ERROR_WARNING = "warning";
    static final String REMARKS_SQL = "sql";
    static final String REMARKS_SYSTEM = "system";
    static final String SORT_HEX = "hex";
    static final String SORT_LANGUAGE1 = "language";
    static final String SORT_TABLE1 = "table";
    static final String SORT_LANGUAGE_ENGLISH_UNITED_STATES = "ENU";
    static final String SORT_WEIGHT_SHARED = "shared";
    static final String SORT_WEIGHT_UNIQUE = "unique";
    static final String TIME_FORMAT_HMS = "hms";
    static final String TIME_FORMAT_USA = "usa";
    static final String TIME_FORMAT_ISO = "iso";
    static final String TIME_FORMAT_EUR = "eur";
    static final String TIME_FORMAT_JIS = "jis";
    static final String TIME_FORMAT_NOTSET = "";
    static final String TIME_SEPARATOR_COLON = ":";
    static final String TIME_SEPARATOR_PERIOD = ".";
    static final String TIME_SEPARATOR_COMMA = ",";
    static final String TIME_SEPARATOR_SPACE = "b";
    static final String TIME_SEPARATOR_NOTSET = "";
    static final String TIMESTAMP_FORMAT_ISO = "iso";
    static final String TIMESTAMP_FORMAT_IBMSQL = "ibmsql";
    static final String TRANSACTION_ISOLATION_NONE = "none";
    static final String TRANSACTION_ISOLATION_READ_COMMITTED = "read committed";
    static final String TRANSACTION_ISOLATION_READ_UNCOMMITTED = "read uncommitted";
    static final String TRANSACTION_ISOLATION_REPEATABLE_READ = "repeatable read";
    static final String TRANSACTION_ISOLATION_SERIALIZABLE = "serializable";
    static final String PACKAGE_CRITERIA_DEFAULT = "default";
    static final String PACKAGE_CRITERIA_SELECT = "select";
    static final String CURSORHOLD_FALSE = "FALSE";
    static final String CURSORHOLD_TRUE = "TRUE";
    private static final String CURSORHOLD_NO = "0";
    private static final String CURSORHOLD_YES = "1";
    static final String TRACE_SET_ON = "TRUE";
    static final String TRACE_SET_OFF = "FALSE";
    static final String TRACE_NOT_SPECIFIED = "NOT SPECIFIED";
    static final String NOT_SPECIFIED = "";
    static final String BIDI_STRING_TYPE_NOTSET = "";
    static final String BIDI_STRING_TYPE_DEFAULT = "0";
    static final String BIDI_STRING_TYPE_ST4 = "4";
    static final String BIDI_STRING_TYPE_ST5 = "5";
    static final String BIDI_STRING_TYPE_ST6 = "6";
    static final String BIDI_STRING_TYPE_ST7 = "7";
    static final String BIDI_STRING_TYPE_ST8 = "8";
    static final String BIDI_STRING_TYPE_ST9 = "9";
    static final String BIDI_STRING_TYPE_ST10 = "10";
    static final String BIDI_STRING_TYPE_ST11 = "11";
    static final String BIDI_STRING_TYPE_NONE = "-1";
    static final String PACKAGE_CCSID_UCS2 = "13488";
    static final String PACKAGE_CCSID_UTF16 = "1200";
    static final String MINIMUM_DIVIDE_SCALE_0 = "0";
    static final String MINIMUM_DIVIDE_SCALE_1 = "1";
    static final String MINIMUM_DIVIDE_SCALE_2 = "2";
    static final String MINIMUM_DIVIDE_SCALE_3 = "3";
    static final String MINIMUM_DIVIDE_SCALE_4 = "4";
    static final String MINIMUM_DIVIDE_SCALE_5 = "5";
    static final String MINIMUM_DIVIDE_SCALE_6 = "6";
    static final String MINIMUM_DIVIDE_SCALE_7 = "7";
    static final String MINIMUM_DIVIDE_SCALE_8 = "8";
    static final String MINIMUM_DIVIDE_SCALE_9 = "9";
    static final String MAXIMUM_PRECISION_31 = "31";
    static final String MAXIMUM_PRECISION_63 = "63";
    static final String MAXIMUM_SCALE_0 = "0";
    static final String MAXIMUM_SCALE_31 = "31";
    static final String MAXIMUM_SCALE_63 = "63";
    static final String TRANSLATE_HEX_BINARY = "binary";
    static final String TRANSLATE_HEX_CHARACTER = "character";
    static final String TRACE_TOOLBOX_DATASTREAM = "datastream";
    static final String TRACE_TOOLBOX_DIAGNOSTIC = "diagnostic";
    static final String TRACE_TOOLBOX_ERROR = "error";
    static final String TRACE_TOOLBOX_INFORMATION = "information";
    static final String TRACE_TOOLBOX_WARNING = "warning";
    static final String TRACE_TOOLBOX_CONVERSION = "conversion";
    static final String TRACE_TOOLBOX_PROXY = "proxy";
    static final String TRACE_TOOLBOX_PCML = "pcml";
    static final String TRACE_TOOLBOX_JDBC = "jdbc";
    static final String TRACE_TOOLBOX_ALL = "all";
    static final String TRACE_TOOLBOX_THREAD = "thread";
    static final String TRACE_TOOLBOX_NONE = "none";
    static final String TRACE_TOOLBOX_NOT_SET = "";
    static final String VARIABLE_FIELD_COMPRESSION_INSERT = "insert";
    static final String VARIABLE_FIELD_COMPRESSION_ALL = "all";
    static final String QUERY_OPTIMIZE_GOAL_DEFAULT = "0";
    static final String QUERY_OPTIMIZE_GOAL_FIRSTIO = "1";
    static final String QUERY_OPTIMIZE_GOAL_ALLIO = "2";
    static final String XA_LOOSELY_COUPLED_SUPPORT_NOT_SHARED = "0";
    static final String XA_LOOSELY_COUPLED_SUPPORT_SHARED = "1";
    static final String METADATA_SOURCE_ROI = "0";
    static final String METADATA_SOURCE_STORED_PROCEDURE = "1";
    static final String METADATA_SOURCE_HOST_VERSION_DEFAULT = "-1";
    static final String QUERY_STORAGE_LIMIT_NOMAX = "-1";
    static final String DECFLOAT_ROUNDING_MODE_HALF_EVEN = "half even";
    static final String DECFLOAT_ROUNDING_MODE_HALF_UP = "half up";
    static final String DECFLOAT_ROUNDING_MODE_DOWN = "down";
    static final String DECFLOAT_ROUNDING_MODE_CEILING = "ceiling";
    static final String DECFLOAT_ROUNDING_MODE_FLOOR = "floor";
    static final String DECFLOAT_ROUNDING_MODE_HALF_DOWN = "half down";
    static final String DECFLOAT_ROUNDING_MODE_UP = "up";
    static final String CONCURRENTACCESS_NOT_SET = "0";
    static final String CONCURRENTACCESS_USE_CURRENTLY_COMMITTED = "1";
    static final String CONCURRENTACCESS_WAIT_FOR_OUTCOME = "2";
    static final String CONCURRENTACCESS_SKIP_LOCKS = "3";
    static final String QUERY_TIMEOUT_MECHANISM_CANCEL = "cancel";
    static final String QUERY_TIMEOUT_MECHANISM_QQRYTIMLMT = "qqrytimlmt";
    static final String DESCRIBE_OPTION_SYSTEM_NAMES = "system names";
    static final String DESCRIBE_OPTION_LONG_NAMES = "long names";
    static final String DESCRIBE_OPTION_LABELS = "labels";
    static final String DECIMAL_DATA_ERRORS_IGNORE = "ignore";
    static final String DECIMAL_DATA_ERRORS_REPORT = "report";
    static final String DECIMAL_DATA_ERRORS_IGNORE_NULL = "ignore null";
    static final String DECIMAL_DATA_ERRORS_REPORT_NULL = "report null";
    public static final Object QUERY_REPLACE_TRUNCATED_PARAMETER_STRING_DEFAULT = "";
    public static final String NUMERIC_RANGE_ERROR_DEFAULT = "default";
    public static final String NUMERIC_RANGE_ERROR_WARNING = "warning";
    public static final String NUMERIC_RANGE_ERROR_NONE = "none";
    public static final String CHARACTER_TRUNCATION_DEFAULT = "default";
    public static final String CHARACTER_TRUNCATION_WARNING = "warning";
    public static final String CHARACTER_TRUNCATION_NONE = "none";
    private static DriverPropertyInfo[] dpi_ = new DriverPropertyInfo[105];
    private static String[] defaults_ = new String[105];
    private boolean extra_;
    private String[] values_;
    private Properties info_;
    private char[] additionalAuthenticationFactor_;
    private PasswordVault passwordVault_;

    JDProperties() {
        this(null, null, null, null);
    }

    JDProperties(Properties urlProperties, Properties info, char[] password, char[] additionalAuthenticationFactor) {
        String propertyName;
        String aaf;
        this.info_ = info;
        if (password == null) {
            String passwordString = JDProperties.getProperty(urlProperties, info, PASSWORD_);
            if (passwordString != null) {
                char[] passwordChars = passwordString.toCharArray();
                this.passwordVault_ = new PasswordVault(passwordChars);
                CredentialVault.clearArray(passwordChars);
            } else {
                this.passwordVault_ = null;
            }
        } else {
            this.passwordVault_ = new PasswordVault(password);
        }
        if (additionalAuthenticationFactor == null && (aaf = JDProperties.getProperty(urlProperties, info, ADDITIONAL_AUTHENTICATION_FACTOR_)) != null) {
            additionalAuthenticationFactor = aaf.toCharArray();
        }
        this.additionalAuthenticationFactor_ = additionalAuthenticationFactor;
        this.values_ = new String[105];
        for (int i = 0; i < 105; ++i) {
            if (i == 16) continue;
            String supportedProperty = JDProperties.dpi_[i].name;
            String propertyValue = JDProperties.getProperty(urlProperties, info, supportedProperty);
            this.setString(i, propertyValue);
        }
        this.extra_ = false;
        if (urlProperties != null) {
            Enumeration<?> propertyNames = urlProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                propertyName = (String)propertyNames.nextElement();
                if (propertyName.length() <= 0) continue;
                boolean found = false;
                for (int j = 0; j < 105 && !found; ++j) {
                    if (!propertyName.equalsIgnoreCase(JDProperties.dpi_[j].name)) continue;
                    found = true;
                }
                if (found) continue;
                if (propertyName.equalsIgnoreCase(CURSORHOLD_)) {
                    String value = JDProperties.getProperty(urlProperties, info, CURSORHOLD_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, propertyName + ": " + value);
                    }
                    if (value.equalsIgnoreCase("1")) {
                        this.setString(39, TRUE_);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("0")) continue;
                    this.setString(39, FALSE_);
                    continue;
                }
                this.extra_ = true;
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Extra property: \"" + propertyName + "\"");
            }
        }
        if (info != null) {
            Enumeration<?> propertyNames = info.propertyNames();
            while (propertyNames.hasMoreElements()) {
                propertyName = (String)propertyNames.nextElement();
                if (propertyName.length() <= 0) continue;
                boolean found = false;
                for (int j = 0; j < 105 && !found; ++j) {
                    if (!propertyName.equalsIgnoreCase(JDProperties.dpi_[j].name)) continue;
                    found = true;
                }
                if (found) continue;
                if (propertyName.equalsIgnoreCase(CURSORHOLD_)) {
                    String value = JDProperties.getProperty(urlProperties, info, CURSORHOLD_);
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, propertyName + ": " + value);
                    }
                    if (value.equalsIgnoreCase("1")) {
                        this.setString(39, TRUE_);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("0")) continue;
                    this.setString(39, FALSE_);
                    continue;
                }
                this.extra_ = true;
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Extra property: \"" + propertyName + "\"");
            }
        }
    }

    public Object clone() {
        try {
            JDProperties clone = (JDProperties)super.clone();
            clone.values_ = (String[])this.values_.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, e);
            throw new UnsupportedOperationException("clone()");
        }
    }

    boolean equals(int index, String value) {
        return this.getString(index).equalsIgnoreCase(value);
    }

    DriverPropertyInfo[] getInfo() {
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[105];
        for (int i = 0; i < 105; ++i) {
            dpi[i] = i != 16 && i != 44 ? new DriverPropertyInfo(JDProperties.dpi_[i].name, this.values_[i]) : new DriverPropertyInfo(JDProperties.dpi_[i].name, "");
            dpi[i].required = JDProperties.dpi_[i].required;
            dpi[i].choices = new String[JDProperties.dpi_[i].choices.length];
            for (int j = 0; j < JDProperties.dpi_[i].choices.length; ++j) {
                dpi[i].choices[j] = JDProperties.dpi_[i].choices[j];
            }
            dpi[i].description = AS400JDBCDriver.getResource(JDProperties.dpi_[i].description, null);
        }
        return dpi;
    }

    boolean getBoolean(int index) {
        return Boolean.valueOf(this.values_[index]);
    }

    int getIndex(int index) {
        for (int i = 0; i < JDProperties.dpi_[index].choices.length; ++i) {
            if (!this.values_[index].equalsIgnoreCase(JDProperties.dpi_[index].choices[i])) continue;
            return i;
        }
        return -1;
    }

    public int getInt(int index) {
        try {
            return Integer.parseInt(this.values_[index]);
        }
        catch (NumberFormatException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "NumberFormatException processing propertyIndex[" + index + "]='" + this.values_[index] + "'");
            }
            return 0;
        }
    }

    Properties getOriginalInfo() {
        return this.info_;
    }

    static int getPropertyIndex(String propertyName) {
        for (int i = 0; i < 105; ++i) {
            if (!propertyName.equals(JDProperties.dpi_[i].name)) continue;
            return i;
        }
        return -1;
    }

    private static String getProperty(Properties urlProperties, Properties info, String propertyName) {
        String value = null;
        if (urlProperties != null) {
            value = urlProperties.getProperty(propertyName);
        }
        if (value == null && info != null) {
            value = info.getProperty(propertyName);
        }
        return value;
    }

    String getString(int index) {
        if (index == 16) {
            throw new InternalError("PASSWORD not VALID");
        }
        String value = this.values_[index];
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    SSLSocketFactory getCustomSSLSocketFactory() {
        Object sslSocketFactoryObject;
        Properties originalProps = this.getOriginalInfo();
        Object object = sslSocketFactoryObject = null == originalProps ? null : originalProps.get("property.ssl-socket-factory");
        if (sslSocketFactoryObject != null && sslSocketFactoryObject instanceof SSLSocketFactory) {
            return (SSLSocketFactory)sslSocketFactoryObject;
        }
        final String truststoreFile = this.getString(103);
        final String truststorePass = this.getString(104);
        if (null != truststoreFile && !truststoreFile.isEmpty()) {
            return new SSLSocketFactory(){
                private SSLSocketFactory sslSocketFactory_ = null;

                private synchronized SSLSocketFactory getSSLSocketFactory() throws IOException {
                    SSLSocketFactory sSLSocketFactory;
                    if (null != this.sslSocketFactory_) {
                        return this.sslSocketFactory_;
                    }
                    if ("*ANY".equalsIgnoreCase(truststoreFile) && "*ANY".equalsIgnoreCase(truststorePass)) {
                        try {
                            SSLContext ctx = SSLContext.getInstance("TLS");
                            ctx.init(null, new TrustManager[]{new X509TrustManager(){

                                @Override
                                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                }

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return new X509Certificate[0];
                                }
                            }}, null);
                            this.sslSocketFactory_ = ctx.getSocketFactory();
                            return this.sslSocketFactory_;
                        }
                        catch (Exception e) {
                            throw e instanceof IOException ? (IOException)e : new IOException(e);
                        }
                    }
                    FileInputStream trustFile = new FileInputStream(truststoreFile);
                    try {
                        KeyManager[] keyManagers = null;
                        TrustManager[] trustManagers = null;
                        SSLContext ctx = SSLContext.getInstance("TLS");
                        KeyStore myKeyStore = KeyStore.getInstance("JKS");
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        if (truststorePass == null || truststorePass.length() == 0) {
                            myKeyStore.load(trustFile, null);
                            KeyManagerFactory keyManagerFactory = null;
                            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                            keyManagerFactory.init(myKeyStore, new char[0]);
                            keyManagers = keyManagerFactory.getKeyManagers();
                        } else {
                            myKeyStore.load(trustFile, truststorePass.toCharArray());
                        }
                        trustManagerFactory.init(myKeyStore);
                        trustManagers = trustManagerFactory.getTrustManagers();
                        ctx.init(keyManagers, trustManagers, null);
                        sSLSocketFactory = this.sslSocketFactory_ = ctx.getSocketFactory();
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                trustFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw e instanceof IOException ? (IOException)e : new IOException(e);
                        }
                    }
                    trustFile.close();
                    return sSLSocketFactory;
                }

                @Override
                public String[] getDefaultCipherSuites() {
                    try {
                        return this.getSSLSocketFactory().getDefaultCipherSuites();
                    }
                    catch (Exception exception) {
                        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
                    }
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    try {
                        return this.getSSLSocketFactory().getSupportedCipherSuites();
                    }
                    catch (Exception exception) {
                        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
                    }
                }

                @Override
                public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                    return this.getSSLSocketFactory().createSocket(s, host, port, autoClose);
                }

                @Override
                public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                    return this.getSSLSocketFactory().createSocket(host, port);
                }

                @Override
                public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                    return this.getSSLSocketFactory().createSocket(host, port, localHost, localPort);
                }

                @Override
                public Socket createSocket(InetAddress host, int port) throws IOException {
                    return this.getSSLSocketFactory().createSocket(host, port);
                }

                @Override
                public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                    return this.getSSLSocketFactory().createSocket(address, port, localAddress, localPort);
                }
            };
        }
        return null;
    }

    char[] getClearPassword() {
        if (this.passwordVault_ == null) {
            return null;
        }
        byte[] clearBytes = this.passwordVault_.getClearCredential();
        char[] clearPassword = BinaryConverter.byteArrayToCharArray(clearBytes);
        CredentialVault.clearArray(clearBytes);
        return clearPassword;
    }

    boolean isExtraPropertySpecified() {
        return this.extra_;
    }

    static String isTraceSet(Properties urlProperties, Properties info) {
        if (JDProperties.getProperty(urlProperties, info, TRACE_) == null) {
            return TRACE_NOT_SPECIFIED;
        }
        if (Boolean.valueOf(JDProperties.getProperty(urlProperties, info, TRACE_)).booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    static String isToolboxTraceSet(Properties urlProperties, Properties info) {
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_) == null) {
            return "";
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_DATASTREAM)) {
            return TRACE_TOOLBOX_DATASTREAM;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_DIAGNOSTIC)) {
            return TRACE_TOOLBOX_DIAGNOSTIC;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_ERROR)) {
            return TRACE_TOOLBOX_ERROR;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_INFORMATION)) {
            return TRACE_TOOLBOX_INFORMATION;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase("warning")) {
            return "warning";
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_CONVERSION)) {
            return TRACE_TOOLBOX_CONVERSION;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_PROXY)) {
            return TRACE_TOOLBOX_PROXY;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_PCML)) {
            return TRACE_TOOLBOX_PCML;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_JDBC)) {
            return TRACE_TOOLBOX_JDBC;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase("all")) {
            return "all";
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase(TRACE_TOOLBOX_THREAD)) {
            return TRACE_TOOLBOX_THREAD;
        }
        if (JDProperties.getProperty(urlProperties, info, TRACE_TOOLBOX_).equalsIgnoreCase("none")) {
            return "none";
        }
        return "";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.values_.length < 105) {
            String[] temp = new String[105];
            System.arraycopy(this.values_, 0, temp, 0, this.values_.length);
            System.arraycopy(defaults_, this.values_.length, temp, this.values_.length, 105 - this.values_.length);
            this.values_ = temp;
        }
    }

    void setString(int index, String value) {
        this.values_[index] = index != 29 && index != 16 && (value == null || value.length() == 0) ? defaults_[index] : value;
        if (index == 51 || index == 92 || index == 96 || index == 97 || index == 99) {
            try {
                int sendCCSIDInt = Integer.valueOf(value);
                if (sendCCSIDInt > 0) {
                    this.values_[index] = value;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logProperty((Object)this, "setString", JDProperties.dpi_[index].name, value);
                }
                return;
            }
            catch (NumberFormatException sendCCSIDInt) {
                // empty catch block
            }
        }
        if (JDProperties.dpi_[index].choices.length > 0) {
            boolean valid = false;
            for (int i = 0; i < JDProperties.dpi_[index].choices.length; ++i) {
                if (!this.values_[index].equalsIgnoreCase(JDProperties.dpi_[index].choices[i])) continue;
                valid = true;
                break;
            }
            if (!valid && index == 1) {
                try {
                    int blockSize = Integer.parseInt(this.values_[index]);
                    if (blockSize > 512 && blockSize <= 16000) {
                        valid = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    valid = false;
                }
            }
            if (!valid) {
                this.values_[index] = defaults_[index];
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setString", JDProperties.dpi_[index].name, index != 16 && index != 44 ? this.values_[index] : "");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values_.length; ++i) {
            String value = this.values_[i];
            if (value == null || value.equals(defaults_[i])) continue;
            sb.append(JDProperties.dpi_[i].name);
            sb.append("=");
            if (PASSWORD_.equals(JDProperties.dpi_[i].name)) {
                value = "*********";
            }
            sb.append(value);
            sb.append(";");
        }
        return sb.toString();
    }

    public char[] getAdditionalAuthenticationFactor() {
        return this.additionalAuthenticationFactor_;
    }

    public void setAdditionalAuthenticationFactor(char[] additionalAuthenticationFactor) {
        this.additionalAuthenticationFactor_ = additionalAuthenticationFactor;
    }

    static {
        int i = 0;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ACCESS_, "");
        JDProperties.dpi_[i].description = "ACCESS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "all";
        JDProperties.dpi_[i].choices[1] = ACCESS_READ_CALL;
        JDProperties.dpi_[i].choices[2] = ACCESS_READ_ONLY;
        JDProperties.defaults_[i] = "all";
        i = 99;
        JDProperties.dpi_[i] = new DriverPropertyInfo(AFFINITY_FAILBACK_INTERVAL_, "");
        JDProperties.dpi_[i].description = "AFFINITY_FAILBACK_INTERVAL_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "0";
        i = 50;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BEHAVIOR_OVERRIDE_, "");
        JDProperties.dpi_[i].description = "BEHAVIOR_OVERRIDE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "0";
        i = 42;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BIDI_STRING_TYPE_, "");
        JDProperties.dpi_[i].description = "BIDI_STRING_TYPE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[11];
        JDProperties.dpi_[i].choices[0] = "";
        JDProperties.dpi_[i].choices[1] = "0";
        JDProperties.dpi_[i].choices[2] = "4";
        JDProperties.dpi_[i].choices[3] = "5";
        JDProperties.dpi_[i].choices[4] = "6";
        JDProperties.dpi_[i].choices[5] = "7";
        JDProperties.dpi_[i].choices[6] = "8";
        JDProperties.dpi_[i].choices[7] = "9";
        JDProperties.dpi_[i].choices[8] = BIDI_STRING_TYPE_ST10;
        JDProperties.dpi_[i].choices[9] = BIDI_STRING_TYPE_ST11;
        JDProperties.dpi_[i].choices[10] = "-1";
        JDProperties.defaults_[i] = "5";
        i = 37;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BIG_DECIMAL_, "");
        JDProperties.dpi_[i].description = "BIG_DECIMAL_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 2;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BLOCK_CRITERIA_, "");
        JDProperties.dpi_[i].description = "BLOCK_CRITERIA_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "2";
        JDProperties.defaults_[i] = "2";
        i = 1;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BLOCK_SIZE_, "");
        JDProperties.dpi_[i].description = "BLOCK_SIZE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[8];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "8";
        JDProperties.dpi_[i].choices[2] = BLOCK_SIZE_16;
        JDProperties.dpi_[i].choices[3] = BLOCK_SIZE_32;
        JDProperties.dpi_[i].choices[4] = BLOCK_SIZE_64;
        JDProperties.dpi_[i].choices[5] = BLOCK_SIZE_128;
        JDProperties.dpi_[i].choices[6] = BLOCK_SIZE_256;
        JDProperties.dpi_[i].choices[7] = BLOCK_SIZE_512;
        JDProperties.defaults_[i] = BLOCK_SIZE_32;
        i = 91;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CHARACTER_TRUNCATION_, "");
        JDProperties.dpi_[i].description = "CHARACTER_TRUNCATION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "default";
        JDProperties.dpi_[i].choices[1] = "warning";
        JDProperties.dpi_[i].choices[2] = "none";
        JDProperties.defaults_[i] = "default";
        i = 95;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CLIENT_REROUTE_ALTERNATE_PORT_NUMBER_, "");
        JDProperties.dpi_[i].description = "CLIENT_REROUTE_ALTERNATE_PORT_NUMBER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 94;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CLIENT_REROUTE_ALTERNATE_SERVER_NAME_, "");
        JDProperties.dpi_[i].description = "CLIENT_REROUTE_ALTERNATE_SERVER_NAME_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 39;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CURSOR_HOLD_, "");
        JDProperties.dpi_[i].description = "CURSOR_HOLD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 49;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CURSOR_SENSITIVITY_, "");
        JDProperties.dpi_[i].description = "CURSOR_SENSITIVITY_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = CURSOR_SENSITIVITY_ASENSITIVE;
        JDProperties.dpi_[i].choices[1] = CURSOR_SENSITIVITY_INSENSITIVE;
        JDProperties.dpi_[i].choices[2] = CURSOR_SENSITIVITY_SENSITIVE;
        JDProperties.defaults_[i] = CURSOR_SENSITIVITY_ASENSITIVE;
        i = 36;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DATA_COMPRESSION_, "");
        JDProperties.dpi_[i].description = "DATA_COMPRESSION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 33;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DATA_TRUNCATION_, "");
        JDProperties.dpi_[i].description = "DATA_TRUNCATION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 47;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DATABASE_NAME_, "");
        JDProperties.dpi_[i].description = "DATABASE_NAME_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 3;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DATE_FORMAT_, "");
        JDProperties.dpi_[i].description = "DATE_FORMAT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[8];
        JDProperties.dpi_[i].choices[0] = DATE_FORMAT_JULIAN;
        JDProperties.dpi_[i].choices[1] = DATE_FORMAT_MDY;
        JDProperties.dpi_[i].choices[2] = DATE_FORMAT_DMY;
        JDProperties.dpi_[i].choices[3] = DATE_FORMAT_YMD;
        JDProperties.dpi_[i].choices[4] = "usa";
        JDProperties.dpi_[i].choices[5] = "iso";
        JDProperties.dpi_[i].choices[6] = "eur";
        JDProperties.dpi_[i].choices[7] = "jis";
        JDProperties.defaults_[i] = "";
        i = 4;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DATE_SEPARATOR_, "");
        JDProperties.dpi_[i].description = "DATE_SEPARATOR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[5];
        JDProperties.dpi_[i].choices[0] = DATE_SEPARATOR_SLASH;
        JDProperties.dpi_[i].choices[1] = DATE_SEPARATOR_DASH;
        JDProperties.dpi_[i].choices[2] = ".";
        JDProperties.dpi_[i].choices[3] = ",";
        JDProperties.dpi_[i].choices[4] = "b";
        JDProperties.defaults_[i] = "";
        i = 5;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DECIMAL_SEPARATOR_, "");
        JDProperties.dpi_[i].description = "DECIMAL_SEPARATOR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = ".";
        JDProperties.dpi_[i].choices[1] = ",";
        JDProperties.defaults_[i] = "";
        i = 41;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DRIVER_, "");
        JDProperties.dpi_[i].description = "DRIVER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = DRIVER_TOOLBOX;
        JDProperties.dpi_[i].choices[1] = DRIVER_NATIVE;
        JDProperties.defaults_[i] = DRIVER_TOOLBOX;
        i = 93;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ENABLE_CLIENT_AFFINITIES_LIST_, "");
        JDProperties.dpi_[i].description = "ENABLE_CLIENT_AFFINITIES_LIST_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.defaults_[i] = "0";
        i = 98;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ENABLE_SEAMLESS_FAILOVER_, "");
        JDProperties.dpi_[i].description = "ENABLE_SEAMLESS_FAILOVER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "2";
        JDProperties.defaults_[i] = "0";
        i = 7;
        JDProperties.dpi_[i] = new DriverPropertyInfo(EXTENDED_DYNAMIC_, "");
        JDProperties.dpi_[i].description = "EXTENDED_DYNAMIC_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 48;
        JDProperties.dpi_[i] = new DriverPropertyInfo(EXTENDED_METADATA_, "");
        JDProperties.dpi_[i].description = "EXTENDED_METADATA_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 6;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ERRORS_, "");
        JDProperties.dpi_[i].description = "ERRORS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[1] = ERRORS_BASIC;
        JDProperties.dpi_[i].choices[0] = ERRORS_FULL;
        JDProperties.defaults_[i] = ERRORS_BASIC;
        i = 43;
        JDProperties.dpi_[i] = new DriverPropertyInfo("REMOVED", "");
        JDProperties.dpi_[i].description = "REMOVED";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 44;
        JDProperties.dpi_[i] = new DriverPropertyInfo("REMOVED", "");
        JDProperties.dpi_[i].description = "REMOVED";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 58;
        JDProperties.dpi_[i] = new DriverPropertyInfo(LOGIN_TIMEOUT_, "");
        JDProperties.dpi_[i].description = "LOGIN_TIMEOUT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 45;
        JDProperties.dpi_[i] = new DriverPropertyInfo(FULL_OPEN_, "");
        JDProperties.dpi_[i].description = "FULL_OPEN_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 40;
        JDProperties.dpi_[i] = new DriverPropertyInfo(LAZY_CLOSE_, "");
        JDProperties.dpi_[i].description = "LAZY_CLOSE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 8;
        JDProperties.dpi_[i] = new DriverPropertyInfo(LIBRARIES_, "");
        JDProperties.dpi_[i].description = "LIBRARIES_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 31;
        JDProperties.dpi_[i] = new DriverPropertyInfo(LOB_THRESHOLD_, "");
        JDProperties.dpi_[i].description = "LOB_THRESHOLD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "32768";
        i = 96;
        JDProperties.dpi_[i] = new DriverPropertyInfo(MAX_RETRIES_FOR_CLIENT_REROUTE_, "");
        JDProperties.dpi_[i].description = "MAX_RETRIES_FOR_CLIENT_REROUTE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "-1";
        i = 9;
        JDProperties.dpi_[i] = new DriverPropertyInfo(NAMING_, "");
        JDProperties.dpi_[i].description = "NAMING_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "sql";
        JDProperties.dpi_[i].choices[1] = "system";
        JDProperties.defaults_[i] = "sql";
        i = 90;
        JDProperties.dpi_[i] = new DriverPropertyInfo(NUMERIC_RANGE_ERROR_, "");
        JDProperties.dpi_[i].description = "NUMERIC_RANGE_ERROR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "default";
        JDProperties.dpi_[i].choices[1] = "warning";
        JDProperties.dpi_[i].choices[2] = "none";
        JDProperties.defaults_[i] = "default";
        i = 10;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_, "");
        JDProperties.dpi_[i].description = "PACKAGE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 11;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_ADD_, "");
        JDProperties.dpi_[i].description = "PACKAGE_ADD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 12;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_CACHE_, "");
        JDProperties.dpi_[i].description = "PACKAGE_CACHE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 13;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_CLEAR_, "");
        JDProperties.dpi_[i].description = "PACKAGE_CLEAR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 30;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_CRITERIA_, "");
        JDProperties.dpi_[i].description = "PACKAGE_CRITERIA_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "default";
        JDProperties.dpi_[i].choices[1] = PACKAGE_CRITERIA_SELECT;
        JDProperties.defaults_[i] = "default";
        i = 14;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_ERROR_, "");
        JDProperties.dpi_[i].description = "PACKAGE_ERROR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "none";
        JDProperties.dpi_[i].choices[1] = "warning";
        JDProperties.dpi_[i].choices[2] = PACKAGE_ERROR_EXCEPTION;
        JDProperties.defaults_[i] = "warning";
        i = 15;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_LIBRARY_, "");
        JDProperties.dpi_[i].description = "PACKAGE_LIBRARY_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 16;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PASSWORD_, "");
        JDProperties.dpi_[i].description = "PASSWORD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 92;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PORTNUMBER_, "");
        JDProperties.dpi_[i].description = "PORTNUMBER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "0";
        i = 17;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PREFETCH_, "");
        JDProperties.dpi_[i].description = "PREFETCH_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 18;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PROMPT_, "");
        JDProperties.dpi_[i].description = "PROMPT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = "";
        i = 34;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PROXY_SERVER_, "");
        JDProperties.dpi_[i].description = "PROXY_SERVER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 89;
        JDProperties.dpi_[i] = new DriverPropertyInfo(QUERY_REPLACE_TRUNCATED_PARAMETER_, "");
        JDProperties.dpi_[i].description = "QUERY_REPLACE_TRUNCATED_PARAMETER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 19;
        JDProperties.dpi_[i] = new DriverPropertyInfo(REMARKS_, "");
        JDProperties.dpi_[i].description = "REMARKS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "sql";
        JDProperties.dpi_[i].choices[1] = "system";
        JDProperties.defaults_[i] = "system";
        i = 97;
        JDProperties.dpi_[i] = new DriverPropertyInfo(RETRY_INTERVAL_FOR_CLIENT_REROUTE_, "");
        JDProperties.dpi_[i].description = "RETRY_INTERVAL_FOR_CLIENT_REROUTE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "-1";
        i = 35;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SECONDARY_URL_, "");
        JDProperties.dpi_[i].description = "SECONDARY_URL_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 32;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SECURE_, "");
        JDProperties.dpi_[i].description = "SECURE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 20;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SORT_, "");
        JDProperties.dpi_[i].description = "SORT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = SORT_HEX;
        JDProperties.dpi_[i].choices[1] = SORT_LANGUAGE1;
        JDProperties.dpi_[i].choices[2] = SORT_TABLE1;
        JDProperties.defaults_[i] = SORT_HEX;
        i = 21;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SORT_LANGUAGE_, "");
        JDProperties.dpi_[i].description = "SORT_LANGUAGE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = SORT_LANGUAGE_ENGLISH_UNITED_STATES;
        i = 22;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SORT_TABLE_, "");
        JDProperties.dpi_[i].description = "SORT_TABLE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 23;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SORT_WEIGHT_, "");
        JDProperties.dpi_[i].description = "SORT_WEIGHT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = SORT_WEIGHT_SHARED;
        JDProperties.dpi_[i].choices[1] = SORT_WEIGHT_UNIQUE;
        JDProperties.defaults_[i] = SORT_WEIGHT_SHARED;
        i = 100;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TCP_NO_DELAY_, "");
        JDProperties.dpi_[i].description = "TCP_NO_DELAY_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 38;
        JDProperties.dpi_[i] = new DriverPropertyInfo(THREAD_USED_, "");
        JDProperties.dpi_[i].description = "THREAD_USED_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 24;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TIME_FORMAT_, "");
        JDProperties.dpi_[i].description = "TIME_FORMAT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[5];
        JDProperties.dpi_[i].choices[0] = TIME_FORMAT_HMS;
        JDProperties.dpi_[i].choices[1] = "usa";
        JDProperties.dpi_[i].choices[2] = "iso";
        JDProperties.dpi_[i].choices[3] = "eur";
        JDProperties.dpi_[i].choices[4] = "jis";
        JDProperties.defaults_[i] = "";
        i = 25;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TIME_SEPARATOR_, "");
        JDProperties.dpi_[i].description = "TIME_SEPARATOR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[4];
        JDProperties.dpi_[i].choices[0] = TIME_SEPARATOR_COLON;
        JDProperties.dpi_[i].choices[1] = ".";
        JDProperties.dpi_[i].choices[2] = ",";
        JDProperties.dpi_[i].choices[3] = "b";
        JDProperties.defaults_[i] = "";
        i = 87;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TIMESTAMP_FORMAT_, "");
        JDProperties.dpi_[i].description = "TIMESTAMP_FORMAT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "iso";
        JDProperties.dpi_[i].choices[1] = TIMESTAMP_FORMAT_IBMSQL;
        JDProperties.defaults_[i] = "iso";
        i = 26;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRACE_, "");
        JDProperties.dpi_[i].description = "TRACE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 46;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRACE_SERVER_, "");
        JDProperties.dpi_[i].description = "TRACE_SERVER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "0";
        i = 56;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRACE_TOOLBOX_, "");
        JDProperties.dpi_[i].description = "TRACE_TOOLBOX_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[12];
        JDProperties.dpi_[i].choices[0] = "none";
        JDProperties.dpi_[i].choices[1] = TRACE_TOOLBOX_DATASTREAM;
        JDProperties.dpi_[i].choices[2] = TRACE_TOOLBOX_DIAGNOSTIC;
        JDProperties.dpi_[i].choices[3] = TRACE_TOOLBOX_ERROR;
        JDProperties.dpi_[i].choices[4] = TRACE_TOOLBOX_INFORMATION;
        JDProperties.dpi_[i].choices[5] = "warning";
        JDProperties.dpi_[i].choices[6] = TRACE_TOOLBOX_CONVERSION;
        JDProperties.dpi_[i].choices[7] = TRACE_TOOLBOX_PROXY;
        JDProperties.dpi_[i].choices[8] = TRACE_TOOLBOX_PCML;
        JDProperties.dpi_[i].choices[9] = TRACE_TOOLBOX_JDBC;
        JDProperties.dpi_[i].choices[10] = "all";
        JDProperties.dpi_[i].choices[11] = TRACE_TOOLBOX_THREAD;
        JDProperties.defaults_[i] = "";
        i = 27;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRANSACTION_ISOLATION_, "");
        JDProperties.dpi_[i].description = "TRANSACTION_ISOLATION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[5];
        JDProperties.dpi_[i].choices[0] = "none";
        JDProperties.dpi_[i].choices[1] = TRANSACTION_ISOLATION_READ_COMMITTED;
        JDProperties.dpi_[i].choices[2] = TRANSACTION_ISOLATION_READ_UNCOMMITTED;
        JDProperties.dpi_[i].choices[3] = TRANSACTION_ISOLATION_REPEATABLE_READ;
        JDProperties.dpi_[i].choices[4] = TRANSACTION_ISOLATION_SERIALIZABLE;
        JDProperties.defaults_[i] = TRANSACTION_ISOLATION_READ_UNCOMMITTED;
        i = 28;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRANSLATE_BINARY_, "");
        JDProperties.dpi_[i].description = "TRANSLATE_BINARY_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 29;
        JDProperties.dpi_[i] = new DriverPropertyInfo(USER_, "");
        JDProperties.dpi_[i].description = "USER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 88;
        JDProperties.dpi_[i] = new DriverPropertyInfo(USE_DRDA_METADATA_VERSION_, "");
        JDProperties.dpi_[i].description = "USE_DRDA_METADATA_VERSION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 51;
        JDProperties.dpi_[i] = new DriverPropertyInfo(PACKAGE_CCSID_, "");
        JDProperties.dpi_[i].description = "PACKAGE_CCSID_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = PACKAGE_CCSID_UCS2;
        JDProperties.dpi_[i].choices[1] = PACKAGE_CCSID_UTF16;
        JDProperties.dpi_[i].choices[2] = "system";
        JDProperties.defaults_[i] = PACKAGE_CCSID_UCS2;
        i = 52;
        JDProperties.dpi_[i] = new DriverPropertyInfo(MINIMUM_DIVIDE_SCALE_, "");
        JDProperties.dpi_[i].description = "MINIMUM_DIVIDE_SCALE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[10];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "2";
        JDProperties.dpi_[i].choices[3] = "3";
        JDProperties.dpi_[i].choices[4] = "4";
        JDProperties.dpi_[i].choices[5] = "5";
        JDProperties.dpi_[i].choices[6] = "6";
        JDProperties.dpi_[i].choices[7] = "7";
        JDProperties.dpi_[i].choices[8] = "8";
        JDProperties.dpi_[i].choices[9] = "9";
        JDProperties.defaults_[i] = "0";
        i = 53;
        JDProperties.dpi_[i] = new DriverPropertyInfo(MAXIMUM_PRECISION_, "");
        JDProperties.dpi_[i].description = "MAXIMUM_PRECISION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "31";
        JDProperties.dpi_[i].choices[1] = "63";
        JDProperties.defaults_[i] = "31";
        i = 54;
        JDProperties.dpi_[i] = new DriverPropertyInfo(MAXIMUM_SCALE_, "");
        JDProperties.dpi_[i].description = "MAXIMUM_SCALE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[64];
        for (int j = 0; j < 64; ++j) {
            JDProperties.dpi_[i].choices[j] = Integer.toString(j);
        }
        JDProperties.defaults_[i] = "31";
        i = 55;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRANSLATE_HEX_, "");
        JDProperties.dpi_[i].description = "TRANSLATE_HEX_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRANSLATE_HEX_CHARACTER;
        JDProperties.dpi_[i].choices[1] = TRANSLATE_HEX_BINARY;
        JDProperties.defaults_[i] = TRANSLATE_HEX_CHARACTER;
        i = 57;
        JDProperties.dpi_[i] = new DriverPropertyInfo(QAQQINILIB_, "");
        JDProperties.dpi_[i].description = "QAQQINILIB_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 59;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRUE_AUTO_COMMIT_, "");
        JDProperties.dpi_[i].description = "TRUE_AUTO_COMMIT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 62;
        JDProperties.dpi_[i] = new DriverPropertyInfo(HOLD_LOCATORS_, "");
        JDProperties.dpi_[i].description = "HOLD_LOCATORS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 60;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BIDI_IMPLICIT_REORDERING_, "");
        JDProperties.dpi_[i].description = "BIDI_IMPLICIT_REORDERING_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 61;
        JDProperties.dpi_[i] = new DriverPropertyInfo(BIDI_NUMERIC_ORDERING_, "");
        JDProperties.dpi_[i].description = "BIDI_NUMERIC_ORDERING_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 63;
        JDProperties.dpi_[i] = new DriverPropertyInfo(HOLD_STATEMENTS_, "");
        JDProperties.dpi_[i].description = "HOLD_STATEMENTS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 64;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ROLLBACK_CURSOR_HOLD_, "");
        JDProperties.dpi_[i].description = "ROLLBACK_CURSOR_HOLD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 65;
        JDProperties.dpi_[i] = new DriverPropertyInfo(VARIABLE_FIELD_COMPRESSION_, "");
        JDProperties.dpi_[i].description = "VARIABLE_FIELD_COMPRESSION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[4];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.dpi_[i].choices[2] = VARIABLE_FIELD_COMPRESSION_INSERT;
        JDProperties.dpi_[i].choices[3] = "all";
        JDProperties.defaults_[i] = "all";
        i = 66;
        JDProperties.dpi_[i] = new DriverPropertyInfo(QUERY_OPTIMIZE_GOAL_, "");
        JDProperties.dpi_[i].description = "QUERY_OPTIMIZE_GOAL_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "2";
        JDProperties.defaults_[i] = "0";
        i = 67;
        JDProperties.dpi_[i] = new DriverPropertyInfo(KEEP_ALIVE_, "");
        JDProperties.dpi_[i].description = "KEEP_ALIVE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = "";
        i = 68;
        JDProperties.dpi_[i] = new DriverPropertyInfo(RECEIVE_BUFFER_SIZE_, "");
        JDProperties.dpi_[i].description = "RECEIVE_BUFFER_SIZE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 69;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SEND_BUFFER_SIZE_, "");
        JDProperties.dpi_[i].description = "SEND_BUFFER_SIZE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 70;
        JDProperties.dpi_[i] = new DriverPropertyInfo(XA_LOOSELY_COUPLED_SUPPORT_, "");
        JDProperties.dpi_[i].description = "XA_LOOSELY_COUPLED_SUPPORT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.defaults_[i] = "0";
        i = 71;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TRANSLATE_BOOLEAN_, "");
        JDProperties.dpi_[i].description = "TRANSLATE_BOOLEAN_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = FALSE_;
        JDProperties.dpi_[i].choices[1] = TRUE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 72;
        JDProperties.dpi_[i] = new DriverPropertyInfo(METADATA_SOURCE_, "");
        JDProperties.dpi_[i].description = "METADATA_SOURCE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "-1";
        JDProperties.defaults_[i] = "-1";
        i = 73;
        JDProperties.dpi_[i] = new DriverPropertyInfo(QUERY_STORAGE_LIMIT_, "");
        JDProperties.dpi_[i].description = "QUERY_STORAGE_LIMIT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "-1";
        i = 74;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DECFLOAT_ROUNDING_MODE_, "");
        JDProperties.dpi_[i].description = "DECFLOAT_ROUNDING_MODE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[7];
        JDProperties.dpi_[i].choices[0] = DECFLOAT_ROUNDING_MODE_HALF_EVEN;
        JDProperties.dpi_[i].choices[1] = DECFLOAT_ROUNDING_MODE_HALF_UP;
        JDProperties.dpi_[i].choices[2] = DECFLOAT_ROUNDING_MODE_DOWN;
        JDProperties.dpi_[i].choices[3] = DECFLOAT_ROUNDING_MODE_CEILING;
        JDProperties.dpi_[i].choices[4] = DECFLOAT_ROUNDING_MODE_FLOOR;
        JDProperties.dpi_[i].choices[5] = DECFLOAT_ROUNDING_MODE_HALF_DOWN;
        JDProperties.dpi_[i].choices[6] = DECFLOAT_ROUNDING_MODE_UP;
        JDProperties.defaults_[i] = DECFLOAT_ROUNDING_MODE_HALF_EVEN;
        i = 75;
        JDProperties.dpi_[i] = new DriverPropertyInfo(AUTOCOMMIT_EXCEPTION_, "");
        JDProperties.dpi_[i].description = "AUTOCOMMIT_EXCEPTION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 76;
        JDProperties.dpi_[i] = new DriverPropertyInfo(AUTO_COMMIT_, "");
        JDProperties.dpi_[i].description = "AUTO_COMMIT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 77;
        JDProperties.dpi_[i] = new DriverPropertyInfo(IGNORE_WARNINGS_, "");
        JDProperties.dpi_[i].description = "IGNORE_WARNINGS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 78;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SECURE_CURRENT_USER_, "");
        JDProperties.dpi_[i].description = "SECURE_CURRENT_USER_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = TRUE_;
        i = 79;
        JDProperties.dpi_[i] = new DriverPropertyInfo(CONCURRENT_ACCESS_RESOLUTION_, "");
        JDProperties.dpi_[i].description = "CONCURRENT_ACCESS_RESOLUTION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[4];
        JDProperties.dpi_[i].choices[0] = "0";
        JDProperties.dpi_[i].choices[1] = "1";
        JDProperties.dpi_[i].choices[2] = "2";
        JDProperties.dpi_[i].choices[3] = "3";
        JDProperties.defaults_[i] = "0";
        i = 80;
        JDProperties.dpi_[i] = new DriverPropertyInfo(JVM16_SYNCHRONIZE_, "");
        JDProperties.dpi_[i].description = "JVM16_SYNCHRONIZE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 81;
        JDProperties.dpi_[i] = new DriverPropertyInfo(SOCKET_TIMEOUT_, "");
        JDProperties.dpi_[i].description = "SOCKET_TIMEOUT_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 82;
        JDProperties.dpi_[i] = new DriverPropertyInfo(USE_BLOCK_UPDATE_, "");
        JDProperties.dpi_[i].description = "USE_BLOCK_UPDATE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = TRUE_;
        JDProperties.dpi_[i].choices[1] = FALSE_;
        JDProperties.defaults_[i] = FALSE_;
        i = 83;
        JDProperties.dpi_[i] = new DriverPropertyInfo(MAXIMUM_BLOCKED_INPUT_ROWS_, "");
        JDProperties.dpi_[i].description = "MAXIMUM_BLOCKED_INPUT_ROWS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[6];
        JDProperties.dpi_[i].choices[0] = "1000";
        JDProperties.dpi_[i].choices[1] = "2000";
        JDProperties.dpi_[i].choices[2] = "4000";
        JDProperties.dpi_[i].choices[3] = "8000";
        JDProperties.dpi_[i].choices[4] = "16000";
        JDProperties.dpi_[i].choices[5] = "32000";
        JDProperties.defaults_[i] = "32000";
        i = 84;
        JDProperties.dpi_[i] = new DriverPropertyInfo(QUERY_TIMEOUT_MECHANISM_, "");
        JDProperties.dpi_[i].description = "QUERY_TIMEOUT_MECHANISM_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[2];
        JDProperties.dpi_[i].choices[0] = QUERY_TIMEOUT_MECHANISM_QQRYTIMLMT;
        JDProperties.dpi_[i].choices[1] = QUERY_TIMEOUT_MECHANISM_CANCEL;
        JDProperties.defaults_[i] = QUERY_TIMEOUT_MECHANISM_QQRYTIMLMT;
        i = 85;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DESCRIBE_OPTION_, "");
        JDProperties.dpi_[i].description = "DESCRIBE_OPTION_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[3];
        JDProperties.dpi_[i].choices[0] = DESCRIBE_OPTION_SYSTEM_NAMES;
        JDProperties.dpi_[i].choices[1] = DESCRIBE_OPTION_LONG_NAMES;
        JDProperties.dpi_[i].choices[2] = DESCRIBE_OPTION_LABELS;
        JDProperties.defaults_[i] = "";
        i = 86;
        JDProperties.dpi_[i] = new DriverPropertyInfo(DECIMAL_DATA_ERRORS_, "");
        JDProperties.dpi_[i].description = "DECIMAL_DATA_ERRORS_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[4];
        JDProperties.dpi_[i].choices[0] = DECIMAL_DATA_ERRORS_IGNORE;
        JDProperties.dpi_[i].choices[1] = DECIMAL_DATA_ERRORS_REPORT;
        JDProperties.dpi_[i].choices[2] = DECIMAL_DATA_ERRORS_IGNORE_NULL;
        JDProperties.dpi_[i].choices[3] = DECIMAL_DATA_ERRORS_REPORT_NULL;
        JDProperties.defaults_[i] = "";
        i = 101;
        JDProperties.dpi_[i] = new DriverPropertyInfo(ADDITIONAL_AUTHENTICATION_FACTOR_, "");
        JDProperties.dpi_[i].description = "ADDITIONAL_AUTHENTICATION_FACTOR_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 102;
        JDProperties.dpi_[i] = new DriverPropertyInfo(STAY_ALIVE_, "");
        JDProperties.dpi_[i].description = "STAY_ALIVE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "0";
        i = 103;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TLS_TRUSTSTORE_, "");
        JDProperties.dpi_[i].description = "TLS_TRUSTSTORE_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
        i = 104;
        JDProperties.dpi_[i] = new DriverPropertyInfo(TLS_TRUSTSTORE_PASSWORD_, "");
        JDProperties.dpi_[i].description = "TLS_TRUSTSTORE_PASSWORD_DESC";
        JDProperties.dpi_[i].required = false;
        JDProperties.dpi_[i].choices = new String[0];
        JDProperties.defaults_[i] = "";
    }
}

