/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTraceListener;
import com.ibm.as400.util.commtrace.CommTracePropertyListener;
import com.ibm.as400.util.commtrace.FormatDisplay;
import com.ibm.as400.util.commtrace.FormatRemote;
import com.ibm.as400.util.commtrace.Read;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CommTrace
extends WindowAdapter {
    private AS400 sys_;
    private FormatDisplay format;
    private static JFrame MainFrame_;
    private static Locale currentLocale_;
    private static final String ALL = "*ALL";
    private static final String YES = "*YES";
    private static final String VERSION = "1.0";
    private static final String CLASS = "CommTrace";
    private static final String NO = "*NO";
    private String path;
    private String verbose_;
    private String[] pargs;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private JOptionPane optionPane;
    private JDialog dialog;
    private JTextField[] args;
    private JCheckBox fmtbox_;
    private String btnString1;
    private String btnString2;
    private JMenuItem disconnect;
    private JMenuItem exit;
    private JMenuItem display;
    private JMenuItem transfer;
    private JMenuItem mformat;
    private JMenuItem about;
    private JFrame fabout;
    private JButton aokay;
    private JButton[] b = new JButton[5];
    static final int TRANSFER = 0;
    static final int FORMAT = 1;
    static final int OPEN = 2;
    static final int FMTRMT = 3;
    static final int OPENRMT = 4;
    private JRadioButton remote;
    private JRadioButton local;
    private FormatRemote fmtcl = null;

    public CommTrace(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("-verbose");
        Hashtable<String, String> shortcuts = new Hashtable<String, String>();
        shortcuts.put("-v", "-verbose");
        CommandLineArguments arguments = new CommandLineArguments(args, v, shortcuts);
        this.verbose_ = arguments.getOptionValue("-verbose");
        if (this.verbose_ == null) {
            this.verbose_ = "false";
        }
        if (this.verbose_ != null && this.verbose_.equals("true")) {
            Trace.setTraceErrorOn(true);
            Trace.setTraceWarningOn(true);
            Trace.setTraceInformationOn(true);
            Trace.setTraceOn(true);
        }
        this.pargs = args;
        MainFrame_ = new JFrame(CLASS);
        this.gridbag = new GridBagLayout();
        MainFrame_.getContentPane().setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        MainFrame_.setFont(new Font("Helvetica", 0, 14));
        this.createMenu();
        this.createPanels();
        MainFrame_.setBackground(Color.black);
        MainFrame_.setForeground(Color.white);
        MainFrame_.addWindowListener(this);
        MainFrame_.setSize(525, 300);
        MainFrame_.setVisible(true);
    }

    private void addbutton(int button, String l, GridBagConstraints c, JPanel p) {
        this.b[button] = new JButton(l);
        this.b[button].setBackground(Color.black);
        this.b[button].setForeground(Color.white);
        this.b[button].addActionListener(new CommTraceListener(this));
        this.b[button].addKeyListener(new CommTraceListener(this));
        this.gridbag.setConstraints(this.b[button], c);
        p.add(this.b[button]);
    }

    private void createPanels() {
        JPanel pnl = new JPanel();
        this.gridbag = new GridBagLayout();
        pnl.setLayout(this.gridbag);
        this.c.fill = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridheight = 7;
        this.c.insets = new Insets(3, 3, 3, 3);
        this.c.gridwidth = 0;
        this.c.anchor = 10;
        this.gridbag.setConstraints(pnl, this.c);
        ButtonGroup bg = new ButtonGroup();
        this.remote = new JRadioButton(ResourceBundleLoader_ct.getText("Remote"));
        this.remote.addActionListener(new CommTraceListener(this));
        this.local = new JRadioButton(ResourceBundleLoader_ct.getText("Local"));
        this.local.addActionListener(new CommTraceListener(this));
        this.local.setSelected(true);
        bg.add(this.local);
        bg.add(this.remote);
        this.gridbag.setConstraints(this.local, this.c);
        pnl.add(this.local);
        this.c.gridwidth = -1;
        this.c.fill = 2;
        this.addbutton(0, ResourceBundleLoader_ct.getText("Transfer"), this.c, pnl);
        this.c.gridwidth = 0;
        JLabel trandesc = new JLabel(ResourceBundleLoader_ct.getText("TransferDescription"));
        this.gridbag.setConstraints(trandesc, this.c);
        pnl.add(trandesc);
        this.c.gridwidth = -1;
        this.addbutton(2, ResourceBundleLoader_ct.getText("Display"), this.c, pnl);
        this.c.gridwidth = 0;
        JLabel opendesc = new JLabel(ResourceBundleLoader_ct.getText("DisplayButtonDescription"));
        this.gridbag.setConstraints(opendesc, this.c);
        pnl.add(opendesc);
        this.c.gridwidth = -1;
        this.addbutton(1, ResourceBundleLoader_ct.getText("Format"), this.c, pnl);
        this.c.gridwidth = 0;
        JLabel formatdesc = new JLabel(ResourceBundleLoader_ct.getText("FormatDescription"));
        this.gridbag.setConstraints(formatdesc, this.c);
        pnl.add(formatdesc);
        this.gridbag.setConstraints(this.remote, this.c);
        pnl.add(this.remote);
        this.c.gridwidth = -1;
        this.addbutton(4, ResourceBundleLoader_ct.getText("Display"), this.c, pnl);
        this.c.gridwidth = 0;
        JLabel dispdsc = new JLabel(ResourceBundleLoader_ct.getText("DisplayRemoteDescription"));
        this.gridbag.setConstraints(dispdsc, this.c);
        pnl.add(dispdsc);
        this.c.gridwidth = -1;
        this.addbutton(3, ResourceBundleLoader_ct.getText("Format"), this.c, pnl);
        this.c.gridwidth = 0;
        JLabel fmtdsc = new JLabel(ResourceBundleLoader_ct.getText("FormatRemoteDescription"));
        this.gridbag.setConstraints(fmtdsc, this.c);
        pnl.add(fmtdsc);
        this.b[3].setEnabled(false);
        this.b[4].setEnabled(false);
        MainFrame_.getContentPane().add(pnl);
    }

    private void createMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu(ResourceBundleLoader_ct.getText("File"));
        JMenu commtrace = new JMenu(ResourceBundleLoader_ct.getText("Commtrace"));
        JMenu help = new JMenu(ResourceBundleLoader_ct.getText("Help"));
        file.setMnemonic(70);
        this.disconnect = new JMenuItem(ResourceBundleLoader_ct.getText("Disconnect"), 68);
        this.disconnect.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.exit = new JMenuItem(ResourceBundleLoader_ct.getText("Exit"), 81);
        this.exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.display = new JMenuItem(ResourceBundleLoader_ct.getText("Display"), 77);
        this.display.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.transfer = new JMenuItem(ResourceBundleLoader_ct.getText("Transfer"), 84);
        this.transfer.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.mformat = new JMenuItem(ResourceBundleLoader_ct.getText("Format"), 82);
        this.mformat.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.about = new JMenuItem(ResourceBundleLoader_ct.getText("AboutCommtrace"));
        file.add(this.disconnect);
        this.disconnect.addActionListener(new CommTraceListener(this));
        file.add(this.exit);
        this.exit.addActionListener(new CommTraceListener(this));
        commtrace.add(this.transfer);
        this.transfer.addActionListener(new CommTraceListener(this));
        commtrace.add(this.display);
        this.display.addActionListener(new CommTraceListener(this));
        commtrace.add(this.mformat);
        this.mformat.addActionListener(new CommTraceListener(this));
        help.add(this.about);
        this.about.addActionListener(new CommTraceListener(this));
        mb.add(file);
        mb.add(commtrace);
        mb.add(help);
        MainFrame_.setJMenuBar(mb);
    }

    String isVerbose() {
        return this.verbose_;
    }

    static JFrame getMainFrame() {
        return MainFrame_;
    }

    void about() {
        this.fabout = new JFrame(ResourceBundleLoader_ct.getText("About"));
        JPanel pnl = new JPanel();
        JLabel title = new JLabel(ResourceBundleLoader_ct.getText("Commtrace"));
        title.setFont(new Font("Helvetica", 1, 18));
        JLabel version = new JLabel(ResourceBundleLoader_ct.getText("Version") + " " + VERSION);
        version.setFont(new Font("Helvetica", 0, 12));
        JLabel copyright = new JLabel(ResourceBundleLoader_ct.getText("Copyright"));
        copyright.setFont(new Font("Helvetica", 0, 12));
        this.gridbag = new GridBagLayout();
        pnl.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        this.aokay = new JButton(ResourceBundleLoader_ct.getText("OK"));
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(title, this.c);
        pnl.add(title);
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(version, this.c);
        pnl.add(version);
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(copyright, this.c);
        pnl.add(copyright);
        this.c.gridheight = 1;
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.gridbag.setConstraints(this.aokay, this.c);
        pnl.add(this.aokay);
        this.aokay.addActionListener(new CommTraceListener(this));
        this.fabout.getContentPane().add(pnl);
        this.fabout.addWindowListener(this);
        this.fabout.setSize(300, 120);
        this.fabout.setVisible(true);
        this.fabout.invalidate();
        this.fabout.validate();
        this.fabout.repaint();
    }

    void disconnect() {
        this.sys_.disconnectAllServices();
        this.sys_ = null;
    }

    void transfer() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "CommTrace.transfer() Transfering file");
        }
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        IFSFileDialog fd = new IFSFileDialog((Frame)new JFrame(), "File Open", this.sys_);
        FileFilter[] filterList = new FileFilter[]{new FileFilter(ResourceBundleLoader_ct.getText("AllFiles"), "*.*")};
        fd.setFileFilter(filterList, 0);
        if (this.path != null) {
            fd.setDirectory(this.path);
        }
        String fullpath = "";
        if (fd.showDialog() == 1) {
            this.path = fd.getDirectory();
            fullpath = fd.getAbsolutePath();
            FileDialog localfd = new FileDialog((Frame)MainFrame_, ResourceBundleLoader_ct.getText("SaveAs"), 1);
            localfd.setFile(fd.getFileName());
            localfd.show();
            String path = localfd.getDirectory();
            String file = localfd.getFile();
            if (file != null) {
                Read r = new Read(this, fullpath, path + file, this.sys_);
                Thread read = new Thread((Runnable)r, "Read");
                r.setThread(read);
                read.start();
            }
        }
    }

    void open() {
        if (this.format != null) {
            this.format.setThread(null);
            this.format.close();
        }
        if (this.local.isSelected()) {
            this.format = new FormatDisplay("", "", "", "", 1);
        } else if (this.remote.isSelected()) {
            if (this.sys_ == null) {
                this.sys_ = new AS400();
            }
            this.format = this.fmtcl != null ? new FormatDisplay(this.fmtcl.getPath(), this.fmtcl.getFile(), this.sys_, 2) : new FormatDisplay("", "", this.sys_, 2);
        } else {
            Trace.log(2, "CommTrace.open() Neither 'local' nor 'remote' is selected.");
            throw new InternalErrorException(6);
        }
        Thread fmtTr = new Thread((Runnable)this.format, "Format");
        this.format.setThread(fmtTr);
        fmtTr.start();
    }

    void formatoptions() {
        this.args = new JTextField[3];
        this.args[0] = new JTextField(ALL);
        this.args[1] = new JTextField(ALL);
        this.args[2] = new JTextField(ALL);
        this.fmtbox_ = new JCheckBox(ResourceBundleLoader_ct.getText("FmtBdcst"));
        this.fmtbox_.setSelected(true);
        this.btnString1 = ResourceBundleLoader_ct.getText("Format");
        this.btnString2 = ResourceBundleLoader_ct.getText("Cancel");
        Object[] array = new Object[]{ResourceBundleLoader_ct.getText("Src/DestIPAddr"), this.args[0], ResourceBundleLoader_ct.getText("Src/DestIPAddr"), this.args[1], ResourceBundleLoader_ct.getText("IPPortnum"), this.args[2], this.fmtbox_};
        String msg = "";
        Object[] options = new Object[]{this.btnString1, this.btnString2};
        this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
        this.dialog = new JDialog(MainFrame_, ResourceBundleLoader_ct.getText("FormatOpt"), true);
        this.dialog.setContentPane(this.optionPane);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CommTrace.this.optionPane.setValue(-1);
            }
        });
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommTrace.this.optionPane.setValue(CommTrace.this.btnString1);
                }
            });
        }
        this.optionPane.addPropertyChangeListener(new CommTracePropertyListener(this));
        this.dialog.setFont(new Font("Helvetica", 0, 14));
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(this);
        this.dialog.setSize(300, 300);
        this.dialog.show();
    }

    void formatremote() {
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        String box = this.fmtbox_.isSelected() ? YES : NO;
        this.fmtcl = new FormatRemote(this.sys_, this.verbose_, this.args[0].getText(), this.args[1].getText(), this.args[2].getText(), box, this);
        this.fmtcl.setThread(new Thread((Runnable)this.fmtcl, "FormatClient"));
        this.fmtcl.getThread().start();
    }

    void format() {
        if (this.format != null) {
            this.format.setThread(null);
            this.format.close();
        }
        String box = this.fmtbox_.isSelected() ? YES : NO;
        this.format = new FormatDisplay(this.args[0].getText(), this.args[1].getText(), this.args[2].getText(), box, 3);
        Thread fmtTr = new Thread((Runnable)this.format, "Format");
        this.format.setThread(fmtTr);
        fmtTr.start();
    }

    void exit() {
        if (this.format != null) {
            this.format.close();
        }
        System.exit(0);
    }

    void framerepaint() {
        MainFrame_.invalidate();
        MainFrame_.validate();
        MainFrame_.repaint();
    }

    static void error(Component component, String title, String msg) {
        JOptionPane.showMessageDialog(component, msg, title, 0);
    }

    static void error(String title, String msg) {
        JOptionPane.showMessageDialog(MainFrame_, msg, title, 0);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Object source = e.getSource();
        if (source == MainFrame_) {
            this.exit();
        } else if (source == this.fabout) {
            this.fabout.setVisible(false);
        }
    }

    JOptionPane getOptionPane() {
        return this.optionPane;
    }

    JDialog getDialog() {
        return this.dialog;
    }

    JTextField[] getArguments() {
        return this.args;
    }

    String getButtonString1() {
        return this.btnString1;
    }

    String getButtonString2() {
        return this.btnString2;
    }

    JMenuItem getDisconnectMenuItem() {
        return this.disconnect;
    }

    JMenuItem getExitMenuItem() {
        return this.exit;
    }

    JMenuItem getDisplayMenuItem() {
        return this.display;
    }

    JMenuItem getTransferMenuItem() {
        return this.transfer;
    }

    JMenuItem getFormatMenuItem() {
        return this.mformat;
    }

    JMenuItem getAboutMenuItem() {
        return this.about;
    }

    JFrame getAboutFrame() {
        return this.fabout;
    }

    JButton getAboutOkayButton() {
        return this.aokay;
    }

    JButton[] getButtons() {
        return this.b;
    }

    JRadioButton getRemoteButton() {
        return this.remote;
    }

    JRadioButton getLocalButton() {
        return this.local;
    }

    void setFormatRemote(FormatRemote fmt) {
        this.fmtcl = fmt;
    }

    public static void main(String[] args) {
        new CommTrace(args);
    }
}

