/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.BlockingQueueBroker;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamIterationHead;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamIterationTail<IN>
extends OneInputStreamTask<IN, IN> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamIterationTail.class);

    public StreamIterationTail(Environment environment) throws Exception {
        super(environment);
    }

    @Override
    public void init() throws Exception {
        String iterationId = this.getConfiguration().getIterationId();
        if (iterationId == null || iterationId.length() == 0) {
            throw new Exception("Missing iteration ID in the task configuration");
        }
        String brokerID = StreamIterationHead.createBrokerIdString(this.getEnvironment().getJobID(), iterationId, this.getEnvironment().getTaskInfo().getIndexOfThisSubtask());
        long iterationWaitTime = this.getConfiguration().getIterationWaitTime();
        LOG.info("Iteration tail {} trying to acquire feedback queue under {}", (Object)this.getName(), (Object)brokerID);
        BlockingQueue dataChannel = (BlockingQueue)BlockingQueueBroker.INSTANCE.get(brokerID);
        LOG.info("Iteration tail {} acquired feedback queue {}", (Object)this.getName(), (Object)brokerID);
        RecordPusher headOperator = new RecordPusher();
        headOperator.setup(this, this.getConfiguration(), new IterationTailOutput(dataChannel, iterationWaitTime));
        this.mainOperator = headOperator;
        super.init();
    }

    private static class IterationTailOutput<IN>
    implements Output<StreamRecord<IN>> {
        private final BlockingQueue<StreamRecord<IN>> dataChannel;
        private final long iterationWaitTime;
        private final boolean shouldWait;

        IterationTailOutput(BlockingQueue<StreamRecord<IN>> dataChannel, long iterationWaitTime) {
            this.dataChannel = dataChannel;
            this.iterationWaitTime = iterationWaitTime;
            this.shouldWait = iterationWaitTime > 0L;
        }

        @Override
        public void emitWatermark(Watermark mark) {
        }

        @Override
        public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
        }

        @Override
        public void emitRecordAttributes(RecordAttributes recordAttributes) {
        }

        public void collect(StreamRecord<IN> record) {
            try {
                if (this.shouldWait) {
                    this.dataChannel.offer(record, this.iterationWaitTime, TimeUnit.MILLISECONDS);
                } else {
                    this.dataChannel.put(record);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            throw new UnsupportedOperationException("Side outputs not used in iteration tail");
        }

        public void close() {
        }
    }

    private static class RecordPusher<IN>
    extends AbstractStreamOperator<IN>
    implements OneInputStreamOperator<IN, IN> {
        private static final long serialVersionUID = 1L;

        private RecordPusher() {
        }

        @Override
        public void processElement(StreamRecord<IN> record) throws Exception {
            this.output.collect(record);
        }

        @Override
        public void processWatermark(Watermark mark) {
        }

        @Override
        public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        }
    }
}

