/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.VertexGroupComputeUtil;
import org.apache.flink.runtime.executiongraph.failover.PipelinedRegionComputeUtil;
import org.apache.flink.runtime.executiongraph.failover.StronglyConnectedComponentsComputeUtils;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

public final class SchedulingPipelinedRegionComputeUtil {
    public static Set<Set<SchedulingExecutionVertex>> computePipelinedRegions(Iterable<? extends SchedulingExecutionVertex> topologicallySortedVertices, Function<ExecutionVertexID, ? extends SchedulingExecutionVertex> executionVertexRetriever, Function<IntermediateResultPartitionID, ? extends SchedulingResultPartition> resultPartitionRetriever) {
        Map<SchedulingExecutionVertex, Set<SchedulingExecutionVertex>> vertexToRegion = PipelinedRegionComputeUtil.buildRawRegions(topologicallySortedVertices, vertex -> SchedulingPipelinedRegionComputeUtil.getMustBePipelinedConsumedResults(vertex, resultPartitionRetriever));
        return SchedulingPipelinedRegionComputeUtil.mergeRegionsOnCycles(vertexToRegion, executionVertexRetriever);
    }

    private static Set<Set<SchedulingExecutionVertex>> mergeRegionsOnCycles(Map<SchedulingExecutionVertex, Set<SchedulingExecutionVertex>> vertexToRegion, Function<ExecutionVertexID, ? extends SchedulingExecutionVertex> executionVertexRetriever) {
        ArrayList<Set<SchedulingExecutionVertex>> regionList = new ArrayList<Set<SchedulingExecutionVertex>>(VertexGroupComputeUtil.uniqueVertexGroups(vertexToRegion));
        List<List<Integer>> outEdges = SchedulingPipelinedRegionComputeUtil.buildOutEdgesDesc(vertexToRegion, regionList, executionVertexRetriever);
        Set<Set<Integer>> sccs = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents(outEdges.size(), outEdges);
        Set<Set<SchedulingExecutionVertex>> mergedRegions = Collections.newSetFromMap(new IdentityHashMap());
        for (Set<Integer> scc : sccs) {
            Preconditions.checkState((scc.size() > 0 ? 1 : 0) != 0);
            Set<Object> mergedRegion = new HashSet();
            for (int regionIndex : scc) {
                mergedRegion = VertexGroupComputeUtil.mergeVertexGroups(mergedRegion, (Set)regionList.get(regionIndex), vertexToRegion);
            }
            mergedRegions.add(mergedRegion);
        }
        return mergedRegions;
    }

    private static List<List<Integer>> buildOutEdgesDesc(Map<SchedulingExecutionVertex, Set<SchedulingExecutionVertex>> vertexToRegion, List<Set<SchedulingExecutionVertex>> regionList, Function<ExecutionVertexID, ? extends SchedulingExecutionVertex> executionVertexRetriever) {
        IdentityHashMap<Set<SchedulingExecutionVertex>, Integer> regionIndices = new IdentityHashMap<Set<SchedulingExecutionVertex>, Integer>();
        for (int i = 0; i < regionList.size(); ++i) {
            regionIndices.put(regionList.get(i), i);
        }
        ArrayList<List<Integer>> outEdges = new ArrayList<List<Integer>>(regionList.size());
        for (Set<SchedulingExecutionVertex> currentRegion : regionList) {
            ArrayList currentRegionOutEdges = new ArrayList();
            for (SchedulingExecutionVertex vertex : currentRegion) {
                for (SchedulingResultPartition producedResult : vertex.getProducedResults()) {
                    if (producedResult.getResultType().mustBePipelinedConsumed()) continue;
                    for (ConsumerVertexGroup consumerVertexGroup : producedResult.getConsumerVertexGroups()) {
                        ExecutionVertexID consumerVertexId;
                        SchedulingExecutionVertex consumerVertex;
                        Iterator<ExecutionVertexID> iterator = consumerVertexGroup.iterator();
                        while (iterator.hasNext() && vertexToRegion.containsKey(consumerVertex = executionVertexRetriever.apply(consumerVertexId = iterator.next()))) {
                            if (currentRegion.contains(consumerVertex)) continue;
                            currentRegionOutEdges.add(regionIndices.get(vertexToRegion.get(consumerVertex)));
                        }
                    }
                }
            }
            outEdges.add(currentRegionOutEdges);
        }
        return outEdges;
    }

    private static Iterable<SchedulingResultPartition> getMustBePipelinedConsumedResults(SchedulingExecutionVertex vertex, Function<IntermediateResultPartitionID, ? extends SchedulingResultPartition> resultPartitionRetriever) {
        ArrayList<SchedulingResultPartition> mustBePipelinedConsumedResults = new ArrayList<SchedulingResultPartition>();
        for (ConsumedPartitionGroup consumedPartitionGroup : vertex.getConsumedPartitionGroups()) {
            IntermediateResultPartitionID partitionId;
            SchedulingResultPartition consumedResult;
            Iterator<IntermediateResultPartitionID> iterator = consumedPartitionGroup.iterator();
            while (iterator.hasNext() && (consumedResult = resultPartitionRetriever.apply(partitionId = iterator.next())).getResultType().mustBePipelinedConsumed()) {
                mustBePipelinedConsumedResults.add(consumedResult);
            }
        }
        return mustBePipelinedConsumedResults;
    }

    private SchedulingPipelinedRegionComputeUtil() {
    }
}

