/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

public enum ResultPartitionType {
    BLOCKING(true, false, false, ConsumingConstraint.BLOCKING, ReleaseBy.SCHEDULER),
    BLOCKING_PERSISTENT(true, false, true, ConsumingConstraint.BLOCKING, ReleaseBy.SCHEDULER),
    PIPELINED(false, false, false, ConsumingConstraint.MUST_BE_PIPELINED, ReleaseBy.UPSTREAM),
    PIPELINED_BOUNDED(false, true, false, ConsumingConstraint.MUST_BE_PIPELINED, ReleaseBy.UPSTREAM),
    PIPELINED_APPROXIMATE(false, true, false, ConsumingConstraint.CAN_BE_PIPELINED, ReleaseBy.UPSTREAM),
    HYBRID_FULL(true, false, false, ConsumingConstraint.CAN_BE_PIPELINED, ReleaseBy.SCHEDULER),
    HYBRID_SELECTIVE(false, false, false, ConsumingConstraint.CAN_BE_PIPELINED, ReleaseBy.SCHEDULER);

    private final boolean isReconsumable;
    private final boolean isBounded;
    private final boolean isPersistent;
    private final ConsumingConstraint consumingConstraint;
    private final ReleaseBy releaseBy;

    private ResultPartitionType(boolean isReconsumable, boolean isBounded, boolean isPersistent, ConsumingConstraint consumingConstraint, ReleaseBy releaseBy) {
        this.isReconsumable = isReconsumable;
        this.isBounded = isBounded;
        this.isPersistent = isPersistent;
        this.consumingConstraint = consumingConstraint;
        this.releaseBy = releaseBy;
    }

    public boolean mustBePipelinedConsumed() {
        return this.consumingConstraint == ConsumingConstraint.MUST_BE_PIPELINED;
    }

    public boolean canBePipelinedConsumed() {
        return this.consumingConstraint == ConsumingConstraint.CAN_BE_PIPELINED || this.consumingConstraint == ConsumingConstraint.MUST_BE_PIPELINED;
    }

    public boolean isReleaseByScheduler() {
        return this.releaseBy == ReleaseBy.SCHEDULER;
    }

    public boolean isReleaseByUpstream() {
        return this.releaseBy == ReleaseBy.UPSTREAM;
    }

    public boolean isBlockingOrBlockingPersistentResultPartition() {
        return this == BLOCKING || this == BLOCKING_PERSISTENT;
    }

    public boolean isHybridResultPartition() {
        return this == HYBRID_FULL || this == HYBRID_SELECTIVE;
    }

    public boolean isPipelinedOrPipelinedBoundedResultPartition() {
        return this == PIPELINED || this == PIPELINED_BOUNDED;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean supportCompression() {
        return this.isBlockingOrBlockingPersistentResultPartition() || this == HYBRID_FULL || this == HYBRID_SELECTIVE;
    }

    public boolean isReconsumable() {
        return this.isReconsumable;
    }

    private static enum ReleaseBy {
        UPSTREAM,
        SCHEDULER;

    }

    private static enum ConsumingConstraint {
        BLOCKING,
        CAN_BE_PIPELINED,
        MUST_BE_PIPELINED;

    }
}

