/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.factory;

import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite.raft.jraft.storage.logit.storage.db.AbstractDB;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.AbstractFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileManager;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileType;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.index.IndexFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.segment.SegmentFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.service.AllocateFileService;
import org.apache.ignite.raft.jraft.storage.logit.storage.service.ServiceManager;

public class LogStoreFactory {
    private final StoreOptions storeOptions;
    private final RaftOptions raftOptions;

    public LogStoreFactory(StoreOptions opts, RaftOptions raftOptions) {
        this.storeOptions = opts;
        this.raftOptions = raftOptions;
    }

    public AbstractFile newFile(FileType fileType, String filePath) {
        switch (fileType) {
            case FILE_INDEX: {
                return new IndexFile(this.raftOptions, filePath, this.storeOptions.getIndexFileSize());
            }
            case FILE_SEGMENT: {
                return new SegmentFile(this.raftOptions, filePath, this.storeOptions.getSegmentFileSize());
            }
            case FILE_CONFIGURATION: {
                return new SegmentFile(this.raftOptions, filePath, this.storeOptions.getConfFileSize());
            }
        }
        throw new AssertionError((Object)("Unidentified file type: " + String.valueOf((Object)fileType)));
    }

    public FileManager newFileManager(FileType fileType, String storePath, AllocateFileService allocateService) {
        FileManager.FileManagerBuilder fileManagerBuilder = FileManager.newBuilder().fileType(fileType).fileSize(this.getFileSize(fileType)).storePath(storePath).logStoreFactory(this).allocateService(allocateService);
        return fileManagerBuilder.build();
    }

    public ServiceManager newServiceManager(AbstractDB abstractDB) {
        return new ServiceManager(abstractDB);
    }

    public AllocateFileService newAllocateService(AbstractDB abstractDB) {
        return new AllocateFileService(abstractDB, this);
    }

    public int getFileSize(FileType fileType) {
        return this.isIndex(fileType) ? this.storeOptions.getIndexFileSize() : (this.isConf(fileType) ? this.storeOptions.getConfFileSize() : this.storeOptions.getSegmentFileSize());
    }

    private boolean isIndex(FileType fileType) {
        return fileType == FileType.FILE_INDEX;
    }

    private boolean isConf(FileType fileType) {
        return fileType == FileType.FILE_CONFIGURATION;
    }

    public StoreOptions getStoreOptions() {
        return this.storeOptions;
    }

    public RaftOptions getRaftOptions() {
        return this.raftOptions;
    }
}

