export type TypeOrReturnType<T> = T extends (...args: any[]) => any ? ReturnType<T> : T;
export type CacheEntry<T> = {
    value: TypeOrReturnType<T> | undefined;
    dependencies: readonly any[];
};
export type Cache<T> = {
    [K in keyof T]: CacheEntry<T[K]>;
};
export declare class ComputedStateCache<T extends Record<string, any>> {
    private readonly cache;
    constructor(initialValues: Cache<T>);
    cached<K extends keyof T, D extends readonly any[]>(key: K, delegate: (...dependencies: D) => TypeOrReturnType<T[K]>, dependencies: D): TypeOrReturnType<T[K]>;
    cachedData<K extends keyof T, D extends readonly any[], Y extends any[]>(key: K, delegate: (...data: Y) => TypeOrReturnType<T[K]>, data: Y, dependencies: D): TypeOrReturnType<T[K]>;
}
//# sourceMappingURL=ComputedStateCache.d.ts.map