import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useCallback, useEffect, useState } from "react";
import { ExpandableRowContent } from "@patternfly/react-table/dist/js/components/Table";
import { TableComposable, Thead, Tbody, Tr, Th, Td } from "@patternfly/react-table/dist/js/components/TableComposable";
import _ from "lodash";
import ProcessListChildTable from "../ProcessListChildTable/ProcessListChildTable";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import { getProcessInstanceDescription, ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import ProcessListActionsKebab from "../ProcessListActionsKebab/ProcessListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import "../styles.css";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const ProcessListTable = ({ isLoading, expanded, setExpanded, sortBy, onSort, processInstances, setProcessInstances, selectedInstances, setSelectedInstances, selectableInstances, setSelectableInstances, setIsAllChecked, singularProcessLabel, pluralProcessLabel, isTriggerCloudEventEnabled, driver, ouiaId, ouiaSafe, }) => {
    const [rowPairs, setRowPairs] = useState([]);
    const columns = ["__Toggle", "__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const [modalTitle, setModalTitle] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [titleType, setTitleType] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [selectedProcessInstance, setSelectedProcessInstance] = useState();
    const handleModalToggle = useCallback(() => {
        setIsModalOpen((currentValue) => !currentValue);
    }, []);
    const onShowMessage = useCallback((title, content, type, processInstance) => {
        setSelectedProcessInstance(processInstance);
        setTitleType(type);
        setModalTitle(title);
        setModalContent(content);
        handleModalToggle();
    }, [handleModalToggle]);
    const onSkipClick = useCallback(async (processInstance) => {
        try {
            await driver.handleProcessSkip(processInstance);
            onShowMessage("Skip operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully skipped.`, TitleType.SUCCESS, processInstance);
        }
        catch (error) {
            onShowMessage("Skip operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} failed to skip. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    }, [driver, handleModalToggle, onShowMessage, singularProcessLabel]);
    const onRetryClick = useCallback(async (processInstance) => {
        try {
            await driver.handleProcessRetry(processInstance);
            onShowMessage("Retry operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully re-executed.`, TitleType.SUCCESS, processInstance);
        }
        catch (error) {
            onShowMessage("Retry operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} failed to re-execute. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    }, [driver, handleModalToggle, onShowMessage, singularProcessLabel]);
    const onAbortClick = useCallback(async (processInstance) => {
        try {
            await driver.handleProcessAbort(processInstance);
            onShowMessage("Abort operation", `The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully aborted.`, TitleType.SUCCESS, processInstance);
            setProcessInstances((currentProcessInstances) => {
                currentProcessInstances.forEach((instance) => {
                    if (instance.id === processInstance.id) {
                        instance.state = ProcessInstanceState.Aborted;
                    }
                });
                return [...currentProcessInstances];
            });
        }
        catch (error) {
            onShowMessage("Abort operation", `Failed to abort ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} ${processInstance.processName}. Message: ${error.message}`, TitleType.FAILURE, processInstance);
        }
        finally {
            handleModalToggle();
        }
    }, [driver, handleModalToggle, onShowMessage, setProcessInstances, singularProcessLabel]);
    const handleClick = useCallback((processInstance) => {
        driver.openProcess(processInstance);
    }, [driver]);
    const checkBoxSelect = useCallback((processInstance) => {
        setProcessInstances((currentProcessInstances) => {
            const clonedProcessInstances = [...currentProcessInstances];
            clonedProcessInstances.forEach((instance) => {
                if (processInstance.id === instance.id) {
                    if (instance.isSelected) {
                        instance.isSelected = false;
                        setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== instance.id));
                    }
                    else {
                        instance.isSelected = true;
                        setSelectedInstances([...selectedInstances, instance]);
                    }
                }
            });
            return clonedProcessInstances;
        });
    }, [selectedInstances, setProcessInstances, setSelectedInstances]);
    useEffect(() => {
        if (!_.isEmpty(processInstances)) {
            const tempRows = [];
            processInstances.forEach((processInstance) => {
                var _a;
                tempRows.push({
                    id: processInstance.id,
                    parent: [
                        _jsx(_Fragment, { children: ((_a = processInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) && processInstance.serviceUrl !== null ? (_jsx(Checkbox, { isChecked: processInstance.isSelected, onChange: () => checkBoxSelect(processInstance), "aria-label": "process-list-checkbox", "data-testid": `checkbox-${processInstance.id}`, id: `checkbox-${processInstance.id}`, name: `checkbox-${processInstance.id}` })) : (_jsx(DisablePopup, { processInstanceData: processInstance, component: _jsx(Checkbox, { "aria-label": "process-list-checkbox-disabled", "data-testid": `checkbox-${processInstance.id}`, id: `checkbox-${processInstance.id}`, isDisabled: true }) })) }),
                        _jsxs(_Fragment, { children: [_jsx("a", { className: "kogito-process-list__link", onClick: () => handleClick(processInstance), ...componentOuiaProps(ouiaId, "process-description", ouiaSafe), children: _jsx("strong", { children: _jsx(ItemDescriptor, { itemDescription: getProcessInstanceDescription(processInstance) }) }) }), _jsx(EndpointLink, { serviceUrl: processInstance.serviceUrl, isLinkShown: false })] }),
                        processInstance.state === ProcessInstanceState.Error ? (_jsx(ErrorPopover, { processInstanceData: processInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (ProcessInstanceIconCreator(processInstance.state)),
                        processInstance.start ? _jsx(Moment, { fromNow: true, children: new Date(`${processInstance.start}`) }) : "",
                        processInstance.lastUpdate ? (_jsxs("span", { children: [_jsx(HistoryIcon, { className: "pf-u-mr-sm" }), " ", "Updated ", _jsx(Moment, { fromNow: true, children: new Date(`${processInstance.lastUpdate}`) })] })) : (""),
                        _jsx(ProcessListActionsKebab, { processInstance: processInstance, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick }, processInstance.id),
                    ],
                    child: [processInstance.id],
                });
            });
            setRowPairs(tempRows);
        }
        else {
            setRowPairs([]);
        }
    }, [checkBoxSelect, handleClick, onAbortClick, onRetryClick, onSkipClick, ouiaId, ouiaSafe, processInstances]);
    const loadChild = (parentId, parentIndex) => {
        if (!expanded[parentIndex]) {
            return null;
        }
        else {
            return (_jsx(ProcessListChildTable, { parentProcessId: parentId, processInstances: processInstances, setProcessInstances: setProcessInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, setSelectableInstances: setSelectableInstances, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel, driver: driver, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, ouiaId: parentId }));
        }
    };
    const onToggle = (pairIndex, pair) => {
        var _a;
        setExpanded({
            ...expanded,
            [pairIndex]: !expanded[pairIndex],
        });
        if (expanded[pairIndex]) {
            const processInstance = processInstances.find((instance) => instance.id === pair.id);
            (_a = processInstance === null || processInstance === void 0 ? void 0 : processInstance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                if (childInstance.isSelected) {
                    const index = selectedInstances.findIndex((selectedInstance) => selectedInstance.id === childInstance.id);
                    if (index !== -1) {
                        selectedInstances.splice(index, 1);
                    }
                }
            });
            processInstances.forEach((instance) => {
                var _a;
                if ((processInstance === null || processInstance === void 0 ? void 0 : processInstance.id) === instance.id) {
                    instance.isOpen = false;
                    (_a = instance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((child) => {
                        var _a;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                            setSelectableInstances((prev) => prev - 1);
                        }
                    });
                }
            });
        }
        else {
            let processInstance;
            if (!_.isEmpty(processInstances)) {
                processInstance = processInstances.find((instance) => instance.id === pair.id);
                processInstances.forEach((instance) => {
                    if ((processInstance === null || processInstance === void 0 ? void 0 : processInstance.id) === instance.id) {
                        instance.isOpen = true;
                    }
                });
            }
        }
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    };
    return (_jsxs(React.Fragment, { children: [_jsx(ProcessInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: setTitle(titleType, modalTitle), modalContent: modalContent, processName: selectedProcessInstance && selectedProcessInstance.processName, ouiaId: selectedProcessInstance && "process-" + selectedProcessInstance.id }), _jsxs(TableComposable, { "data-testid": "process-list-table", "aria-label": "Process List Table", ...componentOuiaProps(ouiaId, "process-list-table", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(Thead, { children: _jsx(Tr, { ouiaId: "process-list-table-header", children: columns.map((column, columnIndex) => {
                                let sortParams = {};
                                if (!isLoading && rowPairs.length > 0) {
                                    sortParams = {
                                        sort: {
                                            sortBy,
                                            onSort,
                                            columnIndex,
                                        },
                                    };
                                }
                                let styleParams;
                                switch (columnIndex) {
                                    case 0:
                                        styleParams = { width: "72px" };
                                        sortParams = {};
                                        break;
                                    case 1:
                                        styleParams = { width: "86px" };
                                        sortParams = {};
                                        break;
                                    case columns.length - 1:
                                        styleParams = { width: "188px" };
                                        sortParams = {};
                                        break;
                                }
                                return (_jsx(Th, { style: styleParams, ...sortParams, children: column.startsWith("__") ? "" : column }, `${column}_header`));
                            }) }) }), !isLoading && !_.isEmpty(rowPairs) ? (rowPairs.map((pair, pairIndex) => {
                        const parentRow = (_jsxs(Tr, { ...componentOuiaProps(pair.id, "process-list-row", true), children: [_jsx(Td, { expand: {
                                        rowIndex: pairIndex,
                                        isExpanded: expanded[pairIndex],
                                        onToggle: () => onToggle(pairIndex, pair),
                                    }, ...componentOuiaProps(columns[0].toLowerCase(), "process-list-cell", true) }, `${pair.id}-parent-0`), pair.parent.map((cell, cellIndex) => (_jsx(Td, { dataLabel: columns[cellIndex + 1], ...componentOuiaProps(columns[cellIndex + 1].toLowerCase(), "process-list-cell", true), children: cell }, `${pair.id}-parent-${columns[cellIndex + 1]}`)))] }, `${pair.id}-parent`));
                        const childRow = (_jsxs(Tr, { isExpanded: expanded[pairIndex] === true, ...componentOuiaProps(pair.id, "process-list-row-expanded", true), children: [_jsx(Td, {}, `${pair.id}-child-0`), rowPairs[pairIndex].child.map((cell, cellIndex) => (_jsx(Td, { dataLabel: columns[cellIndex], noPadding: rowPairs[pairIndex].noPadding, colSpan: 6, children: _jsx(ExpandableRowContent, { children: loadChild(cell, pairIndex) }) }, `${pair.id}-child-${columns[++cellIndex]}`)))] }, `${pair.id}-child`));
                        return (_jsxs(Tbody, { children: [parentRow, childRow] }, `${pair.id}_tBody`));
                    })) : (_jsx("tbody", { children: _jsx(Tr, { children: _jsx(Td, { colSpan: 7, children: _jsxs(_Fragment, { children: [isLoading && rowPairs.length === 0 && _jsx(KogitoSpinner, { spinnerText: "Loading process instances..." }), !isLoading && rowPairs.length === 0 && (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }))] }) }) }) }))] })] }));
};
export default ProcessListTable;
//# sourceMappingURL=ProcessListTable.js.map