import { ResourceFetcher } from "../fetch/ResourceFetcher";
import { IngressDescriptor } from "../resources/kubernetes/Ingress";
import { KubernetesConnection, KubernetesConnectionStatus } from "./KubernetesConnection";
import { DeploymentDescriptor } from "../resources/kubernetes/Deployment";
import { DeploymentState, Resource } from "../resources/common";
export interface KubernetesServiceArgs {
    connection: KubernetesConnection;
    proxyUrl?: string;
}
export declare class KubernetesService {
    readonly args: KubernetesServiceArgs;
    readonly fetcher: ResourceFetcher;
    constructor(args: KubernetesServiceArgs);
    composeDeploymentUrlFromIngress(ingress: IngressDescriptor): string;
    extractDeploymentState(args: {
        deployment?: DeploymentDescriptor;
    }): DeploymentState;
    withFetch<T = Resource>(callback: (fetcher: ResourceFetcher) => Promise<T>): Promise<T>;
    isConnectionEstablished(connection: KubernetesConnection, requiredResources?: string[]): Promise<KubernetesConnectionStatus>;
    newResourceName(prefix: string): string;
}
//# sourceMappingURL=KubernetesService.d.ts.map