import Clipboard from "./tools/Clipboard";
import Driver from "./tools/Driver";
import Locator from "../framework/Locator";
import Page from "../framework/Page";
import PageFragment from "../framework/PageFragment";
import Screenshot from "./tools/ScreenShot";
import Window from "./tools/Window";
import { resolve } from "path";
class Tools {
    constructor(driver, testName) {
        this.driver = driver;
        this.testName = testName;
        this.screenShot = new Screenshot(this.driver, Tools.SCREENSHOTS_DIR);
    }
    async finishTest() {
        const screenshotName = "screenshot_after_" + this.testName;
        await this.window().leaveFrame();
        await this.makeScreenshots(screenshotName);
        return await Driver.quit(this.driver);
    }
    async makeScreenshots(screenshotNamePrefix) {
        await this.screenShot.takeHtml(screenshotNamePrefix);
        return await this.screenShot.takePng(screenshotNamePrefix);
    }
    sleep(timeout) {
        return new Promise((resolve) => setTimeout(resolve, timeout));
    }
    by(by) {
        return new Locator(this.driver, by);
    }
    clipboard() {
        return new Clipboard(this.driver);
    }
    window() {
        return new Window(this.driver);
    }
    async openPage(type, url) {
        await Driver.openUrl(this.driver, url);
        return await this.createPage(type);
    }
    async createPage(type) {
        return await Page.create(type, this);
    }
    async createPageFragment(type, root) {
        return await PageFragment.create(type, this, root);
    }
    static async init(testName) {
        return new Tools(await Driver.init(), testName);
    }
}
Tools.SCREENSHOTS_DIR = resolve("dist-tests-e2e", "screenshots");
export default Tools;
//# sourceMappingURL=Tools.js.map