import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { SortableContainer, SortableElement } from "react-sortable-hoc";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { GripVerticalIcon } from "@patternfly/react-icons/dist/js/icons/grip-vertical-icon";
import "./DataTypesSort.scss";
const DataTypesSort = ({ dataTypes, onReorder }) => {
    const [state, setState] = useState(dataTypes);
    const onSortEnd = ({ oldIndex, newIndex }) => {
        const newOrder = reorder(state, oldIndex, newIndex);
        setState(newOrder);
        onReorder(oldIndex, newIndex);
    };
    const getHelperClass = () => {
        if (state.length >= 8) {
            return "data-type-item__sortable--sm-size";
        }
        if (state.length >= 5) {
            return "data-type-item__sortable--md-size";
        }
    };
    useEffect(() => {
        setState(dataTypes);
    }, [dataTypes]);
    return _jsx(SortableList, { items: state, onSortEnd: onSortEnd, lockAxis: "y", helperClass: getHelperClass() });
};
export default DataTypesSort;
const SortableList = SortableContainer(({ items }) => {
    return (_jsx("ul", { className: "data-types-sorting", children: items.map((item, index) => (_jsx(SortableItem, { index: index, item: item }, `item-${item.name}`))) }));
});
const SortableItem = SortableElement(({ item }) => (_jsx("li", { className: "editable-item data-type-item__sortable", children: _jsx("section", { className: "editable-item__inner", "data-ouia-component-id": item.name, children: _jsxs(Flex, { alignItems: { default: "alignItemsCenter" }, children: [_jsx(FlexItem, { spacer: { default: "spacerXs" }, children: _jsx(Button, { variant: "plain", "aria-label": "Drag to sort", component: "span", ouiaId: "drag-it", children: _jsx(GripVerticalIcon, {}) }) }), _jsx(FlexItem, { children: _jsx("strong", { children: item.name }) }), _jsxs(FlexItem, { children: [_jsx(Label, { color: "blue", children: item.type }), " ", _jsx(Label, { color: "blue", children: item.optype })] })] }) }) })));
const reorder = (list, startIndex, endIndex) => {
    const result = [...list];
    const [removed] = result.splice(startIndex, 1);
    result.splice(endIndex, 0, removed);
    return result;
};
//# sourceMappingURL=DataTypesSort.js.map