import { ApolloClient } from "apollo-client";
import { TriggerableNode, NodeInstance, SvgSuccessResponse, SvgErrorResponse } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { Job, JobOperationResult, ProcessInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export interface ProcessDetailsQueries {
    getProcessDetails(id: string): Promise<ProcessInstance>;
    getJobs(id: string): Promise<Job[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    getSVG(processInstance: ProcessInstance): Promise<any>;
    jobCancel(job: Job): Promise<JobOperationResult>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(processInstance: ProcessInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(processInstance: ProcessInstance, node: any): Promise<void>;
    handleProcessVariableUpdate: (processInstance: ProcessInstance, updateJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    handleNodeInstanceCancel: (processInstance: ProcessInstance, node: NodeInstance) => Promise<void>;
    handleNodeInstanceRetrigger(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
}
export declare class GraphQLProcessDetailsQueries implements ProcessDetailsQueries {
    private readonly client;
    private readonly options?;
    constructor(client: ApolloClient<any>, options?: {
        transformEndpointBaseUrl?: (url?: string) => string | undefined;
    } | undefined);
    getProcessDetails(id: string): Promise<ProcessInstance>;
    getJobs(id: string): Promise<Job[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    getSVG(processInstance: ProcessInstance): Promise<SvgSuccessResponse | SvgErrorResponse>;
    jobCancel(job: Job): Promise<JobOperationResult>;
    rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(processInstance: ProcessInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(processInstance: ProcessInstance, node: any): Promise<void>;
    handleNodeInstanceCancel(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
    handleProcessVariableUpdate(processInstance: ProcessInstance, updateJson: Record<string, unknown>): Promise<Record<string, unknown>>;
    handleNodeInstanceRetrigger(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
}
//# sourceMappingURL=ProcessDetailsQueries.d.ts.map