import { jsx as _jsx } from "react/jsx-runtime";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { useWorkflowFormGatewayApi } from "../WorkflowForm";
import { EmbeddedWorkflowForm } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/workflowForm";
export const WorkflowFormContainer = ({ workflowDefinitionData, onStartWorkflowSuccess, onStartWorkflowError, onResetForm, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useWorkflowFormGatewayApi();
    return (_jsx(EmbeddedWorkflowForm, { ...componentOuiaProps(ouiaId, "workflow-form-container", ouiaSafe), driver: {
            async getCustomWorkflowSchema() {
                return gatewayApi.getCustomWorkflowSchema(workflowDefinitionData.workflowName, workflowDefinitionData.serviceUrl);
            },
            async resetBusinessKey() {
                onResetForm();
            },
            async startWorkflow(endpoint, data) {
                return gatewayApi
                    .startWorkflow(endpoint, data)
                    .then((id) => {
                    onStartWorkflowSuccess(id);
                })
                    .catch((error) => {
                    var _a, _b, _c, _d, _e, _f;
                    const message = (((_b = (_a = error === null || error === void 0 ? void 0 : error.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.message) &&
                        ((_d = (_c = error === null || error === void 0 ? void 0 : error.response) === null || _c === void 0 ? void 0 : _c.data) === null || _d === void 0 ? void 0 : _d.message) + " " + ((_f = (_e = error === null || error === void 0 ? void 0 : error.response) === null || _e === void 0 ? void 0 : _e.data) === null || _f === void 0 ? void 0 : _f.cause)) ||
                        (error === null || error === void 0 ? void 0 : error.message) ||
                        "Unknown error. More details in the developer tools console.";
                    onStartWorkflowError(message);
                });
            },
        }, targetOrigin: targetOrigin || window.location.origin, workflowDefinition: {
            workflowName: workflowDefinitionData.workflowName,
            endpoint: workflowDefinitionData.endpoint,
        } }));
};
//# sourceMappingURL=WorkflowFormContainer.js.map