import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useCallback } from "react";
import { ConstraintsExpression } from "./ConstraintsExpression";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { HelperText, HelperTextItem } from "@patternfly/react-core/dist/js/components/HelperText";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
const RANGE_CONSTRAINT_SEPARATOR = "..";
const CONSTRAINT_START_ID = "start";
const CONSTRAINT_END_ID = "end";
export function ConstraintsRange({ id, isReadOnly, value, expressionValue, type, typeHelper, onSave, isDisabled, renderOnPropertiesPanel, }) {
    const start = useMemo(() => { var _a, _b; return (_b = typeHelper.recover((_a = isRange(value !== null && value !== void 0 ? value : "", typeHelper.check)) === null || _a === void 0 ? void 0 : _a[0])) !== null && _b !== void 0 ? _b : ""; }, [typeHelper, value]);
    const end = useMemo(() => { var _a, _b; return (_b = typeHelper.recover((_a = isRange(value !== null && value !== void 0 ? value : "", typeHelper.check)) === null || _a === void 0 ? void 0 : _a[1])) !== null && _b !== void 0 ? _b : ""; }, [typeHelper, value]);
    const includeStart = useMemo(() => {
        if (value === undefined) {
            return true;
        }
        if (hasRangeStartStructure(value)) {
            if (value.charAt(0) === "[") {
                return true;
            }
            return false;
        }
        return true;
    }, [value]);
    const includeEnd = useMemo(() => {
        if (value === undefined) {
            return false;
        }
        if (hasRangeEndStructure(value)) {
            if (value.charAt(value.length - 1) === "]") {
                return true;
            }
            return false;
        }
        return false;
    }, [value]);
    const isStartValid = useCallback((args) => {
        if (type === DmnBuiltInDataType.String) {
            return true;
        }
        const parsedEnd = typeHelper.parse(args.end);
        const parsedStart = typeHelper.parse(args.start);
        return args.end !== "" ? (args.includeEnd ? parsedEnd >= parsedStart : parsedEnd > parsedStart) : true;
    }, [type, typeHelper]);
    const isEndValid = useCallback((args) => {
        if (type === DmnBuiltInDataType.String) {
            return true;
        }
        const parsedEnd = typeHelper.parse(args.end);
        const parsedStart = typeHelper.parse(args.start);
        return args.start !== "" ? (args.includeEnd ? parsedEnd >= parsedStart : parsedEnd > parsedStart) : true;
    }, [type, typeHelper]);
    const onInternalChange = useCallback((args) => {
        var _a, _b, _c, _d;
        if (args === undefined) {
            return;
        }
        const internalStart = (_a = args === null || args === void 0 ? void 0 : args.start) !== null && _a !== void 0 ? _a : start;
        const internalEnd = (_b = args === null || args === void 0 ? void 0 : args.end) !== null && _b !== void 0 ? _b : end;
        if (internalStart === "" && internalEnd === "") {
            onSave("");
            return;
        }
        onSave(`${((_c = args === null || args === void 0 ? void 0 : args.includeStart) !== null && _c !== void 0 ? _c : includeStart) ? "[" : "("}${typeHelper.transform(internalStart)}..${typeHelper.transform(internalEnd)}${((_d = args === null || args === void 0 ? void 0 : args.includeEnd) !== null && _d !== void 0 ? _d : includeEnd) ? "]" : ")"}`);
    }, [end, includeEnd, includeStart, onSave, start, typeHelper]);
    const onStartChange = useCallback((newStartValue) => {
        onInternalChange({ start: newStartValue });
    }, [onInternalChange]);
    const onEndChange = useCallback((newEndValue) => {
        onInternalChange({ end: newEndValue });
    }, [onInternalChange]);
    const onIncludeStartToogle = useCallback(() => {
        onInternalChange({ includeStart: !includeStart });
    }, [includeStart, onInternalChange]);
    const onIncludeEndToogle = useCallback(() => {
        onInternalChange({ includeEnd: !includeEnd });
    }, [includeEnd, onInternalChange]);
    const messages = useCallback((value, operator) => {
        if (type === DmnBuiltInDataType.Date && value !== "") {
            return `The next valid number is: (${value} ${operator} 1 Day).`;
        }
        if (type === DmnBuiltInDataType.DateTime && value !== "") {
            return `The next valid number is: (${value} ${operator} 1 Second).`;
        }
        if (type === DmnBuiltInDataType.DateTimeDuration && value !== "") {
            return `The next valid number is: (${value} ${operator} 1 Second).`;
        }
        if (type === DmnBuiltInDataType.Number && value !== "") {
            return `The next valid number is: (${value} ${operator} 2e-52).`;
        }
        if (type === DmnBuiltInDataType.Time && value !== "") {
            return `The next valid number is: (${value} ${operator} 1 Second).`;
        }
        if (type === DmnBuiltInDataType.YearsMonthsDuration && value !== "") {
            return `The next valid number is: (${value} ${operator} 1 Month).`;
        }
        return "";
    }, [type]);
    const onKeyDown = useCallback((e) => {
        var _a, _b, _c, _d;
        if (e.currentTarget.value[(_a = e.currentTarget.selectionStart) !== null && _a !== void 0 ? _a : 0] === "." &&
            e.currentTarget.value[((_b = e.currentTarget.selectionStart) !== null && _b !== void 0 ? _b : 2) - 2] === "." &&
            e.key === "Backspace") {
            e.preventDefault();
        }
        if ((e.currentTarget.value[(_c = e.currentTarget.selectionStart) !== null && _c !== void 0 ? _c : 0] === "." ||
            e.currentTarget.value[((_d = e.currentTarget.selectionStart) !== null && _d !== void 0 ? _d : 1) - 1] === ".") &&
            e.key === ".") {
            e.preventDefault();
        }
    }, []);
    return (_jsxs("div", { children: [_jsxs("div", { style: {
                    display: "grid",
                    gridTemplateColumns: "auto auto 1fr",
                    gridTemplateRows: "1fr 50px 70px 1fr 50px",
                    gridTemplateAreas: `
          'start includeStartButton startField'
          'empty1 arrow startDescription'
          'empty2 arrow empty3'
          'end includeEndButton endField'
          'empty4 empty5 endDescription'
          `,
                    columnGap: "10px",
                    alignItems: "center",
                }, children: [_jsx("div", { style: { gridArea: "start" }, children: _jsx(Label, { children: "Start" }) }), _jsx("div", { style: { gridArea: "includeStartButton" }, children: _jsx(Tooltip, { content: includeStart ? "Click to remove value from the range" : "Click to include value in the range", children: _jsx("button", { id: CONSTRAINT_START_ID, disabled: isReadOnly || isDisabled, onClick: () => onIncludeStartToogle(), style: {
                                    borderRadius: "100%",
                                    borderColor: "rgb(90 90 90)",
                                    borderStyle: "solid",
                                    borderWidth: "2px",
                                    width: "20px",
                                    height: "20px",
                                    backgroundColor: includeStart ? "rgb(90 90 90)" : "transparent",
                                } }) }) }), _jsx("div", { style: { gridArea: "startField" }, "data-testid": "kie-tools--dmn-editor--range-constraint-start-value", children: typeHelper.component({
                            autoFocus: start === "",
                            onBlur: () => onInternalChange(),
                            onChange: onStartChange,
                            id: "start-value",
                            isDisabled: isReadOnly || isDisabled,
                            placeholder: "Starts with",
                            style: {
                                outline: "none",
                            },
                            value: start,
                            isValid: isStartValid({ includeEnd, start, end }),
                            onKeyDown,
                        }) }), _jsx("div", { style: { gridArea: "startDescription" }, children: _jsx(HelperText, { children: _jsx(HelperTextItem, { variant: "indeterminate", children: includeStart
                                    ? "The starting value will be included in the range."
                                    : `The starting value will not be included in the range. ${messages(start, "+")}` }) }) }), _jsx("div", { style: { gridArea: "arrow", justifySelf: "center", alignSelf: "center", height: "100%" }, children: _jsx("div", { style: {
                                borderLeftStyle: "solid",
                                borderLeftColor: "rgb(90 90 90)",
                                borderLeftWidth: "2px",
                                height: "calc(100% + 18px)",
                                marginTop: "-10px",
                                marginBottom: "-8px",
                            } }) }), _jsx("div", { style: { gridArea: "end" }, children: _jsx(Label, { children: "End" }) }), _jsx("div", { style: { gridArea: "includeEndButton" }, children: _jsx(Tooltip, { content: includeEnd ? "Click to remove value from the range" : "Click to include value in the range", children: _jsx("button", { id: CONSTRAINT_END_ID, disabled: isReadOnly || isDisabled, onClick: () => onIncludeEndToogle(), style: {
                                    borderRadius: "100%",
                                    borderColor: "rgb(90 90 90)",
                                    borderStyle: "solid",
                                    borderWidth: "2px",
                                    width: "20px",
                                    height: "20px",
                                    backgroundColor: includeEnd ? "rgb(90 90 90)" : "transparent",
                                } }) }) }), _jsx("div", { style: { gridArea: "endField" }, "data-testid": "kie-tools--dmn-editor--range-constraint-end-value", children: typeHelper.component({
                            autoFocus: start !== "",
                            onBlur: () => onInternalChange(),
                            onChange: onEndChange,
                            id: "end-value",
                            isDisabled: isReadOnly || isDisabled,
                            placeholder: "Ends with",
                            style: { outline: "none" },
                            value: end,
                            isValid: isEndValid({ includeEnd, start, end }),
                            onKeyDown,
                        }) }), _jsx("div", { style: { gridArea: "endDescription" }, children: _jsx(HelperText, { children: _jsx(HelperTextItem, { variant: "indeterminate", children: includeEnd
                                    ? "The ending value will be included in the range."
                                    : `The ending value will not be included in the range. ${messages(end, "-")}` }) }) })] }), !renderOnPropertiesPanel && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx(ConstraintsExpression, { id: id, isReadOnly: true, value: expressionValue !== null && expressionValue !== void 0 ? expressionValue : "", type: type })] }))] }));
}
export function hasRangeStartStructure(value) {
    return value.startsWith("(") || value.startsWith("[") || value.startsWith("]");
}
export function hasRangeEndStructure(value) {
    return value.endsWith(")") || value.endsWith("]") || value.startsWith("[");
}
export function hasRangeStructure(value) {
    return (hasRangeStartStructure(value) && hasRangeEndStructure(value) && value.split(RANGE_CONSTRAINT_SEPARATOR).length === 2);
}
export function isRange(value, typeCheck) {
    if (value === undefined) {
        return undefined;
    }
    if (!hasRangeStructure(value)) {
        return undefined;
    }
    const rangeValues = value.split(RANGE_CONSTRAINT_SEPARATOR);
    if (rangeValues.length === 2 && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(rangeValues[0].slice(1))) && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(rangeValues[1].slice(0, -1)))) {
        return [rangeValues[0].slice(1), rangeValues[1].slice(0, -1)];
    }
    return undefined;
}
//# sourceMappingURL=ConstraintsRange.js.map