import { useEffect, useMemo, useState } from "react";
import { useNestedExpressionContainer, usePivotAwareNestedExpressionContainer, } from "./NestedExpressionContainerContext";
import { useResizingWidths, useResizingWidthsDispatch } from "./ResizingWidthsContext";
import { RELATION_EXPRESSION_COLUMN_MIN_WIDTH } from "./WidthConstants";
import { getExpressionMinWidth, getExpressionResizingWidth } from "./WidthMaths";
export function useNestedExpressionResizingWidthValue(isPivoting, nestedExpressions, fixedColumnActualWidth, fixedColumnResizingWidth, fixedColumnMinWidth, nestedExpressionMinWidth, extraWidth, widthsById, nestedExpressionsExtraWidths) {
    const { resizingWidths } = useResizingWidths();
    const nestedExpressionContainer = useNestedExpressionContainer();
    const pivotAwareNestedExpressionContainer = usePivotAwareNestedExpressionContainer(isPivoting);
    return useMemo(() => {
        var _a;
        if (nestedExpressionContainer.resizingWidth.isPivoting && !isPivoting) {
            return nestedExpressionContainer.resizingWidth.value - fixedColumnResizingWidth.value - extraWidth;
        }
        const nestedPivotingExpression = nestedExpressions.filter((e) => { var _a, _b, _c; return (_c = (_b = resizingWidths.get((_a = e === null || e === void 0 ? void 0 : e["@_id"]) !== null && _a !== void 0 ? _a : "")) === null || _b === void 0 ? void 0 : _b.isPivoting) !== null && _c !== void 0 ? _c : false; })[0];
        if (nestedPivotingExpression) {
            return Math.max(getExpressionResizingWidth(nestedPivotingExpression, resizingWidths, widthsById) +
                ((_a = nestedExpressionsExtraWidths === null || nestedExpressionsExtraWidths === void 0 ? void 0 : nestedExpressionsExtraWidths.get(nestedPivotingExpression["@_id"])) !== null && _a !== void 0 ? _a : 0), fixedColumnMinWidth);
        }
        const nestedExpressionContainerResizingWidthValue = fixedColumnResizingWidth.value >= fixedColumnActualWidth
            ? pivotAwareNestedExpressionContainer.resizingWidth.value
            : nestedExpressionContainer.actualWidth;
        return Math.max(nestedExpressionContainerResizingWidthValue - fixedColumnResizingWidth.value - extraWidth, ...nestedExpressions.map((e) => {
            var _a, _b;
            return getExpressionResizingWidth(e, new Map(), widthsById) +
                ((_b = nestedExpressionsExtraWidths === null || nestedExpressionsExtraWidths === void 0 ? void 0 : nestedExpressionsExtraWidths.get((_a = e === null || e === void 0 ? void 0 : e["@_id"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : 0);
        }), nestedExpressionMinWidth);
    }, [
        nestedExpressionContainer.resizingWidth.isPivoting,
        nestedExpressionContainer.resizingWidth.value,
        nestedExpressionContainer.actualWidth,
        isPivoting,
        nestedExpressions,
        fixedColumnResizingWidth.value,
        fixedColumnActualWidth,
        pivotAwareNestedExpressionContainer.resizingWidth.value,
        extraWidth,
        nestedExpressionMinWidth,
        resizingWidths,
        widthsById,
        fixedColumnMinWidth,
        nestedExpressionsExtraWidths,
    ]);
}
export function useNestedExpressionMinWidth(nestedExpressions, fixedColumnResizingWidth, nestedExpressionMinWidth, extraWidth) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    return useMemo(() => {
        return Math.max(nestedExpressionContainer.minWidth - fixedColumnResizingWidth.value - extraWidth, ...nestedExpressions.map((e) => getExpressionMinWidth(e)), nestedExpressionMinWidth);
    }, [
        nestedExpressionMinWidth,
        fixedColumnResizingWidth.value,
        extraWidth,
        nestedExpressionContainer.minWidth,
        nestedExpressions,
    ]);
}
export function useNestedExpressionActualWidth(nestedExpressions, fixedColumnActualWidth, extraWidth, widthsById) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    const { resizingWidths } = useResizingWidths();
    return useMemo(() => {
        return Math.max(nestedExpressionContainer.actualWidth - fixedColumnActualWidth - extraWidth, ...nestedExpressions
            .filter((e) => { var _a, _b, _c; return !((_c = (_b = resizingWidths.get((_a = e === null || e === void 0 ? void 0 : e["@_id"]) !== null && _a !== void 0 ? _a : "")) === null || _b === void 0 ? void 0 : _b.isPivoting) !== null && _c !== void 0 ? _c : false); })
            .map((expression) => getExpressionResizingWidth(expression, new Map(), widthsById)));
    }, [
        nestedExpressionContainer.actualWidth,
        fixedColumnActualWidth,
        extraWidth,
        nestedExpressions,
        resizingWidths,
        widthsById,
    ]);
}
export function useNestedExpressionContainerWithNestedExpressions({ nestedExpressions, fixedColumnActualWidth, fixedColumnResizingWidth, fixedColumnMinWidth, nestedExpressionMinWidth, extraWidth, expression, flexibleColumnIndex, widthsById, nestedExpressionsExtraWidths, }) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    const [flexibleColumnResizingWidth, setFlexibleColumnResizingWidth] = useState({
        isPivoting: false,
        value: 0,
    });
    const onColumnResizingWidthChange = useMemo(() => {
        return (args) => {
            const newResizingWidth = args.get(flexibleColumnIndex);
            if (newResizingWidth) {
                setFlexibleColumnResizingWidth(newResizingWidth);
            }
        };
    }, [flexibleColumnIndex]);
    const { resizingWidths } = useResizingWidths();
    const isPivoting = useMemo(() => {
        return (fixedColumnResizingWidth.isPivoting ||
            flexibleColumnResizingWidth.isPivoting ||
            nestedExpressions.some((e) => { var _a, _b; return (_b = resizingWidths.get((_a = e === null || e === void 0 ? void 0 : e["@_id"]) !== null && _a !== void 0 ? _a : "")) === null || _b === void 0 ? void 0 : _b.isPivoting; }));
    }, [fixedColumnResizingWidth.isPivoting, flexibleColumnResizingWidth.isPivoting, nestedExpressions, resizingWidths]);
    const nestedExpressionResizingWidthValue = useNestedExpressionResizingWidthValue(isPivoting, nestedExpressions, fixedColumnActualWidth, fixedColumnResizingWidth, fixedColumnMinWidth, nestedExpressionMinWidth, extraWidth, widthsById, nestedExpressionsExtraWidths);
    const maxNestedExpressionMinWidth = useNestedExpressionMinWidth(nestedExpressions, fixedColumnResizingWidth, nestedExpressionMinWidth, extraWidth);
    const nestedExpressionActualWidth = useNestedExpressionActualWidth(nestedExpressions, fixedColumnActualWidth, extraWidth, widthsById);
    const nestedExpressionContainerValue = useMemo(() => {
        return {
            minWidth: maxNestedExpressionMinWidth,
            actualWidth: nestedExpressionActualWidth,
            resizingWidth: {
                value: flexibleColumnResizingWidth.isPivoting
                    ? flexibleColumnResizingWidth.value
                    : nestedExpressionResizingWidthValue,
                isPivoting: isPivoting || nestedExpressionContainer.resizingWidth.isPivoting,
            },
        };
    }, [
        maxNestedExpressionMinWidth,
        nestedExpressionActualWidth,
        flexibleColumnResizingWidth.isPivoting,
        flexibleColumnResizingWidth.value,
        nestedExpressionResizingWidthValue,
        isPivoting,
        nestedExpressionContainer.resizingWidth.isPivoting,
    ]);
    const { updateResizingWidth } = useResizingWidthsDispatch();
    useEffect(() => {
        var _a;
        updateResizingWidth((_a = expression === null || expression === void 0 ? void 0 : expression["@_id"]) !== null && _a !== void 0 ? _a : "", (prev) => ({
            value: fixedColumnResizingWidth.value + nestedExpressionContainerValue.resizingWidth.value + extraWidth,
            isPivoting,
        }));
    }, [
        expression,
        nestedExpressionContainerValue.resizingWidth.value,
        isPivoting,
        updateResizingWidth,
        fixedColumnResizingWidth.value,
        extraWidth,
    ]);
    return useMemo(() => ({
        nestedExpressionContainerValue,
        onColumnResizingWidthChange,
        isPivoting,
    }), [nestedExpressionContainerValue, isPivoting, onColumnResizingWidthChange]);
}
export function useApportionedColumnWidthsIfNestedTable(beeTableRef, isPivoting, isNested, extraWidth, columns, columnResizingWidths, rows) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    useEffect(() => {
        var _a;
        if (isPivoting || !isNested) {
            return;
        }
        const fixedWidthAmount = columns.reduce((acc, { isFrozen, width, minWidth }) => (isFrozen ? acc + (width !== null && width !== void 0 ? width : minWidth) : acc), 0);
        const nextTotalWidth = Math.max(nestedExpressionContainer.minWidth - extraWidth, nestedExpressionContainer.resizingWidth.value - extraWidth) - fixedWidthAmount;
        const apportionedWidths = apportionColumnWidths(nextTotalWidth, columns.map(({ minWidth, width, isFrozen }) => ({
            minWidth,
            currentWidth: width !== null && width !== void 0 ? width : minWidth,
            isFrozen: isFrozen !== null && isFrozen !== void 0 ? isFrozen : false,
        })));
        const newColumnWidths = apportionedWidths.reduce((acc, nextWidth, index) => {
            if (columns[index].isFrozen) {
                return acc;
            }
            const columnIndex = index + 1;
            acc.set(columnIndex, {
                isPivoting: false,
                value: nextWidth,
            });
            return acc;
        }, new Map());
        (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.updateColumnResizingWidths(newColumnWidths);
    }, [
        columns,
        isPivoting,
        nestedExpressionContainer.resizingWidth.value,
        isNested,
        beeTableRef,
        rows,
        nestedExpressionContainer.minWidth,
        extraWidth,
    ]);
    const pivotingColumnIndex = useMemo(() => {
        const pivotingColumn = [...columnResizingWidths.entries()].find(([_, { isPivoting }]) => isPivoting);
        if (pivotingColumn) {
            const [pivotingColumnIndex] = pivotingColumn;
            return pivotingColumnIndex - 1;
        }
        else {
            return 0;
        }
    }, [columnResizingWidths]);
    const spaceToTheRight = useMemo(() => {
        var _a, _b;
        return nestedExpressionContainer.resizingWidth.value -
            ((_b = (_a = columnResizingWidths.get(0)) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : 0) -
            columns
                .slice(0, pivotingColumnIndex + 1)
                .reduce((acc, c, i) => { var _a, _b; return acc + ((_b = (_a = columnResizingWidths.get(i + 1)) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : 0); }, 0);
    }, [columnResizingWidths, columns, nestedExpressionContainer.resizingWidth.value, pivotingColumnIndex]);
    const isSmallerThanContainersMinWidth = useMemo(() => {
        return [...columnResizingWidths.values()].reduce((acc, w) => acc + w.value, 0) < nestedExpressionContainer.minWidth;
    }, [columnResizingWidths, nestedExpressionContainer.minWidth]);
    useEffect(() => {
        var _a;
        if (isPivoting && isSmallerThanContainersMinWidth) {
            const apportionedColumnWidths = apportionColumnWidths(spaceToTheRight, columns.slice(pivotingColumnIndex + 1).map((c) => {
                var _a;
                return ({
                    minWidth: c.minWidth,
                    currentWidth: (_a = c.width) !== null && _a !== void 0 ? _a : 0,
                    isFrozen: false,
                });
            }));
            const newColumnWidths = apportionedColumnWidths.reduce((acc, apportionedWidth, i) => {
                acc.set(pivotingColumnIndex + 1 + i + 1, {
                    isPivoting: false,
                    value: apportionedWidth,
                });
                return acc;
            }, new Map());
            (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.updateColumnResizingWidths(newColumnWidths);
        }
    }, [beeTableRef, columns, isPivoting, isSmallerThanContainersMinWidth, pivotingColumnIndex, spaceToTheRight]);
}
export function apportionColumnWidths(nextTotalWidth, columns) {
    const currentTotalWidth = columns.reduce((acc, { currentWidth, isFrozen }) => (isFrozen ? acc : acc + currentWidth), 0);
    const sd = currentTotalWidth / nextTotalWidth;
    const apportionedWidths = columns.map(({ minWidth, isFrozen }) => (isFrozen ? 0 : minWidth));
    let nextDistributedWidth = apportionedWidths.reduce((acc, n) => acc + n, 0);
    while (nextDistributedWidth !== nextTotalWidth) {
        let maxRemainder = 0;
        let maxRemainderIndex = 0;
        for (let i = 0; i < columns.length; i++) {
            if (columns[i].isFrozen) {
                continue;
            }
            const quota = columns[i].currentWidth / sd;
            const remainder = quota - apportionedWidths[i];
            if (remainder > maxRemainder) {
                maxRemainder = remainder;
                maxRemainderIndex = i;
            }
        }
        if (nextDistributedWidth > nextTotalWidth) {
            apportionedWidths[maxRemainderIndex]--;
            nextDistributedWidth--;
        }
        else {
            apportionedWidths[maxRemainderIndex]++;
            nextDistributedWidth++;
        }
    }
    return apportionedWidths.filter((w) => !isNaN(w));
}
export function useNestedTableLastColumnMinWidth(columnResizingWidths) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    return useMemo(() => {
        if (columnResizingWidths.size <= 1) {
            return;
        }
        const extraWidthOnTable = columnResizingWidths.size;
        const widthOfAllColumnsExceptLastOne = [...columnResizingWidths.entries()].reduce((acc, [columnIndex, { value }]) => {
            return columnIndex === columnResizingWidths.size - 1 ? acc : acc + value;
        }, 0);
        return Math.max(RELATION_EXPRESSION_COLUMN_MIN_WIDTH, nestedExpressionContainer.minWidth - extraWidthOnTable - widthOfAllColumnsExceptLastOne);
    }, [columnResizingWidths, nestedExpressionContainer.minWidth]);
}
//# sourceMappingURL=Hooks.js.map