/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public interface ResourceHandler<T, V extends VisitableBuilder<T, V>> {
    public String getKind();

    public String getApiVersion();

    default public T create(OkHttpClient client, Config config, String namespace, T item, boolean dryRun) {
        return (T)((WritableOperation)this.resource(client, config, namespace, item).dryRun(dryRun)).create(item);
    }

    default public T replace(OkHttpClient client, Config config, String namespace, T item, boolean dryRun) {
        return ((WritableOperation)this.resource(client, config, namespace, item).dryRun(dryRun)).replace(item);
    }

    default public T reload(OkHttpClient client, Config config, String namespace, T item) {
        return ((Gettable)this.resource(client, config, namespace, item).fromServer()).get();
    }

    public V edit(T var1);

    default public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, T item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)((WritableOperation)this.resource(client, config, namespace, item).dryRun(dryRun)).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    default public Watch watch(OkHttpClient client, Config config, String namespace, T item, Watcher<T> watcher) {
        return this.resource(client, config, namespace, item).watch(watcher);
    }

    default public Watch watch(OkHttpClient client, Config config, String namespace, T item, String resourceVersion, Watcher<T> watcher) {
        return this.resource(client, config, namespace, item).watch(resourceVersion, watcher);
    }

    default public Watch watch(OkHttpClient client, Config config, String namespace, T item, ListOptions listOptions, Watcher<T> watcher) {
        return this.resource(client, config, namespace, item).watch(listOptions, watcher);
    }

    default public T waitUntilReady(OkHttpClient client, Config config, String namespace, T item, long amount, TimeUnit timeUnit) {
        return this.resource(client, config, namespace, item).waitUntilReady(amount, timeUnit);
    }

    default public T waitUntilCondition(OkHttpClient client, Config config, String namespace, T item, Predicate<T> condition, long amount, TimeUnit timeUnit) {
        return this.resource(client, config, namespace, item).waitUntilCondition(condition, amount, timeUnit);
    }

    public Resource<T> resource(OkHttpClient var1, Config var2, String var3, T var4);

    public static class Key {
        private final String kind;
        private final String apiVersion;
        private final String repr;

        public Key(String kind, String apiVersion) {
            this.kind = kind;
            this.apiVersion = apiVersion;
            this.repr = String.format("Key[kind=`%s`, apiVersion=`%s`]", this.kind, this.apiVersion);
        }

        public String getKind() {
            return this.kind;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String toString() {
            return this.repr;
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.apiVersion);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.getKind().equals(other.getKind()) && this.getApiVersion().equals(other.getApiVersion());
        }
    }
}

