/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink.models;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.eclipse.persistence.annotations.PrimaryKey;

@Entity
@Table(name="POLICY_MAPPING_RECORDS", indexes={@Index(name="POLICY_MAPPING_RECORDS_BY_POLICY_INDEX", columnList="policyTypeCode,policyCatalogId,policyId,targetCatalogId,targetId")})
@PrimaryKey(columns={@Column(name="targetCatalogId"), @Column(name="targetId"), @Column(name="policyTypeCode"), @Column(name="policyCatalogId"), @Column(name="policyId")})
public class ModelPolicyMappingRecord {
    @Id
    private long targetCatalogId;
    @Id
    private long targetId;
    @Id
    private int policyTypeCode;
    @Id
    private long policyCatalogId;
    @Id
    private long policyId;
    private String parameters;
    @Version
    private long version;

    public long getTargetCatalogId() {
        return this.targetCatalogId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public int getPolicyTypeCode() {
        return this.policyTypeCode;
    }

    public long getPolicyCatalogId() {
        return this.policyCatalogId;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public String getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update(PolarisPolicyMappingRecord record) {
        this.targetCatalogId = record.getTargetCatalogId();
        this.targetId = record.getTargetId();
        this.policyTypeCode = record.getPolicyTypeCode();
        this.policyCatalogId = record.getPolicyCatalogId();
        this.policyId = record.getPolicyId();
        this.parameters = record.getParameters();
    }

    public static ModelPolicyMappingRecord fromPolicyMappingRecord(PolarisPolicyMappingRecord record) {
        if (record == null) {
            return null;
        }
        return ModelPolicyMappingRecord.builder().targetCatalogId(record.getTargetCatalogId()).targetId(record.getTargetId()).policyTypeCode(record.getPolicyTypeCode()).policyCatalogId(record.getPolicyCatalogId()).policyId(record.getPolicyId()).parameters(record.getParameters()).build();
    }

    public static PolarisPolicyMappingRecord toPolicyMappingRecord(ModelPolicyMappingRecord model) {
        if (model == null) {
            return null;
        }
        return new PolarisPolicyMappingRecord(model.getTargetCatalogId(), model.getTargetId(), model.getPolicyCatalogId(), model.getPolicyId(), model.getPolicyTypeCode(), model.getParameters());
    }

    public static final class Builder {
        private final ModelPolicyMappingRecord policyMappingRecord = new ModelPolicyMappingRecord();

        private Builder() {
        }

        public Builder targetCatalogId(long targetCatalogId) {
            this.policyMappingRecord.targetCatalogId = targetCatalogId;
            return this;
        }

        public Builder targetId(long targetId) {
            this.policyMappingRecord.targetId = targetId;
            return this;
        }

        public Builder policyTypeCode(int policyTypeCode) {
            this.policyMappingRecord.policyTypeCode = policyTypeCode;
            return this;
        }

        public Builder policyCatalogId(long policyCatalogId) {
            this.policyMappingRecord.policyCatalogId = policyCatalogId;
            return this;
        }

        public Builder policyId(long policyId) {
            this.policyMappingRecord.policyId = policyId;
            return this;
        }

        public Builder parameters(String parameters) {
            this.policyMappingRecord.parameters = parameters;
            return this;
        }

        public ModelPolicyMappingRecord build() {
            return this.policyMappingRecord;
        }
    }
}

