/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStats;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Queues;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionMap;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;

@Deprecated
public class PartitionStatsUtil {
    private PartitionStatsUtil() {
    }

    public static Collection<PartitionStats> computeStats(Table table, Snapshot snapshot) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table cannot be null");
        Preconditions.checkArgument((boolean)Partitioning.isPartitioned(table), (Object)"table must be partitioned");
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"snapshot cannot be null");
        Types.StructType partitionType = Partitioning.partitionType(table);
        List manifests = snapshot.allManifests(table.io());
        ConcurrentLinkedQueue statsByManifest = Queues.newConcurrentLinkedQueue();
        Tasks.foreach(manifests).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(manifest -> statsByManifest.add(PartitionStatsUtil.collectStats(table, manifest, partitionType)));
        return PartitionStatsUtil.mergeStats(statsByManifest, table.specs());
    }

    public static List<PartitionStats> sortStats(Collection<PartitionStats> stats, Types.StructType partitionType) {
        ArrayList entries = Lists.newArrayList(stats);
        entries.sort(PartitionStatsUtil.partitionStatsCmp(partitionType));
        return entries;
    }

    private static Comparator<PartitionStats> partitionStatsCmp(Types.StructType partitionType) {
        return Comparator.comparing(PartitionStats::partition, Comparators.forType((Types.StructType)partitionType));
    }

    private static PartitionMap<PartitionStats> collectStats(Table table, ManifestFile manifest, Types.StructType partitionType) {
        Object object;
        block10: {
            ManifestReader<?> reader = PartitionStatsUtil.openManifest(table, manifest);
            try {
                PartitionMap statsMap = PartitionMap.create(table.specs());
                int specId = manifest.partitionSpecId();
                PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
                PartitionData keyTemplate = new PartitionData(partitionType);
                for (ManifestEntry entry : reader.entries()) {
                    Object file = entry.file();
                    StructLike coercedPartition = PartitionUtil.coercePartition(partitionType, spec, file.partition());
                    PartitionData key = keyTemplate.copyFor(coercedPartition);
                    Snapshot snapshot = table.snapshot(entry.snapshotId().longValue());
                    PartitionStats stats = statsMap.computeIfAbsent(specId, ((PartitionData)file.partition()).copy(), () -> new PartitionStats(key, specId));
                    if (entry.isLive()) {
                        stats.liveEntry((ContentFile<?>)file, snapshot);
                        continue;
                    }
                    stats.deletedEntry(snapshot);
                }
                object = statsMap;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return object;
    }

    private static ManifestReader<?> openManifest(Table table, ManifestFile manifest) {
        List<String> projection = BaseScan.scanColumns(manifest.content());
        return ManifestFiles.open(manifest, table.io()).select(projection);
    }

    private static Collection<PartitionStats> mergeStats(Queue<PartitionMap<PartitionStats>> statsByManifest, Map<Integer, PartitionSpec> specs) {
        PartitionMap statsMap = PartitionMap.create(specs);
        for (PartitionMap partitionMap : statsByManifest) {
            partitionMap.forEach((key, value) -> statsMap.merge(key, value, (existingEntry, newEntry) -> {
                existingEntry.appendStats((PartitionStats)newEntry);
                return existingEntry;
            }));
        }
        return statsMap.values();
    }
}

