/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.function.BooleanSupplier;
import org.apache.polaris.core.persistence.pagination.ImmutablePageToken;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.pagination.Token;

final class PageTokenUtil {
    private static final ObjectMapper SMILE_MAPPER = new SmileMapper().findAndRegisterModules();
    static final PageToken READ_EVERYTHING = new PageToken(){

        @Override
        public OptionalInt pageSize() {
            return OptionalInt.empty();
        }

        @Override
        public Optional<Token> value() {
            return Optional.empty();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PageToken)) {
                return false;
            }
            PageToken other = (PageToken)obj;
            return other.pageSize().isEmpty() && other.value().isEmpty();
        }

        public String toString() {
            return "PageToken(everything)";
        }
    };

    static PageToken fromLimit(final int limit) {
        return new PageToken(){

            @Override
            public OptionalInt pageSize() {
                return OptionalInt.of(limit);
            }

            @Override
            public Optional<Token> value() {
                return Optional.empty();
            }

            public int hashCode() {
                return 2;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof PageToken)) {
                    return false;
                }
                PageToken other = (PageToken)obj;
                return other.pageSize().equals(this.pageSize()) && other.value().isEmpty();
            }

            public String toString() {
                return "PageToken(limit = " + limit + ")";
            }
        };
    }

    private PageTokenUtil() {
    }

    static PageToken decodePageRequest(@Nullable String requestedPageToken, @Nullable Integer requestedPageSize, BooleanSupplier shouldDecodeToken) {
        if (requestedPageToken != null && shouldDecodeToken.getAsBoolean()) {
            byte[] bytes = Base64.getUrlDecoder().decode(requestedPageToken);
            try {
                PageToken pageToken = (PageToken)SMILE_MAPPER.readValue(bytes, PageToken.class);
                if (requestedPageSize != null) {
                    int pageSizeInt = requestedPageSize;
                    Preconditions.checkArgument((pageSizeInt >= 0 ? 1 : 0) != 0, (Object)"Invalid page size");
                    if (pageToken.pageSize().orElse(-1) != pageSizeInt) {
                        pageToken = ImmutablePageToken.builder().from(pageToken).pageSize(pageSizeInt).build();
                    }
                }
                return pageToken;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (requestedPageSize != null && shouldDecodeToken.getAsBoolean()) {
            int pageSizeInt = requestedPageSize;
            Preconditions.checkArgument((pageSizeInt >= 0 ? 1 : 0) != 0, (Object)"Invalid page size");
            return PageTokenUtil.fromLimit(pageSizeInt);
        }
        return READ_EVERYTHING;
    }

    @Nullable
    static String encodePageToken(PageToken currentPageToken, @Nullable Token nextToken) {
        if (nextToken == null) {
            return null;
        }
        return PageTokenUtil.serializePageToken(ImmutablePageToken.builder().pageSize(currentPageToken.pageSize()).value(nextToken).build());
    }

    @Nullable
    @VisibleForTesting
    static String serializePageToken(PageToken pageToken) {
        if (pageToken == null) {
            return null;
        }
        try {
            byte[] serialized = SMILE_MAPPER.writeValueAsBytes((Object)pageToken);
            return Base64.getUrlEncoder().encodeToString(serialized);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static final class TokenTypeIdResolver
    extends TypeIdResolverBase {
        private JavaType baseType;

        public void init(JavaType bt) {
            this.baseType = bt;
        }

        public String idFromValue(Object value) {
            return this.getId(value);
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.getId(value);
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CUSTOM;
        }

        private String getId(Object value) {
            if (value instanceof Token) {
                return ((Token)value).getT();
            }
            return null;
        }

        public JavaType typeFromId(DatabindContext context, String id) {
            String idLower = id.toLowerCase(Locale.ROOT);
            Token.TokenType asType = Registry.BY_ID.get(idLower);
            if (asType == null) {
                throw new IllegalStateException("Cannot deserialize paging token value of type " + idLower);
            }
            if (this.baseType.getRawClass().isAssignableFrom(asType.javaType())) {
                return context.constructSpecializedType(this.baseType, asType.javaType());
            }
            Class concrete = this.baseType.getRawClass();
            return context.constructSpecializedType(this.baseType, concrete);
        }
    }

    private static final class Registry {
        private static final Map<String, Token.TokenType> BY_ID;

        private Registry() {
        }

        static {
            HashMap byId = new HashMap();
            ServiceLoader<Token.TokenType> loader = ServiceLoader.load(Token.TokenType.class);
            loader.stream().map(ServiceLoader.Provider::get).forEach(tokenType -> {
                Token.TokenType ex = byId.put(tokenType.id(), tokenType);
                if (ex != null) {
                    throw new IllegalStateException(String.format("Duplicate token type ID: from %s and %s", tokenType, ex));
                }
            });
            BY_ID = Collections.unmodifiableMap(byId);
        }
    }
}

