/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableDoubleSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

class ImmutableDoubleMapKeySet
extends AbstractImmutableDoubleSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private final double[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableDoubleMapKeySet(double[] keys, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !ImmutableDoubleMapKeySet.isEmptyKey(key) && !ImmutableDoubleMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
        }
        if (this.containsOneKey) {
            result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0.0));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1.0));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public double[] toArray(double[] array) {
        if (array.length < this.size()) {
            array = new double[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public boolean contains(double value) {
        if (Double.compare(value, 0.0) == 0) {
            return this.containsZeroKey;
        }
        if (Double.compare(value, 1.0) == 0) {
            return this.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(value)], value) == 0;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0.0);
        }
        if (this.containsOneKey) {
            procedure.value(1.0);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    @Override
    public ImmutableDoubleSet select(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.containsZeroKey && predicate.accept(0.0)) {
            result.add(0.0);
        }
        if (this.containsOneKey && predicate.accept(1.0)) {
            result.add(1.0);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableDoubleSet reject(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.containsZeroKey && !predicate.accept(0.0)) {
            result.add(0.0);
        }
        if (this.containsOneKey && !predicate.accept(1.0)) {
            result.add(1.0);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0.0));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1.0));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        if (this.containsZeroKey && predicate.accept(0.0)) {
            return 0.0;
        }
        if (this.containsOneKey && predicate.accept(1.0)) {
            return 1.0;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    @Override
    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept(0.0)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept(1.0)) {
            ++count;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1.0)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0.0)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1.0)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1.0)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double sum() {
        double nextSum;
        double adjustedValue;
        double result = 0.0;
        double compensation = 0.0;
        if (this.containsZeroKey) {
            adjustedValue = 0.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                double adjustedValue2 = this.keys[i] - compensation;
                double nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    @Override
    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double max = 0.0;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0.0;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
            max = 1.0;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && Double.compare(max, this.keys[i]) >= 0) continue;
            max = this.keys[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double min2 = 0.0;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min2 = 0.0;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1.0 < min2)) {
            min2 = 1.0;
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && Double.compare(this.keys[i], min2) >= 0) continue;
            min2 = this.keys[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0.0);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1.0);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableDoubleMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableDoubleSetSerializationProxy(this);
    }

    int probe(double element) {
        int index = this.mask((int)element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            double keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.doubleSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double keyAtIndex;
        while (Double.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ImmutableDoubleMapKeySet.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableDoubleMapKeySet.this.containsZeroKey) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableDoubleMapKeySet.this.containsOneKey) {
                    return 1.0;
                }
            }
            double[] keys = ImmutableDoubleMapKeySet.this.keys;
            while (!ImmutableDoubleMapKeySet.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = ImmutableDoubleMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

