/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.extractor;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ParsedContent {
    private final Optional<String> textualContent;
    private final Map<String, List<String>> metadata;

    public static ParsedContent empty() {
        return new ParsedContent(Optional.empty(), (Map<String, List<String>>)ImmutableMap.of());
    }

    public static ParsedContent of(String textualContent) {
        return new ParsedContent(Optional.of(textualContent), (Map<String, List<String>>)ImmutableMap.of());
    }

    public static ParsedContent of(Optional<String> textualContent) {
        return new ParsedContent(textualContent, (Map<String, List<String>>)ImmutableMap.of());
    }

    public static ParsedContent of(Optional<String> textualContent, Map<String, List<String>> metadata) {
        return new ParsedContent(textualContent, metadata);
    }

    private ParsedContent(Optional<String> textualContent, Map<String, List<String>> metadata) {
        this.textualContent = textualContent;
        this.metadata = metadata;
    }

    public Optional<String> getTextualContent() {
        return this.textualContent;
    }

    public Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public final boolean equals(Object o) {
        if (o instanceof ParsedContent) {
            ParsedContent that = (ParsedContent)o;
            return Objects.equals(this.textualContent, that.textualContent) && Objects.equals(this.metadata, that.metadata);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.textualContent, this.metadata);
    }
}

