/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MultiplexerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> filters;
    private final boolean preserveOriginal;
    public static final JsonpDeserializer<MultiplexerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiplexerTokenFilter::setupMultiplexerTokenFilterDeserializer);

    private MultiplexerTokenFilter(Builder builder) {
        super(builder);
        this.filters = ApiTypeHelper.unmodifiableRequired(builder.filters, (Object)this, "filters");
        this.preserveOriginal = ApiTypeHelper.requireNonNull(builder.preserveOriginal, this, "preserveOriginal");
    }

    public static MultiplexerTokenFilter of(Function<Builder, ObjectBuilder<MultiplexerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Multiplexer;
    }

    public final List<String> filters() {
        return this.filters;
    }

    public final boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "multiplexer");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartArray();
            for (String item0 : this.filters) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
    }

    protected static void setupMultiplexerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filters");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiplexerTokenFilter> {
        private List<String> filters;
        private Boolean preserveOriginal;

        public final Builder filters(List<String> list) {
            this.filters = Builder._listAddAll(this.filters, list);
            return this;
        }

        public final Builder filters(String value, String ... values) {
            this.filters = Builder._listAdd(this.filters, value, values);
            return this;
        }

        public final Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiplexerTokenFilter build() {
            this._checkSingleUse();
            return new MultiplexerTokenFilter(this);
        }
    }
}

