/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.serializer.SerializationContext;

public class AggCount
extends AggregatorBase {
    public AggCount() {
        super("COUNT", false, (ExprList)null);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        if (expr != null) {
            Log.warn((Object)this, (String)"Copying non-null expression for COUNT(*)");
        }
        return new AggCount();
    }

    @Override
    public Expr getExpr() {
        return null;
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCount();
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        return "count(*)";
    }

    @Override
    public String toString() {
        return "count(*)";
    }

    @Override
    public String toPrefixString() {
        return "(count)";
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 370;
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return other instanceof AggCount;
    }

    static class AccCount
    implements Accumulator {
        private long count = 0L;

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

