/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.wiki.WatchDog;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.WikiServletFilter;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.TextUtil;

public class WikiJSPFilter
extends WikiServletFilter {
    private static final Logger LOG = LogManager.getLogger(WikiJSPFilter.class);
    private String m_wiki_encoding;
    private boolean useEncoding;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.m_wiki_encoding = this.m_engine.getWikiProperties().getProperty("jspwiki.encoding");
        this.useEncoding = !Boolean.parseBoolean(this.m_engine.getWikiProperties().getProperty("jspwiki.nofilterencoding", "false").trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        WatchDog w = WatchDog.getCurrentWatchDog(this.m_engine);
        try {
            ThreadContext.push((String)(this.m_engine.getApplicationName() + ":" + ((HttpServletRequest)request).getRequestURI()));
            w.enterState("Filtering for URL " + ((HttpServletRequest)request).getRequestURI(), 90);
            JSPWikiServletResponseWrapper responseWrapper = new JSPWikiServletResponseWrapper((HttpServletResponse)response, this.m_wiki_encoding, this.useEncoding);
            request.setCharacterEncoding(this.m_engine.getContentEncoding().displayName());
            String pagename = URLConstructor.parsePageFromURL((HttpServletRequest)request, this.m_engine.getContentEncoding());
            this.fireEvent(24, pagename != null ? pagename : this.m_engine.getFrontPage());
            super.doFilter(request, (ServletResponse)responseWrapper, chain);
            try {
                w.enterState("Delivering response", 30);
                Context wikiContext = this.getWikiContext(request);
                String r = this.filter(wikiContext, (HttpServletResponse)responseWrapper);
                if (this.useEncoding) {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
                    out.write(r);
                    out.flush();
                    out.close();
                } else {
                    response.getWriter().write(r);
                }
                if (wikiContext != null) {
                    wikiContext.getWikiSession().clearMessages();
                }
                this.fireEvent(25, pagename);
            }
            finally {
                w.exitState();
            }
        }
        finally {
            w.exitState();
            ThreadContext.pop();
            ThreadContext.remove((String)(this.m_engine.getApplicationName() + ":" + ((HttpServletRequest)request).getRequestURI()));
        }
    }

    private String filter(Context wikiContext, HttpServletResponse response) {
        String string = response.toString();
        if (wikiContext != null) {
            String[] headers;
            String[] resourceTypes;
            for (String resourceType : resourceTypes = TemplateManager.getResourceTypes(wikiContext)) {
                string = this.insertResources(wikiContext, string, resourceType);
            }
            String[] stringArray = headers = TemplateManager.getResourceRequests(wikiContext, "httpheader");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String header;
                String key = header = stringArray[i];
                String value = "";
                int split = header.indexOf(58);
                if (split > 0 && split < header.length() - 1) {
                    key = header.substring(0, split);
                    value = header.substring(split + 1);
                }
                response.addHeader(key.trim(), value.trim());
            }
        }
        return string;
    }

    private String insertResources(Context wikiContext, String string, String type) {
        if (wikiContext == null) {
            return string;
        }
        String marker = TemplateManager.getMarker(wikiContext, type);
        int idx = string.indexOf(marker);
        if (idx == -1) {
            return string;
        }
        LOG.debug("...Inserting...");
        String[] resources = TemplateManager.getResourceRequests(wikiContext, type);
        StringBuilder concat = new StringBuilder(resources.length * 40);
        for (String resource : resources) {
            LOG.debug("...:::" + resource);
            concat.append(resource);
        }
        return TextUtil.replaceString((String)string, (int)idx, (int)(idx + marker.length()), (String)concat.toString());
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening((Object)this.m_engine)) {
            WikiEventManager.fireEvent((Object)this.m_engine, (WikiEvent)new WikiPageEvent((Object)this.m_engine, type, pagename));
        }
    }

    private static class JSPWikiServletResponseWrapper
    extends HttpServletResponseWrapper {
        final ByteArrayOutputStream m_output = new ByteArrayOutputStream(32768);
        private final ByteArrayServletOutputStream m_servletOut = new ByteArrayServletOutputStream(this.m_output);
        private final PrintWriter m_writer;
        private final HttpServletResponse m_response;
        private final boolean useEncoding;
        private static final int INIT_BUFFER_SIZE = 32768;

        public JSPWikiServletResponseWrapper(HttpServletResponse r, String wikiEncoding, boolean useEncoding) throws UnsupportedEncodingException {
            super(r);
            this.m_writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.m_servletOut), wikiEncoding), true);
            this.useEncoding = useEncoding;
            this.m_response = r;
        }

        public PrintWriter getWriter() {
            return this.m_writer;
        }

        public ServletOutputStream getOutputStream() {
            return this.m_servletOut;
        }

        public void flushBuffer() throws IOException {
            this.m_writer.flush();
            super.flushBuffer();
        }

        public String toString() {
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                LOG.error((Object)e);
                return "";
            }
            try {
                if (this.useEncoding) {
                    return this.m_output.toString(this.m_response.getCharacterEncoding());
                }
                return this.m_output.toString();
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)e);
                return "";
            }
        }

        class ByteArrayServletOutputStream
        extends ServletOutputStream {
            final ByteArrayOutputStream m_buffer;

            public ByteArrayServletOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
                this.m_buffer = byteArrayOutputStream;
            }

            public void write(int aInt) {
                this.m_buffer.write(aInt);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        }
    }
}

