/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.disk;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLock;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.impl.UnboundedPool;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StripedReadWriteLockProvider;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.disk.DiskSizeOfEngine;
import net.sf.ehcache.store.disk.DiskStorageFactory;
import net.sf.ehcache.store.disk.ElementSubstituteFilter;
import net.sf.ehcache.store.disk.HashEntry;
import net.sf.ehcache.store.disk.Segment;
import net.sf.ehcache.store.disk.StoreUpdateException;
import net.sf.ehcache.writer.CacheWriterManager;

public final class DiskStore
extends AbstractStore
implements TierableStore,
PoolableStore,
StripedReadWriteLockProvider {
    private static final int FFFFCD7D = -12931;
    private static final int FIFTEEN = 15;
    private static final int TEN = 10;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private static final int FOURTEEN = 14;
    private static final int SIXTEEN = 16;
    private static final int RETRIES_BEFORE_LOCK = 2;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_SEGMENT_COUNT = 64;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int SLEEP_INTERVAL_MS = 10;
    private final DiskStorageFactory disk;
    private final Random rndm = new Random();
    private final Segment[] segments;
    private final int segmentShift;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private final boolean tierPinned;
    private final boolean persistent;
    private volatile CacheLockProvider lockProvider;
    private volatile Set<Object> keySet;
    private volatile PoolAccessor onHeapPoolAccessor;
    private volatile PoolAccessor onDiskPoolAccessor;

    private DiskStore(DiskStorageFactory disk, Ehcache cache, Pool onHeapPool, Pool onDiskPool) {
        this.segments = new Segment[64];
        this.segmentShift = Integer.numberOfLeadingZeros(this.segments.length - 1);
        this.onHeapPoolAccessor = onHeapPool.createPoolAccessor(this, SizeOfPolicyConfiguration.resolveMaxDepth(cache), SizeOfPolicyConfiguration.resolveBehavior(cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
        this.onDiskPoolAccessor = onDiskPool.createPoolAccessor(this, new DiskSizeOfEngine());
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(16, 0.75f, disk, cache.getCacheConfiguration(), this.onHeapPoolAccessor, this.onDiskPoolAccessor, cache.getCacheEventNotificationService());
        }
        this.disk = disk;
        this.disk.bind(this);
        this.status.set(Status.STATUS_ALIVE);
        this.tierPinned = cache.getCacheConfiguration().getPinningConfiguration() != null && cache.getCacheConfiguration().getPinningConfiguration().getStore() == PinningConfiguration.Store.INCACHE;
        this.persistent = cache.getCacheConfiguration().isDiskPersistent();
    }

    public static DiskStore create(Ehcache cache, Pool onHeapPool, Pool onDiskPool) {
        if (cache.getCacheManager() == null) {
            throw new CacheException("Can't create diskstore without a cache manager");
        }
        DiskStorageFactory disk = new DiskStorageFactory(cache, cache.getCacheEventNotificationService());
        DiskStore store = new DiskStore(disk, cache, onHeapPool, onDiskPool);
        cache.getCacheConfiguration().addConfigurationListener(new CacheConfigurationListenerAdapter(disk, onDiskPool));
        return store;
    }

    public static DiskStore create(Cache cache) {
        return DiskStore.create(cache, new UnboundedPool(), new UnboundedPool());
    }

    @Override
    public void unpinAll() {
    }

    @Override
    public boolean isPinned(Object key) {
        return false;
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
    }

    public boolean cleanUpFailedMarker(Serializable key) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).cleanUpFailedMarker(key, hash);
    }

    @Override
    public StripedReadWriteLock createStripedReadWriteLock() {
        return new DiskStoreStripedReadWriteLock();
    }

    public void changeDiskCapacity(int newCapacity) {
        this.disk.setOnDiskCapacity(newCapacity);
    }

    @Override
    public boolean bufferFull() {
        return this.disk.bufferFull();
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.containsKey(key);
    }

    @Override
    public void expireElements() {
        this.disk.expireElements();
    }

    @Override
    public void flush() throws IOException {
        this.disk.flush();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        long size = this.onHeapPoolAccessor.getSize();
        if (size < 0L) {
            return 0L;
        }
        return size;
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    @Override
    public int getOnDiskSize() {
        return this.disk.getOnDiskSize();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        long size = this.onDiskPoolAccessor.getSize();
        if (size < 0L) {
            return this.disk.getOnDiskSizeInBytes();
        }
        return size;
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    public File getDataFile() {
        return this.disk.getDataFile();
    }

    public File getIndexFile() {
        return this.disk.getIndexFile();
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public void fill(Element e) {
        this.put(e);
    }

    @Override
    public boolean removeIfNotPinned(Object key) {
        return !this.tierPinned && this.remove(key) != null;
    }

    @Override
    public boolean put(Element element) {
        if (element == null) {
            return false;
        }
        Object key = element.getObjectKey();
        int hash = DiskStore.hash(key.hashCode());
        Element oldElement = this.segmentFor(hash).put(key, hash, element, false);
        return oldElement == null;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean newPut = this.put(element);
        if (writerManager != null) {
            try {
                writerManager.put(element);
            }
            catch (RuntimeException e) {
                throw new StoreUpdateException(e, !newPut);
            }
        }
        return newPut;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    public Object unretrievedGet(Object key) {
        if (key == null) {
            return null;
        }
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).unretrievedGet(key, hash);
    }

    public boolean putRawIfAbsent(Object key, DiskStorageFactory.DiskMarker encoded) throws IllegalArgumentException {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).putRawIfAbsent(key, hash, encoded);
    }

    @Override
    public List getKeys() {
        return new ArrayList<Object>(this.keySet());
    }

    public Set<Object> keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null, null);
    }

    @Override
    public void removeNoReturn(Object key) {
        if (key != null) {
            int hash = DiskStore.hash(key.hashCode());
            this.segmentFor(hash).removeNoReturn(key, hash);
        }
    }

    @Override
    public boolean isTierPinned() {
        return this.tierPinned;
    }

    @Override
    public Set getPresentPinnedKeys() {
        return Collections.emptySet();
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() {
        for (Segment s : this.segments) {
            s.clear();
        }
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            this.disk.unbind();
            this.onHeapPoolAccessor.unlink();
            this.onDiskPoolAccessor.unlink();
        }
    }

    @Override
    public int getSize() {
        Segment[] segs = this.segments;
        long size = -1L;
        for (int k = 0; k < 2 && (size = DiskStore.volatileSize(segs)) < 0L; ++k) {
        }
        if (size < 0L) {
            size = DiskStore.lockedSize(segs);
        }
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    private static long volatileSize(Segment[] segs) {
        int i;
        int[] mc = new int[segs.length];
        long check = 0L;
        long sum = 0L;
        int mcsum = 0;
        for (i = 0; i < segs.length; ++i) {
            sum += (long)segs[i].count;
            mc[i] = segs[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segs.length; ++i) {
                check += (long)segs[i].count;
                if (mc[i] == segs[i].modCount) continue;
                return -1L;
            }
        }
        if (check == sum) {
            return sum;
        }
        return -1L;
    }

    private static long lockedSize(Segment[] segs) {
        long size = 0L;
        for (Segment seg : segs) {
            seg.readLock().lock();
        }
        for (Segment seg : segs) {
            size += (long)seg.count;
        }
        for (Segment seg : segs) {
            seg.readLock().unlock();
        }
        return size;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean evictFromOnHeap(int count, long size) {
        return this.disk.evict(count) == count;
    }

    @Override
    public boolean evictFromOnDisk(int count, long size) {
        return this.disk.evict(count) == count;
    }

    @Override
    public float getApproximateDiskHitRate() {
        float sum = 0.0f;
        for (Segment s : this.segments) {
            sum += s.getDiskHitRate();
        }
        return sum;
    }

    @Override
    public float getApproximateDiskMissRate() {
        float sum = 0.0f;
        for (Segment s : this.segments) {
            sum += s.getDiskMissRate();
        }
        return sum;
    }

    @Override
    public long getApproximateDiskCountSize() {
        return this.getOnDiskSize();
    }

    @Override
    public long getApproximateDiskByteSize() {
        return this.getOnDiskSizeInBytes();
    }

    @Override
    public float getApproximateHeapHitRate() {
        return 0.0f;
    }

    @Override
    public float getApproximateHeapMissRate() {
        return 0.0f;
    }

    @Override
    public long getApproximateHeapCountSize() {
        return this.getInMemorySize();
    }

    @Override
    public long getApproximateHeapByteSize() {
        return this.getInMemorySizeInBytes();
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    @Override
    public Object getInternalContext() {
        if (this.lockProvider != null) {
            return this.lockProvider;
        }
        this.lockProvider = new LockProvider();
        return this.lockProvider;
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, true);
    }

    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, element, comparator);
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        Object key = element.getObjectKey();
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, element);
    }

    public boolean fault(Object key, DiskStorageFactory.Placeholder expect, DiskStorageFactory.DiskMarker fault) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).fault(key, hash, expect, fault);
    }

    public boolean evict(Object key, DiskStorageFactory.DiskSubstitute substitute) {
        return this.evictElement(key, substitute) != null;
    }

    public Element evictElement(Object key, DiskStorageFactory.DiskSubstitute substitute) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).evict(key, hash, substitute);
    }

    public List<DiskStorageFactory.DiskSubstitute> getRandomSample(ElementSubstituteFilter factory, int sampleSize, Object keyHint) {
        ArrayList<DiskStorageFactory.DiskSubstitute> sampled = new ArrayList<DiskStorageFactory.DiskSubstitute>(sampleSize);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift : DiskStore.hash(keyHint.hashCode()) >>> this.segmentShift;
        int segmentIndex = segmentStart;
        do {
            this.segments[segmentIndex].addRandomSample(factory, sampleSize, sampled, randomHash);
        } while (sampled.size() < sampleSize && (segmentIndex = segmentIndex + 1 & this.segments.length - 1) != segmentStart);
        return sampled;
    }

    private static int hash(int hash) {
        int spread = hash;
        spread += spread << 15 ^ 0xFFFFCD7D;
        spread ^= spread >>> 10;
        spread += spread << 3;
        spread ^= spread >>> 6;
        spread += (spread << 2) + (spread << 14);
        return spread ^ spread >>> 16;
    }

    private Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift];
    }

    private final class DiskStoreStripedReadWriteLock
    implements StripedReadWriteLock {
        private final net.sf.ehcache.concurrent.ReadWriteLockSync[] locks = new net.sf.ehcache.concurrent.ReadWriteLockSync[64];

        private DiskStoreStripedReadWriteLock() {
            for (int i = 0; i < this.locks.length; ++i) {
                this.locks[i] = new net.sf.ehcache.concurrent.ReadWriteLockSync();
            }
        }

        @Override
        public ReadWriteLock getLockForKey(Object key) {
            return this.getSyncForKey(key).getReadWriteLock();
        }

        @Override
        public List<net.sf.ehcache.concurrent.ReadWriteLockSync> getAllSyncs() {
            ArrayList<net.sf.ehcache.concurrent.ReadWriteLockSync> syncs = new ArrayList<net.sf.ehcache.concurrent.ReadWriteLockSync>(this.locks.length);
            Collections.addAll(syncs, this.locks);
            return syncs;
        }

        @Override
        public net.sf.ehcache.concurrent.ReadWriteLockSync getSyncForKey(Object key) {
            return this.locks[this.indexFor(key)];
        }

        private int indexFor(Object key) {
            return DiskStore.hash(key.hashCode()) >>> DiskStore.this.segmentShift;
        }
    }

    private static final class ReadWriteLockSync
    implements Sync {
        private final ReentrantReadWriteLock lock;

        private ReadWriteLockSync(ReentrantReadWriteLock lock) {
            this.lock = lock;
        }

        @Override
        public void lock(LockType type) {
            switch (type) {
                case READ: {
                    this.lock.readLock().lock();
                    break;
                }
                case WRITE: {
                    this.lock.writeLock().lock();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
                }
            }
        }

        @Override
        public boolean tryLock(LockType type, long msec) throws InterruptedException {
            switch (type) {
                case READ: {
                    return this.lock.readLock().tryLock(msec, TimeUnit.MILLISECONDS);
                }
                case WRITE: {
                    return this.lock.writeLock().tryLock(msec, TimeUnit.MILLISECONDS);
                }
            }
            throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
        }

        @Override
        public void unlock(LockType type) {
            switch (type) {
                case READ: {
                    this.lock.readLock().unlock();
                    break;
                }
                case WRITE: {
                    this.lock.writeLock().unlock();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread(LockType type) {
            switch (type) {
                case READ: {
                    throw new UnsupportedOperationException("Querying of read lock is not supported.");
                }
                case WRITE: {
                    return this.lock.isWriteLockedByCurrentThread();
                }
            }
            throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
        }
    }

    private final class KeyIterator
    extends HashIterator
    implements Iterator<Object> {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        private int segmentIndex;
        private Iterator<HashEntry> currentIterator;

        HashIterator() {
            this.segmentIndex = DiskStore.this.segments.length;
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        protected HashEntry nextEntry() {
            if (this.currentIterator == null) {
                return null;
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return this.currentIterator.next();
            }
            return null;
        }

        public void remove() {
            this.currentIterator.remove();
        }

        int getCurrentSegmentIndex() {
            return this.segmentIndex;
        }
    }

    private class LockProvider
    implements CacheLockProvider {
        private LockProvider() {
        }

        @Override
        public Sync getSyncForKey(Object key) {
            int hash = key == null ? 0 : DiskStore.hash(key.hashCode());
            return new ReadWriteLockSync(DiskStore.this.segmentFor(hash));
        }
    }

    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return DiskStore.this.getSize();
        }

        @Override
        public boolean contains(Object o) {
            return DiskStore.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return DiskStore.this.remove(o) != null;
        }

        @Override
        public void clear() {
            DiskStore.this.removeAll();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    private static final class CacheConfigurationListenerAdapter
    implements CacheConfigurationListener {
        private final DiskStorageFactory disk;
        private final Pool diskPool;

        private CacheConfigurationListenerAdapter(DiskStorageFactory disk, Pool diskPool) {
            this.disk = disk;
            this.diskPool = diskPool;
        }

        @Override
        public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
        }

        @Override
        public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
        }

        @Override
        public void diskCapacityChanged(int oldCapacity, int newCapacity) {
            this.disk.setOnDiskCapacity(newCapacity);
        }

        @Override
        public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        }

        @Override
        public void loggingChanged(boolean oldValue, boolean newValue) {
        }

        @Override
        public void registered(CacheConfiguration config) {
        }

        @Override
        public void deregistered(CacheConfiguration config) {
        }

        @Override
        public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        }

        @Override
        public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
            this.diskPool.setMaxSize(newValue);
        }
    }
}

