/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.eventspy.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyExecutionListener;
import org.apache.maven.eventspy.internal.EventSpyRepositoryListener;
import org.apache.maven.execution.ExecutionListener;
import org.eclipse.aether.RepositoryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class EventSpyDispatcher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EventSpy> eventSpies;

    @Inject
    public EventSpyDispatcher(List<EventSpy> eventSpies) {
        this.eventSpies = new ArrayList<EventSpy>(eventSpies);
    }

    public ExecutionListener chainListener(ExecutionListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyExecutionListener(this, listener);
    }

    public RepositoryListener chainListener(RepositoryListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyRepositoryListener(this, listener);
    }

    public void init(EventSpy.Context context) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.init(context);
            }
            catch (Exception | LinkageError e) {
                this.logError("initialize", e, eventSpy);
            }
        }
    }

    public void onEvent(Object event) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.onEvent(event);
            }
            catch (Exception | LinkageError e) {
                this.logError("notify", e, eventSpy);
            }
        }
    }

    public void close() {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.close();
            }
            catch (Exception | LinkageError e) {
                this.logError("close", e, eventSpy);
            }
        }
    }

    private void logError(String action, Throwable e, EventSpy spy) {
        String msg = "Failed to " + action + " spy " + spy.getClass().getName() + ": " + e.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, e);
        } else {
            this.logger.warn(msg);
        }
    }
}

