/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.RetainableByteBuffer;

public class ResetGenerator
extends FrameGenerator {
    public ResetGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) {
        ResetFrame resetFrame = (ResetFrame)frame;
        return this.generateReset(accumulator, resetFrame.getStreamId(), resetFrame.getError());
    }

    public int generateReset(RetainableByteBuffer.Mutable accumulator, int streamId, int error) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        this.generateHeader(accumulator, FrameType.RST_STREAM, 4, 0, streamId);
        accumulator.putInt(error);
        return 13;
    }
}

