/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utilslite;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;

@ThreadSafe
@SdkProtectedApi
public final class SdkInternalThreadLocal {
    private static final ThreadLocal<Map<String, String>> STORAGE = new InheritableThreadLocal<Map<String, String>>();

    private SdkInternalThreadLocal() {
    }

    public static void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Map<String, String> map = STORAGE.get();
        if (value == null) {
            if (map != null) {
                map.remove(key);
                if (map.isEmpty()) {
                    STORAGE.remove();
                }
            }
        } else {
            if (map == null) {
                map = new HashMap<String, String>();
                STORAGE.set(map);
            }
            map.put(key, value);
        }
    }

    public static String get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Map<String, String> map = STORAGE.get();
        return map != null ? map.get(key) : null;
    }

    public static String remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Map<String, String> map = STORAGE.get();
        return map != null ? map.remove(key) : null;
    }

    public static void clear() {
        STORAGE.remove();
    }

    public static boolean containsKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Map<String, String> map = STORAGE.get();
        return map != null && map.containsKey(key);
    }
}

