/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ProcessorsResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;

public class PGListProcessors
extends AbstractNiFiCommand<ProcessorsResult> {
    public PGListProcessors() {
        super("pg-list-processors", ProcessorsResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the list of processors for the specified process group. Listing can be scoped specific processors (source/destination)";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.FILTER.createOption());
    }

    @Override
    public ProcessorsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, CommandException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String filter = this.getArg(properties, CommandOption.FILTER);
        if (filter != null && !filter.equalsIgnoreCase("source") && !filter.equalsIgnoreCase("destination")) {
            throw new CommandException("Filter must be either 'source' or 'destination'");
        }
        ProcessGroupFlowEntity entity = client.getFlowClient().getProcessGroup(pgId);
        FlowDTO flow = entity.getProcessGroupFlow().getFlow();
        HashSet<ProcessorEntity> processors = new HashSet<ProcessorEntity>(this.getProcessors(client, flow, filter));
        ProcessorsEntity processorsEntity = new ProcessorsEntity();
        processorsEntity.setProcessors(processors);
        return new ProcessorsResult(this.getResultType(properties), processorsEntity);
    }

    private Set<ProcessorEntity> getProcessors(NiFiClient client, FlowDTO flow, String filter) throws NiFiClientException, IOException {
        HashSet<ProcessorEntity> processors = new HashSet<ProcessorEntity>();
        for (ProcessGroupEntity pg : flow.getProcessGroups()) {
            processors.addAll(this.getProcessors(client, pg, filter));
        }
        for (ProcessorEntity processor : flow.getProcessors()) {
            this.addProcessor(processors, flow, processor, filter);
        }
        return processors;
    }

    private Set<ProcessorEntity> getProcessors(NiFiClient client, ProcessGroupEntity pg, String filter) throws NiFiClientException, IOException {
        ProcessGroupFlowEntity entity = client.getFlowClient().getProcessGroup(pg.getId());
        FlowDTO flow = entity.getProcessGroupFlow().getFlow();
        return this.getProcessors(client, flow, filter);
    }

    private void addProcessor(Set<ProcessorEntity> listProcessors, FlowDTO flow, ProcessorEntity processor, String filter) {
        if (filter != null) {
            if ("source".equalsIgnoreCase(filter) && this.getInputRelNotSelfCount(flow, processor) == 0L && this.getOutputRelNotSelfCount(flow, processor) > 0L) {
                listProcessors.add(processor);
            } else if ("destination".equalsIgnoreCase(filter) && this.getOutputRelNotSelfCount(flow, processor) == 0L && this.getInputRelNotSelfCount(flow, processor) > 0L) {
                listProcessors.add(processor);
            }
        } else {
            listProcessors.add(processor);
        }
    }

    private long getInputRelNotSelfCount(FlowDTO flow, ProcessorEntity processor) {
        return flow.getConnections().stream().filter(c -> c.getComponent().getDestination().getId().equals(processor.getId()) && !c.getComponent().getSource().getId().equals(processor.getId())).count();
    }

    private long getOutputRelNotSelfCount(FlowDTO flow, ProcessorEntity processor) {
        return flow.getConnections().stream().filter(c -> c.getComponent().getSource().getId().equals(processor.getId()) && !c.getComponent().getDestination().getId().equals(processor.getId())).count();
    }
}

