/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.applicationcache.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v85.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class FrameWithManifest {
    private final FrameId frameId;
    private final String manifestURL;
    private final Integer status;

    public FrameWithManifest(FrameId frameId, String manifestURL, Integer status) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.manifestURL = Objects.requireNonNull(manifestURL, "manifestURL is required");
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getManifestURL() {
        return this.manifestURL;
    }

    public Integer getStatus() {
        return this.status;
    }

    private static FrameWithManifest fromJson(JsonInput input) {
        FrameId frameId = null;
        String manifestURL = null;
        Integer status = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "manifestURL": {
                    manifestURL = input.nextString();
                    continue block10;
                }
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameWithManifest(frameId, manifestURL, status);
    }
}

