/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.validation.BeanValidationProvider;

public abstract class AbstractValidationInterceptor
extends AbstractPhaseInterceptor<Message>
implements AutoCloseable {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractValidationInterceptor.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractValidationInterceptor.class);
    private Object serviceObject;
    private boolean customProvider;
    private volatile BeanValidationProvider provider;

    public AbstractValidationInterceptor(String phase) {
        super(phase);
    }

    public void setServiceObject(Object object) {
        this.serviceObject = object;
    }

    public void setProvider(BeanValidationProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        if (this.customProvider) {
            this.provider.close();
        }
    }

    @Override
    public void handleMessage(Message message) {
        ExecutableType[] execTypes;
        Object theServiceObject = this.getServiceObject(message);
        if (theServiceObject == null) {
            return;
        }
        Method method = this.getServiceMethod(message);
        if (method == null) {
            return;
        }
        ValidateOnExecution validateOnExec = method.getAnnotation(ValidateOnExecution.class);
        if (validateOnExec != null && (execTypes = validateOnExec.type()).length == 1 && execTypes[0] == ExecutableType.NONE) {
            return;
        }
        MessageContentsList arguments = MessageContentsList.getContentsList(message);
        this.handleValidation(message, theServiceObject, method, arguments);
    }

    protected Object getServiceObject(Message message) {
        FactoryInvoker factoryInvoker;
        Invoker invoker;
        if (this.serviceObject != null) {
            return this.serviceObject;
        }
        Object current = message.getExchange().get("org.apache.cxf.service.object");
        if (current != null) {
            return current;
        }
        Endpoint e = message.getExchange().getEndpoint();
        if (e != null && e.getService() != null && (invoker = e.getService().getInvoker()) instanceof FactoryInvoker && (factoryInvoker = (FactoryInvoker)invoker).isSingletonFactory()) {
            return factoryInvoker.getServiceObject(message.getExchange());
        }
        return null;
    }

    protected Method getServiceMethod(Message message) {
        Message inMessage = message.getExchange().getInMessage();
        Method method = null;
        if (inMessage != null) {
            method = MessageUtils.getTargetMethod(inMessage).orElse(null);
        }
        if (method == null) {
            method = message.getExchange().get(Method.class);
        }
        return method;
    }

    protected abstract void handleValidation(Message var1, Object var2, Method var3, List<Object> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanValidationProvider getProvider(Message message) {
        if (this.provider == null) {
            Object prop = message.getContextualProperty(BeanValidationProvider.class.getName());
            if (prop != null) {
                this.provider = (BeanValidationProvider)prop;
            } else {
                AbstractValidationInterceptor abstractValidationInterceptor = this;
                synchronized (abstractValidationInterceptor) {
                    if (this.provider == null) {
                        this.provider = new BeanValidationProvider();
                        this.customProvider = true;
                    }
                }
            }
        }
        return this.provider;
    }
}

