/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.cdx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class FieldSplitFormat {
    protected final List<String> names;
    protected final HashMap<String, Integer> nameToIndex;

    public FieldSplitFormat(String commaSepList) {
        this(commaSepList.split(","));
    }

    public FieldSplitFormat(String ... names) {
        this(Arrays.asList(names));
    }

    public FieldSplitFormat(List<String> names) {
        this.names = names;
        this.nameToIndex = new HashMap();
        for (int i = 0; i < names.size(); ++i) {
            this.nameToIndex.put(names.get(i), i);
        }
    }

    public FieldSplitFormat addFieldNames(String ... newNameArray) {
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.addAll(this.names);
        for (String name : newNameArray) {
            newNames.add(name);
        }
        return new FieldSplitFormat(newNames);
    }

    public FieldSplitFormat createSubset(FieldSplitFormat input) {
        ArrayList<String> newFields = new ArrayList<String>();
        for (int i = 0; i < input.getLength(); ++i) {
            String field = input.getName(i);
            if (!this.nameToIndex.containsKey(field)) continue;
            newFields.add(field);
        }
        return new FieldSplitFormat(newFields);
    }

    public FieldSplitFormat createSubset(String commaSepList) {
        String[] fields = commaSepList.split(",");
        ArrayList<String> newFields = new ArrayList<String>();
        for (String field : fields) {
            if (!this.nameToIndex.containsKey(field)) continue;
            newFields.add(field);
        }
        return new FieldSplitFormat(newFields);
    }

    public int getFieldIndex(String name) {
        Integer val = this.nameToIndex.get(name);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public int getLength() {
        return this.names.size();
    }

    public String getName(int i) {
        return this.names.get(i);
    }
}

