/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.text.html;

import java.util.Locale;
import org.htmlparser.Node;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;

public class NodeUtils {
    public static final String SCRIPT_TAG_NAME = "SCRIPT";
    public static final String STYLE_TAG_NAME = "STYLE";

    public static boolean isTagNode(Node node) {
        return node instanceof TagNode;
    }

    public static boolean isTextNode(Node node) {
        return node instanceof TextNode;
    }

    public static boolean isRemarkNode(Node node) {
        return node instanceof RemarkNode;
    }

    public static boolean isTagNodeNamed(Node node, String name) {
        if (NodeUtils.isTagNode(node)) {
            TagNode tagNode = (TagNode)node;
            String nodeName = tagNode.getTagName();
            return nodeName.equals(name.toUpperCase(Locale.ROOT));
        }
        return false;
    }

    public static boolean isOpenTagNodeNamed(Node node, String name) {
        TagNode tagNode;
        if (NodeUtils.isTagNode(node) && !(tagNode = (TagNode)node).isEndTag()) {
            String nodeName = tagNode.getTagName();
            return nodeName.equals(name.toUpperCase(Locale.ROOT));
        }
        return false;
    }

    public static boolean isNonEmptyOpenTagNodeNamed(Node node, String name) {
        TagNode tagNode;
        if (NodeUtils.isTagNode(node) && !(tagNode = (TagNode)node).isEndTag() && !tagNode.isEmptyXmlTag()) {
            String nodeName = tagNode.getTagName();
            return nodeName.equals(name.toUpperCase(Locale.ROOT));
        }
        return false;
    }

    public static boolean isCloseTagNodeNamed(Node node, String name) {
        TagNode tagNode;
        if (NodeUtils.isTagNode(node) && (tagNode = (TagNode)node).isEndTag()) {
            String nodeName = tagNode.getTagName();
            return nodeName.equals(name.toUpperCase(Locale.ROOT));
        }
        return false;
    }
}

