/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.domains.EffectiveTldFinder;
import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapIndex;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMapCrossSubmitValidator {
    public static final Logger LOG = LoggerFactory.getLogger(SiteMapCrossSubmitValidator.class);

    private SiteMapCrossSubmitValidator() {
    }

    public static void validateSiteMapURLs(SiteMap sitemap) {
        LOG.debug("Validating sitemap URLs for prefix {}", (Object)sitemap.getBaseUrl());
        SiteMapCrossSubmitValidator.validateSiteMapURLs(sitemap, (URL url) -> SiteMapParser.urlIsValid(sitemap.getBaseUrl(), url.toString()));
    }

    public static void validateSiteMapURLs(SiteMap sitemap, String host) {
        LOG.debug("Validating sitemap URLs for cross-submit host {}", (Object)host);
        SiteMapCrossSubmitValidator.validateSiteMapURLs(sitemap, (URL url) -> url.getHost().equals(host));
    }

    public static void validateSiteMapURLs(SiteMap sitemap, Collection<String> hosts) {
        LOG.debug("Validating sitemap URLs against a set of cross-submit hosts {}", hosts);
        SiteMapCrossSubmitValidator.validateSiteMapURLs(sitemap, (URL url) -> hosts.contains(url.getHost()));
    }

    protected static boolean validate(URL url, Collection<String> domains, CrossSubmitValidationLevel domainValidationLevel) {
        switch (domainValidationLevel) {
            case ICANN_DOMAIN: {
                String domain = EffectiveTldFinder.getAssignedDomain(url.getHost(), false, true);
                return domains.contains(domain);
            }
            case PRIVATE_DOMAIN: {
                String domain = EffectiveTldFinder.getAssignedDomain(url.getHost(), false, false);
                return domains.contains(domain);
            }
        }
        return domains.contains(url.getHost());
    }

    public static void validateSiteMapURLs(SiteMap sitemap, Collection<String> domains, CrossSubmitValidationLevel domainValidationLevel) {
        LOG.debug("Validating sitemap URLs against a set of cross-submit sites {} ({})", domains, (Object)domainValidationLevel);
        SiteMapCrossSubmitValidator.validateSiteMapURLs(sitemap, (URL url) -> SiteMapCrossSubmitValidator.validate(url, domains, domainValidationLevel));
    }

    public static void validateSiteMapURLs(SiteMap sitemap, Predicate<URL> validator) {
        Iterator<SiteMapURL> iter = sitemap.getSiteMapUrls().iterator();
        int validated = 0;
        int invalid = 0;
        while (iter.hasNext()) {
            SiteMapURL u = iter.next();
            ++validated;
            if (validator.test(u.getUrl())) continue;
            LOG.debug("Removing URL: {}", (Object)u.toString());
            iter.remove();
            ++invalid;
        }
        LOG.debug("Validated {} sitemap URLs: {} valid, {} invalid", new Object[]{validated, validated - invalid, invalid});
    }

    public static void validateSiteMapURLs(AbstractSiteMap sitemap, Collection<String> domains, CrossSubmitValidationLevel domainValidationLevel) {
        if (sitemap.isIndex()) {
            Collection<AbstractSiteMap> sitemaps = ((SiteMapIndex)sitemap).getSitemaps();
            for (AbstractSiteMap asm : sitemaps) {
                SiteMapCrossSubmitValidator.validateSiteMapURLs(asm, domains, domainValidationLevel);
            }
        } else {
            SiteMapCrossSubmitValidator.validateSiteMapURLs((SiteMap)sitemap, domains, domainValidationLevel);
        }
    }

    public static enum CrossSubmitValidationLevel {
        ICANN_DOMAIN,
        PRIVATE_DOMAIN,
        HOST;

    }
}

