/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.parser.ocr.tess4j.ImageDeskew;
import org.apache.tika.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImagePreprocessor
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ImagePreprocessor.class);
    private static final double MINIMUM_DESKEW_THRESHOLD = 1.0;
    private final String fullImageMagickPath;

    ImagePreprocessor(String fullImageMagickPath) {
        this.fullImageMagickPath = fullImageMagickPath;
    }

    void process(Path sourceFile, Path targFile, Metadata metadata, TesseractOCRConfig config) throws IOException {
        double angle;
        double d = angle = config.isApplyRotation() ? this.getAngle(sourceFile, metadata) : 0.0;
        if (config.isEnableImagePreprocessing() || config.isApplyRotation() && angle != 0.0) {
            CommandLine commandLine = new CommandLine(this.fullImageMagickPath);
            if (SystemUtils.IS_OS_WINDOWS) {
                commandLine.addArgument("convert");
            }
            List<String> density = Arrays.asList("-density", Integer.toString(config.getDensity()));
            List<String> depth = Arrays.asList("-depth", Integer.toString(config.getDepth()));
            List<String> colorspace = Arrays.asList("-colorspace", config.getColorspace());
            List<String> filter = Arrays.asList("-filter", config.getFilter());
            List<String> resize = Arrays.asList("-resize", config.getResize() + "%");
            List<String> rotate = Arrays.asList("-rotate", Double.toString(-angle));
            List<String> sourceFileArg = Collections.singletonList(sourceFile.toAbsolutePath().toString());
            List<String> targFileArg = Collections.singletonList(targFile.toAbsolutePath().toString());
            Stream<List> stream = Stream.empty();
            if (angle == 0.0) {
                if (config.isEnableImagePreprocessing()) {
                    stream = Stream.of(density, depth, colorspace, filter, resize, sourceFileArg, targFileArg);
                }
            } else if (config.isEnableImagePreprocessing()) {
                stream = Stream.of(density, depth, colorspace, filter, resize, rotate, sourceFileArg, targFileArg);
            } else if (config.isApplyRotation()) {
                stream = Stream.of(rotate, sourceFileArg, targFileArg);
            }
            String[] args = (String[])stream.flatMap(Collection::stream).toArray(String[]::new);
            commandLine.addArguments(args, true);
            DefaultExecutor executor = DefaultExecutor.builder().get();
            try {
                executor.execute(commandLine);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("ImageMagick failed (commandline: " + String.valueOf(commandLine) + ")", (Throwable)e);
            }
            metadata.add(TesseractOCRParser.IMAGE_MAGICK, "true");
        }
    }

    private double getAngle(Path sourceFile, Metadata metadata) throws IOException {
        BufferedImage bi = ImageIO.read(sourceFile.toFile());
        ImageDeskew id = new ImageDeskew(bi);
        double angle = id.getSkewAngle();
        if (angle < 1.0 && angle > -1.0) {
            LOG.debug("Changing angle " + angle + " to 0.0");
            angle = 0.0;
        } else {
            metadata.add(TesseractOCRParser.IMAGE_ROTATION, String.format(Locale.getDefault(), "%.3f", angle));
        }
        return angle;
    }
}

