/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.session.CapabilityTransform;
import org.openqa.selenium.remote.session.ProxyTransform;
import org.openqa.selenium.remote.session.StripAnyPlatform;
import org.openqa.selenium.remote.session.W3CPlatformNameNormaliser;

public class CapabilitiesUtils {
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();

    private CapabilitiesUtils() {
    }

    public static Stream<Map<String, Object>> makeW3CSafe(Map<String, Object> possiblyInvalidCapabilities) {
        Require.nonNull((String)"Capabilities", possiblyInvalidCapabilities);
        ImmutableSet adapters = ImmutableSet.of();
        HashSet usedKeys = new HashSet();
        List firsts = (List)adapters.stream().map(adapter -> adapter.apply(possiblyInvalidCapabilities)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).peek(map -> usedKeys.addAll(map.keySet())).collect(ImmutableList.toImmutableList());
        if (firsts.isEmpty()) {
            firsts = ImmutableList.of((Object)ImmutableMap.of());
        }
        Map always = (Map)possiblyInvalidCapabilities.entrySet().stream().filter(entry -> !usedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Stream<Map<String, Object>> fromOss = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build()).map(CapabilitiesUtils::applyTransforms).map(map -> (Map)map.entrySet().stream().filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        return fromOss;
    }

    public static Map<String, Object> applyTransforms(Map<String, Object> caps) {
        LinkedList<Map.Entry<String, Object>> toExamine = new LinkedList<Map.Entry<String, Object>>(caps.entrySet());
        HashSet<String> seenKeys = new HashSet<String>();
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        Set<CapabilityTransform> transforms = CapabilitiesUtils.getCapabilityTransforms();
        block0: while (!toExamine.isEmpty()) {
            Map.Entry<String, Object> entry = (Map.Entry<String, Object>)toExamine.remove();
            seenKeys.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            for (CapabilityTransform transform : transforms) {
                Collection<Map.Entry<String, Object>> result = transform.apply(entry);
                if (result == null) {
                    toReturn.remove(entry.getKey());
                    continue block0;
                }
                for (Map.Entry<String, Object> newEntry : result) {
                    if (!seenKeys.contains(newEntry.getKey())) {
                        toExamine.add(newEntry);
                        continue;
                    }
                    if (newEntry.getKey().equals(entry.getKey())) {
                        entry = newEntry;
                    }
                    toReturn.put(newEntry.getKey(), newEntry.getValue());
                }
            }
        }
        return toReturn;
    }

    private static Set<CapabilityTransform> getCapabilityTransforms() {
        ImmutableSet.Builder transforms = ImmutableSet.builder();
        ServiceLoader.load(CapabilityTransform.class).forEach(arg_0 -> ((ImmutableSet.Builder)transforms).add(arg_0));
        transforms.add((Object)new ProxyTransform()).add((Object)new StripAnyPlatform()).add((Object)new W3CPlatformNameNormaliser());
        return transforms.build();
    }
}

