/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.internal.monitor.impl.EmptyLocalReplicatedMapStats;
import com.hazelcast.internal.monitor.impl.LocalReplicatedMapStatsImpl;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.replicatedmap.LocalReplicatedMapStats;
import com.hazelcast.replicatedmap.impl.PartitionContainer;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

class LocalReplicatedMapStatsProvider {
    private static final LocalReplicatedMapStats EMPTY_LOCAL_MAP_STATS = new EmptyLocalReplicatedMapStats();
    private final ConcurrentHashMap<String, LocalReplicatedMapStatsImpl> statsMap = new ConcurrentHashMap();
    private final ConstructorFunction<String, LocalReplicatedMapStatsImpl> statsConstructorFunction = arg -> new LocalReplicatedMapStatsImpl();
    private final Config config;
    private final PartitionContainer[] partitionContainers;

    LocalReplicatedMapStatsProvider(Config config, PartitionContainer[] partitionContainers) {
        this.config = config;
        this.partitionContainers = partitionContainers;
    }

    LocalReplicatedMapStatsImpl getLocalReplicatedMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.statsConstructorFunction);
    }

    LocalReplicatedMapStats getLocalReplicatedMapStats(String name) {
        LocalReplicatedMapStats result;
        ReplicatedMapConfig replicatedMapConfig = this.getReplicatedMapConfig(name);
        if (!replicatedMapConfig.isStatisticsEnabled()) {
            result = EMPTY_LOCAL_MAP_STATS;
        } else {
            LocalReplicatedMapStatsImpl stats = this.getLocalReplicatedMapStatsImpl(name);
            long hits = 0L;
            long count = 0L;
            long memoryUsage = 0L;
            boolean isBinary = replicatedMapConfig.getInMemoryFormat() == InMemoryFormat.BINARY;
            for (PartitionContainer container : this.partitionContainers) {
                ReplicatedRecordStore store = container.getRecordStore(name);
                if (store == null) continue;
                Iterator<ReplicatedRecord> iterator = store.recordIterator();
                while (iterator.hasNext()) {
                    ReplicatedRecord record = iterator.next();
                    stats.setLastAccessTime(Math.max(stats.getLastAccessTime(), record.getLastAccessTime()));
                    stats.setLastUpdateTime(Math.max(stats.getLastUpdateTime(), record.getUpdateTime()));
                    hits += record.getHits();
                    if (isBinary) {
                        memoryUsage += (long)((HeapData)record.getValueInternal()).getHeapCost();
                    }
                    ++count;
                }
            }
            stats.setOwnedEntryCount(count);
            stats.setHits(hits);
            stats.setOwnedEntryMemoryCost(memoryUsage);
            result = stats;
        }
        return result;
    }

    private ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return this.config.findReplicatedMapConfig(name);
    }
}

