/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class URIPreconditions {
    public static void checkURI(@NonNull String uri, @NonNull Predicate<URI> predicate) throws IllegalArgumentException {
        URIPreconditions.checkURI(uri, predicate, null);
    }

    public static void checkURIIfPresent(@Nullable String uri, @NonNull Predicate<URI> predicate) throws IllegalArgumentException {
        URIPreconditions.checkURIIfPresent(uri, predicate, null);
    }

    public static void checkURIIfPresent(@Nullable String uri, @NonNull Predicate<URI> predicate, @Nullable String errorMessage) throws IllegalArgumentException {
        if (uri == null || uri.length() == 0) {
            return;
        }
        URIPreconditions.checkURI(uri, predicate, errorMessage);
    }

    public static void checkURI(@NonNull String uri, @NonNull Predicate<URI> predicate, @Nullable String errorMessage) throws IllegalArgumentException {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(predicate, "predicate");
        try {
            URI u = new URI(uri);
            if (!predicate.test(u)) {
                throw new IllegalArgumentException(errorMessage == null ? "Illegal syntax: " + uri : errorMessage);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(errorMessage == null ? "Illegal syntax: " + uri : errorMessage);
        }
    }
}

